/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/browsers/WebBrowserUrlProvider;", "Lcom/intellij/openapi/project/PossiblyDumbAware;", "<init>", "()V", "canHandleElement", "", "request", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "getUrl", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getUrls", "", "BrowserException", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nWebBrowserUrlProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebBrowserUrlProvider.kt\ncom/intellij/ide/browsers/WebBrowserUrlProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public abstract class WebBrowserUrlProvider
implements PossiblyDumbAware {
    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        Collection<Url> collection;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            collection = this.getUrls(request);
        }
        catch (BrowserException browserException) {
            return false;
        }
        Collection<Url> urls = collection;
        if (!urls.isEmpty()) {
            request.setResult(urls);
            return true;
        }
        return false;
    }

    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile file) throws BrowserException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }

    @NotNull
    public Collection<Url> getUrls(@NotNull OpenInBrowserRequest request) throws BrowserException {
        Url url;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        VirtualFile virtualFile = request.getVirtualFile();
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            url = this.getUrl(request, it);
        } else {
            url = null;
        }
        return CollectionsKt.listOfNotNull(url);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/browsers/WebBrowserUrlProvider$BrowserException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "<init>", "(Ljava/lang/String;)V", "intellij.platform.ide"})
    public static final class BrowserException
    extends Exception {
        public BrowserException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

