/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.CachedIconPresentation;
import com.intellij.ide.util.treeView.CachedPresentationData;
import com.intellij.ide.util.treeView.CachedTreePathElement;
import com.intellij.ide.util.treeView.CachedTreePresentation;
import com.intellij.ide.util.treeView.CachedTreePresentationKt;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeIconCachingKt;
import com.intellij.ide.util.treeView.TreeNodeWithCacheableAttributes;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.application.AccessToken;
import com.intellij.ui.treeStructure.CachingTreePath;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0015\u001a\u00020\bH\u0016J\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/util/treeView/CachedTreePresentationData;", "", "pathElement", "Lcom/intellij/ide/util/treeView/CachedTreePathElement;", "presentation", "Lcom/intellij/ide/util/treeView/CachedPresentationData;", "extraAttributes", "", "", "children", "", "<init>", "(Lcom/intellij/ide/util/treeView/CachedTreePathElement;Lcom/intellij/ide/util/treeView/CachedPresentationData;Ljava/util/Map;Ljava/util/List;)V", "getPathElement", "()Lcom/intellij/ide/util/treeView/CachedTreePathElement;", "getPresentation", "()Lcom/intellij/ide/util/treeView/CachedPresentationData;", "getExtraAttributes", "()Ljava/util/Map;", "getChildren", "()Ljava/util/List;", "toString", "createTree", "Lcom/intellij/ide/util/treeView/CachedTreePresentation;", "Companion", "intellij.platform.ide"})
@ApiStatus.Internal
public final class CachedTreePresentationData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CachedTreePathElement pathElement;
    @NotNull
    private final CachedPresentationData presentation;
    @Nullable
    private final Map<String, String> extraAttributes;
    @NotNull
    private final List<CachedTreePresentationData> children;

    public CachedTreePresentationData(@NotNull CachedTreePathElement pathElement, @NotNull CachedPresentationData presentation, @Nullable Map<String, String> extraAttributes, @NotNull List<CachedTreePresentationData> children) {
        Intrinsics.checkNotNullParameter((Object)pathElement, (String)"pathElement");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.pathElement = pathElement;
        this.presentation = presentation;
        this.extraAttributes = extraAttributes;
        this.children = children;
    }

    @NotNull
    public final CachedTreePathElement getPathElement() {
        return this.pathElement;
    }

    @NotNull
    public final CachedPresentationData getPresentation() {
        return this.presentation;
    }

    @Nullable
    public final Map<String, String> getExtraAttributes() {
        return this.extraAttributes;
    }

    @NotNull
    public final List<CachedTreePresentationData> getChildren() {
        return this.children;
    }

    @NotNull
    public String toString() {
        return this.pathElement + " " + this.presentation;
    }

    @NotNull
    public final CachedTreePresentation createTree() {
        return new CachedTreePresentation(this);
    }

    @JvmStatic
    @Nullable
    public static final CachedTreePresentationData createFromTree(@NotNull JTree tree) {
        return Companion.createFromTree(tree);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J.\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/util/treeView/CachedTreePresentationData$Companion;", "", "<init>", "()V", "createFromTree", "Lcom/intellij/ide/util/treeView/CachedTreePresentationData;", "tree", "Ljavax/swing/JTree;", "createPresentation", "model", "Ljavax/swing/tree/TreeModel;", "parentPath", "Ljavax/swing/tree/TreePath;", "node", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final CachedTreePresentationData createFromTree(@NotNull JTree tree) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            TreeModel model = tree.getModel();
            if (model == null) {
                return null;
            }
            return this.createPresentation(tree, model, null, model.getRoot());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final CachedTreePresentationData createPresentation(JTree tree, TreeModel model, TreePath parentPath, Object node) {
            if (node == null) {
                return null;
            }
            Object userObject = TreeUtil.getUserObject(node);
            if (userObject instanceof PresentableNodeDescriptor) {
                TreePath nodePath;
                Object it;
                PresentationData presentationData = ((PresentableNodeDescriptor)userObject).getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentationData, (String)"getPresentation(...)");
                PresentationData presentation = presentationData;
                List children = new ArrayList();
                CachedIconPresentation iconData = TreeIconCachingKt.getIconData(presentation.getIcon(false));
                AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"IJPL-162819");
                Throwable throwable = null;
                try {
                    it = (AccessToken)autoCloseable;
                    boolean bl = false;
                    Object object = userObject;
                    TreeNodeWithCacheableAttributes treeNodeWithCacheableAttributes = object instanceof TreeNodeWithCacheableAttributes ? (TreeNodeWithCacheableAttributes)object : null;
                    it = treeNodeWithCacheableAttributes != null ? treeNodeWithCacheableAttributes.getCacheableAttributes() : null;
                }
                catch (Throwable bl) {
                    throwable = bl;
                    throw bl;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                Object extraAttrs = it;
                boolean isLeaf = model.isLeaf(node);
                CachedTreePresentationData result2 = new CachedTreePresentationData(new TreeState.PathElement(TreeState.calcId(node), TreeState.calcType(node), 0, null), new TreeState.CachedPresentationDataImpl(CachedTreePresentationKt.access$getCacheableText(presentation), iconData, isLeaf), (Map<String, String>)extraAttrs, children);
                TreePath treePath = parentPath;
                TreePath treePath2 = nodePath = treePath == null ? (TreePath)new CachingTreePath(node) : treePath.pathByAddingChild(node);
                if (tree.isExpanded(nodePath)) {
                    int childCount = model.getChildCount(node);
                    for (int i = 0; i < childCount; ++i) {
                        CachedTreePresentationData childPresentation;
                        Object child = model.getChild(node, i);
                        if (this.createPresentation(tree, model, nodePath, child) == null) continue;
                        children.add(childPresentation);
                    }
                }
                return result2;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

