/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.containers.CollectionFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0006R3\u0010\u0004\u001a'\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/actionSystem/ex/ActionCopiedShortcutsTracker;", "", "<init>", "()V", "actionToSourceId", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "onActionCopiedFromId", "", "action", "sourceId", "getSourceId", "Companion", "intellij.platform.ide"})
@ApiStatus.Internal
public final class ActionCopiedShortcutsTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<AnAction, String> actionToSourceId;

    public ActionCopiedShortcutsTracker() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakIdentityMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakIdentityMap(...)");
        this.actionToSourceId = concurrentMap;
    }

    public final void onActionCopiedFromId(@NotNull AnAction action, @NotNull String sourceId) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        ((Map)this.actionToSourceId).put(action, sourceId);
    }

    @Nullable
    public final String getSourceId(@NotNull AnAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (String)this.actionToSourceId.get(action);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/actionSystem/ex/ActionCopiedShortcutsTracker$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/actionSystem/ex/ActionCopiedShortcutsTracker;", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionCopiedShortcutsTracker getInstance() {
            Object object = ApplicationManager.getApplication().getService(ActionCopiedShortcutsTracker.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ActionCopiedShortcutsTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

