/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.TooltipTitle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class ComboBoxAction
extends AnAction
implements CustomComponentAction {
    private static Icon myIcon;
    private static Icon myDisabledIcon;
    private boolean mySmallVariant = true;
    private boolean myFontSet;
    protected @NlsContexts.PopupTitle String myPopupTitle;

    @NotNull
    public static Icon getArrowIcon(boolean enabled) {
        if (myIcon != AllIcons.General.ArrowDown) {
            myIcon = UIManager.getIcon("ComboBoxButton.arrowIcon");
            myDisabledIcon = UIManager.getIcon("ComboBoxButton.arrowIconDisabled");
            if (myIcon == null) {
                myIcon = AllIcons.General.ArrowDown;
            }
            if (myDisabledIcon == null) {
                myDisabledIcon = IconLoader.getDisabledIcon((Icon)AllIcons.General.ArrowDown);
            }
        }
        Icon icon = enabled ? myIcon : myDisabledIcon;
        if (icon == null) {
            ComboBoxAction.$$$reportNull$$$0(0);
        }
        return icon;
    }

    protected ComboBoxAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ComboBoxAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        JFrame frame = WindowManager.getInstance().getFrame(project);
        if (!(frame instanceof IdeFrame)) {
            return;
        }
        JBPopup popup2 = this.createActionPopup(e.getDataContext(), ((IdeFrame)frame).getComponent(), null);
        popup2.showCenteredInCurrentWindow(project);
    }

    @NotNull
    protected JBPopup createActionPopup(@NotNull DataContext context, @NotNull JComponent component, @Nullable Runnable disposeCallback) {
        if (context == null) {
            ComboBoxAction.$$$reportNull$$$0(2);
        }
        if (component == null) {
            ComboBoxAction.$$$reportNull$$$0(3);
        }
        JBPopup jBPopup = this.createActionPopup(this.createPopupActionGroup(component, context), context, disposeCallback);
        if (jBPopup == null) {
            ComboBoxAction.$$$reportNull$$$0(4);
        }
        return jBPopup;
    }

    protected JBPopup createActionPopup(DefaultActionGroup group, @NotNull DataContext context, @Nullable Runnable disposeCallback) {
        if (context == null) {
            ComboBoxAction.$$$reportNull$$$0(5);
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(this.myPopupTitle, (ActionGroup)group, context, false, this.shouldShowDisabledActions(), false, disposeCallback, this.getMaxRows(), this.getPreselectCondition());
        popup2.setMinimumSize(new Dimension(this.getMinWidth(), this.getMinHeight()));
        return popup2;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            ComboBoxAction.$$$reportNull$$$0(6);
        }
        if (place == null) {
            ComboBoxAction.$$$reportNull$$$0(7);
        }
        ComboBoxButton button2 = this.createComboBoxButton(presentation);
        if (this.isNoWrapping(place)) {
            ComboBoxButton comboBoxButton = button2;
            if (comboBoxButton == null) {
                ComboBoxAction.$$$reportNull$$$0(8);
            }
            return comboBoxButton;
        }
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBInsets.create((int)0, (int)3), 0, 0);
        panel2.add((Component)button2, constraints);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ComboBoxAction.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    protected boolean isNoWrapping(@NotNull String place) {
        if (place == null) {
            ComboBoxAction.$$$reportNull$$$0(10);
        }
        if (!ExperimentalUI.isNewUI()) {
            return false;
        }
        return "MainToolbar".equals(place);
    }

    @NotNull
    protected ComboBoxButton createComboBoxButton(@NotNull Presentation presentation) {
        if (presentation == null) {
            ComboBoxAction.$$$reportNull$$$0(11);
        }
        return new ComboBoxButton(presentation);
    }

    public boolean isSmallVariant() {
        return this.mySmallVariant;
    }

    public void setSmallVariant(boolean smallVariant) {
        this.mySmallVariant = smallVariant;
    }

    public void setPopupTitle(@NlsContexts.PopupTitle @NotNull String popupTitle) {
        if (popupTitle == null) {
            ComboBoxAction.$$$reportNull$$$0(12);
        }
        this.myPopupTitle = popupTitle;
    }

    protected boolean shouldShowDisabledActions() {
        return false;
    }

    @Deprecated
    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2, @NotNull DataContext dataContext) {
        if (button2 == null) {
            ComboBoxAction.$$$reportNull$$$0(13);
        }
        if (dataContext == null) {
            ComboBoxAction.$$$reportNull$$$0(14);
        }
        DefaultActionGroup defaultActionGroup = this.createPopupActionGroup(button2);
        if (defaultActionGroup == null) {
            ComboBoxAction.$$$reportNull$$$0(15);
        }
        return defaultActionGroup;
    }

    protected int getMaxRows() {
        return 30;
    }

    protected int getMinHeight() {
        return 1;
    }

    protected int getMinWidth() {
        return 1;
    }

    protected Condition<AnAction> getPreselectCondition() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7, 10, 11, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupTitle";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionPopup";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNoWrapping";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createComboBoxButton";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setPopupTitle";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7, 10, 11, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }

    public class ComboBoxButton
    extends JButton
    implements UserActivityProviderComponent {
        private final Presentation myPresentation;
        private boolean myForcePressed;
        private @TooltipTitle String myTooltipText;

        @Override
        public String getUIClassID() {
            return "ComboBoxButtonUI";
        }

        public ComboBoxButton(Presentation presentation) {
            if (presentation == null) {
                ComboBoxButton.$$$reportNull$$$0(0);
            }
            this.myPresentation = presentation;
            this.setIcon(this.myPresentation.getIcon());
            this.setText(this.myPresentation.getText());
            this.setEnabled(this.myPresentation.isEnabled());
            this.myTooltipText = this.myPresentation.getDescription();
            this.updateTooltipText();
            this.setModel(new MyButtonModel());
            this.getModel().setEnabled(this.myPresentation.isEnabled());
            this.setVisible(presentation.isVisible());
            this.setHorizontalAlignment(2);
            this.setFocusable(ScreenReader.isActive());
            this.putClientProperty("styleCombo", (Object)ComboBoxAction.this);
            this.setMargin();
            if (this.isSmallVariant()) {
                this.setFont((Font)JBUI.Fonts.toolbarSmallComboBoxFont());
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (ComboBoxButton.this.performClickOnMousePress()) {
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            e.consume();
                            if (e.isShiftDown()) {
                                ComboBoxButton.this.doShiftClick();
                            } else {
                                ComboBoxButton.this.doClick();
                            }
                        } else if (SwingUtilities.isRightMouseButton(e)) {
                            ComboBoxButton.this.doRightClick();
                        }
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(this){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseMoved(MouseEventAdapter.convert((MouseEvent)e, (Component)e.getComponent(), (int)503, (long)e.getWhen(), (int)UIUtil.getAllModifiers((InputEvent)e), (int)e.getX(), (int)e.getY()));
                }
            });
            this.myPresentation.addPropertyChangeListener(evt -> this.presentationChanged(evt));
        }

        private void setMargin() {
            this.setMargin((Insets)JBUI.insets((int)0, (int)8, (int)0, (int)5));
        }

        public void setLabel(@NotNull JLabel label2) {
            if (label2 == null) {
                ComboBoxButton.$$$reportNull$$$0(1);
            }
            label2.setLabelFor(this);
            ActionMap map = label2.getActionMap();
            String name = "release";
            final Action old = map.get(name);
            map.put(name, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (old != null) {
                        old.actionPerformed(event);
                    }
                    ComboBoxButton.this.doClick();
                }
            });
        }

        protected void presentationChanged(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            if ("text".equals(propertyName)) {
                this.setText((String)event.getNewValue());
            } else if ("description".equals(propertyName)) {
                this.myTooltipText = (String)event.getNewValue();
                this.updateTooltipText();
            } else if ("icon".equals(propertyName)) {
                this.setIcon((Icon)event.getNewValue());
            } else if ("enabled".equals(propertyName)) {
                this.setEnabled((Boolean)event.getNewValue());
            }
        }

        protected boolean performClickOnMousePress() {
            return true;
        }

        @TestOnly
        @NotNull
        public Presentation getPresentation() {
            Presentation presentation = this.myPresentation;
            if (presentation == null) {
                ComboBoxButton.$$$reportNull$$$0(2);
            }
            return presentation;
        }

        @Override
        protected void fireActionPerformed(ActionEvent event) {
            if (!this.myForcePressed) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> this.showPopup());
            }
        }

        private void setForcePressed(boolean forcePressed) {
            if (this.myForcePressed == forcePressed) {
                return;
            }
            this.myForcePressed = forcePressed;
            this.repaint();
        }

        private void releaseForcePressed() {
            ApplicationManager.getApplication().invokeLater(() -> this.setForcePressed(false), ModalityState.any());
            this.repaint();
            this.fireStateChanged();
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return this.myForcePressed || UISettings.isIdeHelpTooltipEnabled() ? null : super.getToolTipText();
        }

        public void showPopup() {
            JBPopup popup2 = this.createPopup(this::releaseForcePressed);
            this.setForcePressed(true);
            if (UISettings.isIdeHelpTooltipEnabled()) {
                HelpTooltip.setMasterPopup(this, popup2);
            }
            popup2.showUnderneathOf((Component)this);
        }

        @NotNull
        protected JBPopup createPopup(@Nullable Runnable onDispose) {
            JBPopup jBPopup = ComboBoxAction.this.createActionPopup(this.getDataContext(), this, onDispose);
            if (jBPopup == null) {
                ComboBoxButton.$$$reportNull$$$0(3);
            }
            return jBPopup;
        }

        @NotNull
        protected DataContext getDataContext() {
            DataContext dataContext = ActionToolbar.getDataContextFor((Component)this);
            if (dataContext == null) {
                ComboBoxButton.$$$reportNull$$$0(4);
            }
            return dataContext;
        }

        @Override
        public void removeNotify() {
            HelpTooltip.dispose(this);
            super.removeNotify();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.updateTooltipText();
        }

        private void updateTooltipText() {
            HelpTooltip.dispose(this);
            if (StringUtil.isNotEmpty((String)this.myTooltipText) && UISettings.isIdeHelpTooltipEnabled()) {
                String shortcut = KeymapUtil.getFirstKeyboardShortcutText(ComboBoxAction.this);
                new HelpTooltip().setTitle(this.myTooltipText).setShortcut(shortcut).installOn(this);
            } else {
                String tooltip = KeymapUtil.createTooltipText(this.myTooltipText, ComboBoxAction.this);
                this.setToolTipText(!tooltip.isEmpty() ? tooltip : null);
            }
        }

        @Override
        public boolean isOpaque() {
            return !this.isSmallVariant();
        }

        @Override
        public Font getFont() {
            if (ComboBoxAction.this.myFontSet && ExperimentalUI.isNewUI()) {
                return super.getFont();
            }
            return this.isSmallVariant() ? UIUtil.getToolbarFont() : StartupUiUtil.getLabelFont();
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            ComboBoxAction.this.myFontSet = true;
        }

        @Override
        protected Graphics getComponentGraphics(Graphics graphics) {
            return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
        }

        public int getArrowGap() {
            return 0;
        }

        protected boolean isArrowVisible(@NotNull Presentation presentation) {
            if (presentation == null) {
                ComboBoxButton.$$$reportNull$$$0(5);
            }
            return true;
        }

        public boolean isArrowVisible() {
            return this.myPresentation != null && this.isArrowVisible(this.myPresentation);
        }

        public boolean isSmallVariant() {
            return ComboBoxAction.this.isSmallVariant();
        }

        @Override
        public void updateUI() {
            Object uiClassName = UIManager.get(this.getUIClassID());
            this.setUI(uiClassName == null ? BasicButtonUI.createUI(this) : UIManager.getUI(this));
            this.setMargin();
        }

        @ApiStatus.Experimental
        protected void doShiftClick() {
            this.doClick();
        }

        protected void doRightClick() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction$ComboBoxButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction$ComboBoxButton";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopup";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setLabel";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isArrowVisible";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }

        protected class MyButtonModel
        extends DefaultButtonModel {
            protected MyButtonModel() {
            }

            @Override
            public boolean isPressed() {
                return ComboBoxButton.this.myForcePressed || super.isPressed();
            }

            @Override
            public boolean isArmed() {
                return ComboBoxButton.this.myForcePressed || super.isArmed();
            }
        }
    }
}

