/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.client;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public interface ClientDisposableProvider {
    @Nullable
    public static Disposable getCurrentDisposable() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return null;
        }
        ClientDisposableProvider provider = (ClientDisposableProvider)application.getService(ClientDisposableProvider.class);
        return provider != null ? provider.getDisposable() : application;
    }

    @NotNull
    public Disposable getDisposable();
}

