/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Producer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorModificationUtil
extends EditorModificationUtilEx {
    private static final Key<ReadOnlyHint> READ_ONLY_VIEW_HINT_KEY = Key.create((String)"READ_ONLY_VIEW_HINT_KEY");
    private static final Key<Boolean> IGNORE_READ_ONLY_HINT_KEY = Key.create((String)"IGNORE_READ_ONLY_HINT_KEY");

    private EditorModificationUtil() {
    }

    public static void deleteSelectedTextForAllCarets(@NotNull Editor editor) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(0);
        }
        editor.getCaretModel().runForEachCaret(__ -> EditorModificationUtil.deleteSelectedText((Editor)editor));
    }

    public static void zeroWidthBlockSelectionAtCaretColumn(@NotNull Editor editor, int startLine, int endLine) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(1);
        }
        int caretColumn = editor.getCaretModel().getLogicalPosition().column;
        editor.getSelectionModel().setBlockSelection(new LogicalPosition(startLine, caretColumn), new LogicalPosition(endLine, caretColumn));
    }

    @Nullable
    public static Transferable getContentsToPasteToEditor(@Nullable Producer<? extends Transferable> producer) {
        if (producer == null) {
            CopyPasteManager manager = CopyPasteManager.getInstance();
            return manager.areDataFlavorsAvailable(new DataFlavor[]{DataFlavor.stringFlavor}) ? manager.getContents() : null;
        }
        return (Transferable)producer.produce();
    }

    @Nullable
    public static String getStringContent(@NotNull Transferable content) {
        RawText raw;
        if (content == null) {
            EditorModificationUtil.$$$reportNull$$$0(2);
        }
        if ((raw = RawText.fromTransferable(content)) != null) {
            return raw.rawText;
        }
        try {
            return (String)content.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return null;
        }
    }

    public static void typeInStringAtCaretHonorMultipleCarets(@NotNull Editor editor, @NotNull String str) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(3);
        }
        if (str == null) {
            EditorModificationUtil.$$$reportNull$$$0(4);
        }
        EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true, str.length());
    }

    public static void typeInStringAtCaretHonorMultipleCarets(@NotNull Editor editor, @NotNull String str, int caretShift) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(5);
        }
        if (str == null) {
            EditorModificationUtil.$$$reportNull$$$0(6);
        }
        EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true, caretShift);
    }

    public static void typeInStringAtCaretHonorMultipleCarets(@NotNull Editor editor, @NotNull String str, boolean toProcessOverwriteMode) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(7);
        }
        if (str == null) {
            EditorModificationUtil.$$$reportNull$$$0(8);
        }
        EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, toProcessOverwriteMode, str.length());
    }

    public static void typeInStringAtCaretHonorMultipleCarets(@NotNull Editor editor, @NotNull String str, boolean toProcessOverwriteMode, int caretShift) throws ReadOnlyFragmentModificationException {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(9);
        }
        if (str == null) {
            EditorModificationUtil.$$$reportNull$$$0(10);
        }
        editor.getCaretModel().runForEachCaret(__ -> EditorModificationUtil.insertStringAtCaretNoScrolling((Editor)editor, (String)str, (boolean)toProcessOverwriteMode, (boolean)true, (int)caretShift));
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public static void moveAllCaretsRelatively(@NotNull Editor editor, int caretShift) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(11);
        }
        editor.getCaretModel().runForEachCaret(caret -> caret.moveToOffset(caret.getOffset() + caretShift));
    }

    public static void moveCaretRelatively(@NotNull Editor editor, int caretShift) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(12);
        }
        CaretModel caretModel = editor.getCaretModel();
        caretModel.moveToOffset(caretModel.getOffset() + caretShift);
    }

    @NotNull
    public static List<CaretState> calcBlockSelectionState(@NotNull Editor editor, @NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(13);
        }
        if (blockStart == null) {
            EditorModificationUtil.$$$reportNull$$$0(14);
        }
        if (blockEnd == null) {
            EditorModificationUtil.$$$reportNull$$$0(15);
        }
        int startLine = Math.max(Math.min(blockStart.line, editor.getDocument().getLineCount() - 1), 0);
        int endLine = Math.max(Math.min(blockEnd.line, editor.getDocument().getLineCount() - 1), 0);
        int step = endLine < startLine ? -1 : 1;
        int count = 1 + Math.abs(endLine - startLine);
        LinkedList<CaretState> caretStates = new LinkedList<CaretState>();
        boolean hasSelection = false;
        int line = startLine;
        int i = 0;
        while (i < count) {
            int startColumn = blockStart.column;
            int endColumn = blockEnd.column;
            int lineEndOffset = editor.getDocument().getLineEndOffset(line);
            LogicalPosition lineEndPosition = editor.offsetToLogicalPosition(lineEndOffset);
            int lineWidth = lineEndPosition.column;
            if (startColumn > lineWidth && endColumn > lineWidth && !editor.isColumnMode()) {
                LogicalPosition caretPos = new LogicalPosition(line, Math.min(startColumn, endColumn));
                caretStates.add(new CaretState(caretPos, lineEndPosition, lineEndPosition));
            } else {
                LogicalPosition startPos = new LogicalPosition(line, editor.isColumnMode() ? startColumn : Math.min(startColumn, lineWidth));
                LogicalPosition endPos = new LogicalPosition(line, editor.isColumnMode() ? endColumn : Math.min(endColumn, lineWidth));
                int startOffset = editor.logicalPositionToOffset(startPos);
                int endOffset = editor.logicalPositionToOffset(endPos);
                caretStates.add(new CaretState(endPos, startPos, endPos));
                hasSelection |= startOffset != endOffset;
            }
            ++i;
            line += step;
        }
        if (hasSelection && !editor.isColumnMode()) {
            caretStates.removeIf(state -> Objects.equals(state.getSelectionStart(), state.getSelectionEnd()));
        }
        LinkedList<CaretState> linkedList = caretStates;
        if (linkedList == null) {
            EditorModificationUtil.$$$reportNull$$$0(16);
        }
        return linkedList;
    }

    public static boolean requestWriting(@NotNull Editor editor) {
        FileDocumentManager.WriteAccessStatus writeAccess;
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(17);
        }
        if (!(writeAccess = FileDocumentManager.getInstance().requestWritingStatus(editor.getDocument(), editor.getProject())).hasWriteAccess()) {
            HintManager.getInstance().showInformationHint(editor, writeAccess.getReadOnlyMessage(), writeAccess.getHyperlinkListener());
            return false;
        }
        return true;
    }

    public static boolean checkModificationAllowed(@NotNull Editor editor) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(18);
        }
        if (!editor.isViewer()) {
            return true;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || editor instanceof TextComponentEditor) {
            return false;
        }
        Boolean ignoreHint = (Boolean)IGNORE_READ_ONLY_HINT_KEY.get((UserDataHolder)editor);
        if (ignoreHint == Boolean.TRUE) {
            return false;
        }
        ReadOnlyHint hint = (ReadOnlyHint)ObjectUtils.chooseNotNull((Object)((ReadOnlyHint)READ_ONLY_VIEW_HINT_KEY.get((UserDataHolder)editor)), (Object)new ReadOnlyHint(EditorBundle.message("editing.viewer.hint", new Object[0]), null));
        HintManager.getInstance().showInformationHint(editor, hint.message, hint.linkListener);
        return false;
    }

    public static void setReadOnlyHint(@NotNull Editor editor, @NlsContexts.HintText @Nullable String message) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(19);
        }
        EditorModificationUtil.setReadOnlyHint(editor, message, null);
    }

    public static void setReadOnlyHint(@NotNull Editor editor, @NlsContexts.HintText @Nullable String message, @Nullable HyperlinkListener linkListener) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(20);
        }
        editor.putUserData(READ_ONLY_VIEW_HINT_KEY, (Object)(message != null ? new ReadOnlyHint(message, linkListener) : null));
    }

    public static void setShowReadOnlyHint(@NotNull Editor editor, boolean shouldShow) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(21);
        }
        editor.putUserData(IGNORE_READ_ONLY_HINT_KEY, (Object)(shouldShow ? null : Boolean.valueOf(true)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStart";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockEnd";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/EditorModificationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/EditorModificationUtil";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBlockSelectionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deleteSelectedTextForAllCarets";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "zeroWidthBlockSelectionAtCaretColumn";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStringContent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "typeInStringAtCaretHonorMultipleCarets";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "moveAllCaretsRelatively";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretRelatively";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calcBlockSelectionState";
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkModificationAllowed";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnlyHint";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setShowReadOnlyHint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16 -> new IllegalStateException(string);
        };
    }

    private record ReadOnlyHint(@NlsContexts.HintText @NotNull String message, @Nullable HyperlinkListener linkListener) {
        private final @NlsContexts.HintText @NotNull String message;

        private ReadOnlyHint(@NlsContexts.HintText @NotNull String message, @Nullable HyperlinkListener linkListener) {
            if (message == null) {
                ReadOnlyHint.$$$reportNull$$$0(0);
            }
        }

        @NlsContexts.HintText
        @NotNull
        public String message() {
            String string = this.message;
            if (string == null) {
                ReadOnlyHint.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/EditorModificationUtil$ReadOnlyHint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/EditorModificationUtil$ReadOnlyHint";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

