/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.Animator;
import java.awt.Point;
import java.awt.Window;

public final class DialogEarthquakeShaker {
    private final Window window;
    private Point naturalLocation;
    private long startTime;

    private DialogEarthquakeShaker(Window window) {
        this.window = window;
    }

    public void startShake() {
        this.naturalLocation = this.window.getLocation();
        this.startTime = System.currentTimeMillis();
        final Disposable disposable = Disposer.newDisposable((String)"DialogEarthquakeShaker");
        new Animator("EarthQuake", 10, 70, true, true, disposable){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                long elapsed = System.currentTimeMillis() - DialogEarthquakeShaker.this.startTime;
                double waveOffset = (double)(elapsed % 70L) / 70.0;
                double angle = waveOffset * 2.0 * Math.PI;
                int shakenX = (int)(Math.sin(angle) * 10.0 + (double)DialogEarthquakeShaker.this.naturalLocation.x);
                DialogEarthquakeShaker.this.window.setLocation(shakenX, DialogEarthquakeShaker.this.naturalLocation.y);
                DialogEarthquakeShaker.this.window.repaint();
                if (elapsed > 150L) {
                    this.suspend();
                    DialogEarthquakeShaker.this.window.setLocation(DialogEarthquakeShaker.this.naturalLocation);
                    DialogEarthquakeShaker.this.window.repaint();
                    Disposer.dispose((Disposable)disposable);
                }
            }
        }.resume();
    }

    public static void shake(Window window) {
        new DialogEarthquakeShaker(window).startShake();
    }
}

