/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TestDialog;
import com.intellij.openapi.ui.TestInputDialog;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class TestDialogManager {
    private static TestDialog implementation;
    private static TestInputDialog inputImplementation;

    @TestOnly
    public static TestDialog setTestDialog(@Nullable TestDialog newValue) {
        TestDialogManager.checkUnitTestOrHeadlessMode();
        TestDialog oldValue = implementation;
        implementation = newValue;
        return oldValue;
    }

    @TestOnly
    public static TestDialog setTestDialog(@Nullable TestDialog newValue, @NotNull Disposable disposable) {
        if (disposable == null) {
            TestDialogManager.$$$reportNull$$$0(0);
        }
        TestDialog oldValue = TestDialogManager.setTestDialog(newValue);
        Disposer.register((Disposable)disposable, () -> {
            implementation = oldValue;
        });
        return oldValue;
    }

    @NotNull
    public static TestDialog getTestImplementation() {
        TestDialog result2 = implementation;
        TestDialog testDialog = result2 == null ? TestDialog.DEFAULT : result2;
        if (testDialog == null) {
            TestDialogManager.$$$reportNull$$$0(1);
        }
        return testDialog;
    }

    public static TestInputDialog getTestInputImplementation() {
        TestInputDialog result2 = inputImplementation;
        return result2 == null ? TestInputDialog.DEFAULT : result2;
    }

    @TestOnly
    public static TestInputDialog setTestInputDialog(@Nullable TestInputDialog newValue) {
        TestDialogManager.checkUnitTestOrHeadlessMode();
        TestInputDialog oldValue = inputImplementation;
        inputImplementation = newValue;
        return oldValue;
    }

    private static void checkUnitTestOrHeadlessMode() {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            Logger.getInstance(Messages.class).assertTrue(application.isUnitTestMode() || application.isHeadlessEnvironment(), (Object)"This method is available for tests mode or headless environment");
        }
    }

    static {
        inputImplementation = TestInputDialog.DEFAULT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/TestDialogManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/TestDialogManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTestDialog";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

