/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.ui.AutoScrollToSourceTaskManager;
import com.intellij.ui.ClickListener;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.ref.WeakReference;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011J\u0006\u0010\u0012\u001a\u00020\u000bJ\b\u0010\u0013\u001a\u00020\u000bH\u0007J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0006J\u0012\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020 H$J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020 H$J\u0010\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0017J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0015J\u0006\u0010(\u001a\u00020)R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\b\u00198TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\b\u001d8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001b\u00a8\u0006+"}, d2={"Lcom/intellij/ui/AutoScrollToSourceHandler;", "", "<init>", "()V", "scheduledNavigationData", "Ljava/lang/ref/WeakReference;", "Ljava/awt/Component;", "autoScrollAlarm", "Lcom/intellij/util/SingleAlarm;", "getOrCreateAutoScrollAlarm", "install", "", "tree", "Ljavax/swing/JTree;", "table", "Ljavax/swing/JTable;", "jList", "Ljavax/swing/JList;", "cancelAllRequests", "resetAlarm", "onMouseClicked", "component", "onSelectionChanged", "actionName", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "getActionName", "()Ljava/lang/String;", "actionDescription", "Lcom/intellij/openapi/util/NlsActions$ActionDescription;", "getActionDescription", "needToCheckFocus", "", "isAutoScrollMode", "setAutoScrollMode", "state", "isAutoScrollEnabledFor", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "scrollToSource", "createToggleAction", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "AutoscrollToSourceAction", "intellij.platform.ide"})
public abstract class AutoScrollToSourceHandler {
    @Nullable
    private WeakReference<Component> scheduledNavigationData;
    @Nullable
    private SingleAlarm autoScrollAlarm;

    private final SingleAlarm getOrCreateAutoScrollAlarm() {
        SingleAlarm alarm = this.autoScrollAlarm;
        if (alarm == null) {
            this.autoScrollAlarm = alarm = new SingleAlarm(() -> AutoScrollToSourceHandler.getOrCreateAutoScrollAlarm$lambda$0(this), Registry.Companion.intValue("ide.autoscroll.to.source.delay", 100), null, Alarm.ThreadToUse.SWING_THREAD, ModalityState.defaultModalityState());
        }
        return alarm;
    }

    public final void install(@NotNull JTree tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        new ClickListener(tree, this){
            final /* synthetic */ JTree $tree;
            final /* synthetic */ AutoScrollToSourceHandler this$0;
            {
                this.$tree = $tree;
                this.this$0 = $receiver;
            }

            public boolean onClick(MouseEvent e, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (clickCount > 1) {
                    return false;
                }
                TreePath location = this.$tree.getPathForLocation(e.getPoint().x, e.getPoint().y);
                if (location != null) {
                    this.this$0.onMouseClicked(this.$tree);
                }
                return false;
            }
        }.installOn((Component)tree);
        tree.addMouseMotionListener(new MouseMotionAdapter(this, tree){
            final /* synthetic */ AutoScrollToSourceHandler this$0;
            final /* synthetic */ JTree $tree;
            {
                this.this$0 = $receiver;
                this.$tree = $tree;
            }

            public void mouseDragged(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AutoScrollToSourceHandler.access$onSelectionChanged(this.this$0, this.$tree);
            }
        });
        tree.addTreeSelectionListener(arg_0 -> AutoScrollToSourceHandler.install$lambda$0(this, tree, arg_0));
    }

    public final void install(@NotNull JTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        new ClickListener(table, this){
            final /* synthetic */ JTable $table;
            final /* synthetic */ AutoScrollToSourceHandler this$0;
            {
                this.$table = $table;
                this.this$0 = $receiver;
            }

            public boolean onClick(MouseEvent e, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (clickCount >= 2) {
                    return false;
                }
                Component location = this.$table.getComponentAt(e.getPoint());
                if (location != null) {
                    this.this$0.onMouseClicked(this.$table);
                    return this.this$0.isAutoScrollMode();
                }
                return false;
            }
        }.installOn((Component)table);
        table.addMouseMotionListener(new MouseMotionAdapter(this, table){
            final /* synthetic */ AutoScrollToSourceHandler this$0;
            final /* synthetic */ JTable $table;
            {
                this.this$0 = $receiver;
                this.$table = $table;
            }

            public void mouseDragged(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AutoScrollToSourceHandler.access$onSelectionChanged(this.this$0, this.$table);
            }
        });
        table.getSelectionModel().addListSelectionListener(arg_0 -> AutoScrollToSourceHandler.install$lambda$1(this, table, arg_0));
    }

    public final void install(@NotNull JList<?> jList) {
        Intrinsics.checkNotNullParameter(jList, (String)"jList");
        new ClickListener(jList, this){
            final /* synthetic */ JList<?> $jList;
            final /* synthetic */ AutoScrollToSourceHandler this$0;
            {
                this.$jList = $jList;
                this.this$0 = $receiver;
            }

            public boolean onClick(MouseEvent e, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (clickCount >= 2) {
                    return false;
                }
                Object source = e.getSource();
                int index = this.$jList.locationToIndex(SwingUtilities.convertPoint(source instanceof Component ? (Component)source : null, e.getPoint(), this.$jList));
                if (index >= 0 && index < this.$jList.getModel().getSize()) {
                    this.this$0.onMouseClicked(this.$jList);
                    return true;
                }
                return false;
            }
        }.installOn((Component)jList);
        jList.addListSelectionListener(arg_0 -> AutoScrollToSourceHandler.install$lambda$2(this, jList, arg_0));
    }

    public final void cancelAllRequests() {
        block0: {
            SingleAlarm singleAlarm = this.autoScrollAlarm;
            if (singleAlarm == null) break block0;
            singleAlarm.cancel();
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Obsolete
    public final void resetAlarm() {
        this.autoScrollAlarm = null;
    }

    public final void onMouseClicked(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.cancelAllRequests();
        if (this.isAutoScrollMode()) {
            this.scrollToSource(component);
        }
    }

    private final void onSelectionChanged(Component component) {
        if (component != null && component.isShowing() && this.isAutoScrollMode()) {
            this.scheduledNavigationData = new WeakReference<Component>(component);
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.getOrCreateAutoScrollAlarm(), (boolean)false, (int)1, null);
        }
    }

    @Nullable
    protected String getActionName() {
        return UIBundle.message("autoscroll.to.source.action.name", new Object[0]);
    }

    @Nullable
    protected String getActionDescription() {
        return UIBundle.message("autoscroll.to.source.action.description", new Object[0]);
    }

    protected boolean needToCheckFocus() {
        return true;
    }

    protected abstract boolean isAutoScrollMode();

    protected abstract void setAutoScrollMode(boolean var1);

    @ApiStatus.Internal
    public boolean isAutoScrollEnabledFor(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType type = fileType;
        if (type == FileTypes.UNKNOWN || type instanceof INativeFileType) {
            return false;
        }
        return !VirtualFileUtil.isTooLargeForIntellijSense((VirtualFile)file);
    }

    @RequiresEdt
    protected void scrollToSource(@NotNull Component tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        AutoScrollToSourceTaskManager autoScrollToSourceTaskManager = AutoScrollToSourceTaskManager.Companion.getInstance();
        DataContext dataContext = DataManager.getInstance().getDataContext(tree);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        autoScrollToSourceTaskManager.scheduleScrollToSource(this, dataContext);
    }

    @NotNull
    public final ToggleAction createToggleAction() {
        return new AutoscrollToSourceAction(this.getActionName(), this.getActionDescription());
    }

    private static final void getOrCreateAutoScrollAlarm$lambda$0(AutoScrollToSourceHandler this$0) {
        WeakReference<Component> weakReference = this$0.scheduledNavigationData;
        if (weakReference == null || (weakReference = (Component)weakReference.get()) == null) {
            return;
        }
        WeakReference<Component> component = weakReference;
        this$0.scheduledNavigationData = null;
        if (((Component)((Object)component)).isShowing() && (!this$0.needToCheckFocus() || UIUtil.hasFocus((Component)((Object)component)))) {
            this$0.scrollToSource((Component)((Object)component));
        }
    }

    private static final void install$lambda$0(AutoScrollToSourceHandler this$0, JTree $tree, TreeSelectionEvent it) {
        this$0.onSelectionChanged($tree);
    }

    private static final void install$lambda$1(AutoScrollToSourceHandler this$0, JTable $table, ListSelectionEvent it) {
        this$0.onSelectionChanged($table);
    }

    private static final void install$lambda$2(AutoScrollToSourceHandler this$0, JList $jList, ListSelectionEvent it) {
        this$0.onSelectionChanged($jList);
    }

    public static final /* synthetic */ void access$onSelectionChanged(AutoScrollToSourceHandler $this, Component component) {
        $this.onSelectionChanged(component);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\r\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0005\u0012\r\u0010\u0006\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ui/AutoScrollToSourceHandler$AutoscrollToSourceAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "actionName", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "actionDescription", "Lcom/intellij/openapi/util/NlsActions$ActionDescription;", "<init>", "(Lcom/intellij/ui/AutoScrollToSourceHandler;Ljava/lang/String;Ljava/lang/String;)V", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "setSelected", "", "flag", "intellij.platform.ide"})
    private final class AutoscrollToSourceAction
    extends ToggleAction
    implements DumbAware {
        public AutoscrollToSourceAction(@Nullable String actionName, String actionDescription) {
            super(actionName, actionDescription, AllIcons.General.AutoscrollToSource);
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return AutoScrollToSourceHandler.this.isAutoScrollMode();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        @Override
        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AutoScrollToSourceHandler.this.setAutoScrollMode(flag);
        }
    }
}

