/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.AbstractFieldPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.fields.ExtendableTextField;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class FieldPanel
extends AbstractFieldPanel
implements TextAccessor {
    private final JTextField myTextField;

    public FieldPanel() {
        this(new ExtendableTextField(30));
    }

    protected FieldPanel(JTextField textField) {
        super(textField);
        this.myTextField = textField;
        this.createComponent();
    }

    public FieldPanel(@NlsContexts.Label String labelText, @NlsContexts.DialogTitle String viewerDialogTitle, ActionListener browseButtonActionListener, Runnable documentListener) {
        this(new ExtendableTextField(30), labelText, viewerDialogTitle, browseButtonActionListener, documentListener);
    }

    public FieldPanel(JTextField textField, @NlsContexts.Label String labelText, @NlsContexts.DialogTitle String viewerDialogTitle, ActionListener browseButtonActionListener, Runnable documentListener) {
        super(textField, labelText, viewerDialogTitle, browseButtonActionListener, documentListener);
        this.myTextField = textField;
        this.createComponent();
    }

    @Override
    public void createComponent() {
        super.createComponent();
        ComponentWithBrowseButton.MyDoClickAction doClickAction = this.getDoClickAction();
        if (doClickAction != null) {
            doClickAction.registerShortcut(this.getTextField());
        }
        this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (FieldPanel.this.getChangeListener() != null) {
                    FieldPanel.this.getChangeListener().run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/FieldPanel$1", "textChanged"));
            }
        });
    }

    @Override
    public String getText() {
        return this.myTextField.getText();
    }

    @Override
    public void setText(String text) {
        this.myTextField.setText(text);
    }

    public JTextField getTextField() {
        return this.myTextField;
    }

    public static FieldPanel create(@NlsContexts.Label String labelText, @NlsContexts.DialogTitle String viewerDialogTitle) {
        return FieldPanel.create(labelText, viewerDialogTitle, null, null);
    }

    public static FieldPanel withPaths(@NlsContexts.Label String labelText, @NlsContexts.DialogTitle String viewerDialogTitle) {
        return FieldPanel.withPaths(labelText, viewerDialogTitle, null, null);
    }

    public static FieldPanel withPaths(@NlsContexts.Label String labelText, @NlsContexts.DialogTitle String viewerDialogTitle, ActionListener browseButtonActionListener, Runnable documentListener) {
        FieldPanel fieldPanel = FieldPanel.create(labelText, viewerDialogTitle, browseButtonActionListener, documentListener);
        InsertPathAction.addTo(fieldPanel.myTextField);
        return fieldPanel;
    }

    private static FieldPanel create(@NlsContexts.Label String labelText, @NlsContexts.DialogTitle String viewerDialogTitle, ActionListener browseButtonActionListener, Runnable documentListener) {
        return new FieldPanel(labelText, viewerDialogTitle, browseButtonActionListener, documentListener);
    }

    public void setEditable(boolean editable) {
        this.myTextField.setEditable(editable);
        for (JButton button2 : this.myButtons) {
            button2.setEnabled(editable);
        }
    }
}

