/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class GroupHeaderSeparator
extends SeparatorWithText {
    private boolean myHideLine;
    private final Insets myLabelInsets;
    private Insets lineInsets;

    public GroupHeaderSeparator(Insets labelInsets) {
        this.myLabelInsets = labelInsets;
        if (ExperimentalUI.isNewUI()) {
            this.lineInsets = JBUI.CurrentTheme.Popup.separatorInsets();
            this.setBorder((Border)JBUI.Borders.empty());
            this.setFont(RelativeFont.BOLD.derive((Font)JBFont.smallOrNewUiMedium()));
        } else {
            this.lineInsets = JBUI.insets((int)GroupHeaderSeparator.getVgap(), (int)GroupHeaderSeparator.getHgap(), (int)GroupHeaderSeparator.getVgap(), (int)GroupHeaderSeparator.getHgap());
        }
    }

    public void setHideLine(boolean hideLine) {
        this.myHideLine = hideLine;
    }

    public boolean isHideLine() {
        return this.myHideLine;
    }

    @Override
    protected Dimension getPreferredElementSize() {
        Dimension size = this.getCaption() == null ? new Dimension(Math.max(this.myPrefWidth, 0), 0) : this.getLabelSize(this.myLabelInsets);
        if (!this.myHideLine) {
            size.height += this.lineInsets.top + this.lineInsets.bottom + 1;
        }
        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
        return size;
    }

    @Override
    protected void paintComponent(Graphics g) {
        String caption;
        g.setColor(this.getForeground());
        Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
        if (!this.myHideLine) {
            this.paintLine(g, bounds);
            int lineHeight = this.lineInsets.top + this.lineInsets.bottom + 1;
            bounds.y += lineHeight;
            bounds.height -= lineHeight;
        }
        if ((caption = this.getCaption()) != null) {
            bounds.x += this.myLabelInsets.left;
            bounds.width -= this.myLabelInsets.left + this.myLabelInsets.right;
            bounds.y += this.myLabelInsets.top;
            bounds.height -= this.myLabelInsets.top + this.myLabelInsets.bottom;
            Rectangle iconR = new Rectangle();
            Rectangle textR = new Rectangle();
            FontMetrics fm = g.getFontMetrics();
            String label2 = SwingUtilities.layoutCompoundLabel(fm, caption, null, 0, 2, 0, 2, bounds, iconR, textR, 0);
            UISettings.setupAntialiasing((Graphics)g);
            g.setColor(this.getTextForeground());
            g.drawString(label2, textR.x, textR.y + fm.getAscent());
        }
    }

    private void paintLine(Graphics g, Rectangle bounds) {
        int x = bounds.x + this.lineInsets.left;
        int width = bounds.width - this.lineInsets.left - this.lineInsets.right;
        int y = bounds.y + this.lineInsets.top;
        RectanglePainter.FILL.paint((Graphics2D)g, x, y, width, 1, null);
    }
}

