/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.Stack;
import java.awt.Color;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class HtmlToSimpleColoredComponentConverter {
    private static final Logger LOG = Logger.getInstance(HtmlToSimpleColoredComponentConverter.class);
    public static final StyleTagHandler DEFAULT_TAG_HANDLER = new DefaultStyleTagHandler();
    private final StyleTagHandler myStyleTagHandler;

    public HtmlToSimpleColoredComponentConverter(StyleTagHandler mapper) {
        this.myStyleTagHandler = mapper;
    }

    public HtmlToSimpleColoredComponentConverter() {
        this(DEFAULT_TAG_HANDLER);
    }

    public List<Fragment> convert(final @NotNull @Nls String htmlString, SimpleTextAttributes defaultAttributes) {
        if (htmlString == null) {
            HtmlToSimpleColoredComponentConverter.$$$reportNull$$$0(0);
        }
        final TextAttributesStack attributesStack = new TextAttributesStack(defaultAttributes);
        final ArrayList<Fragment> res2 = new ArrayList<Fragment>();
        HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){

            @Override
            public void handleText(char[] data, int pos) {
                res2.add(new Fragment(new String(data), attributesStack.peek()));
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                String tagName = t.toString();
                SimpleTextAttributes attributesByTag = HtmlToSimpleColoredComponentConverter.this.myStyleTagHandler.calcAttributes(t, a);
                if (attributesByTag != null) {
                    SimpleTextAttributes newAttributes = SimpleTextAttributes.merge((SimpleTextAttributes)attributesStack.peek(), (SimpleTextAttributes)attributesByTag);
                    attributesStack.push(tagName, newAttributes);
                }
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
                attributesStack.removeFromTop(t.toString());
            }

            @Override
            public void handleError(String errorMsg, int pos) {
                if (errorMsg.startsWith("start.missing body")) {
                    return;
                }
                if (errorMsg.startsWith("invalid.tagatt style")) {
                    return;
                }
                if (errorMsg.startsWith("invalid.tagatt class")) {
                    return;
                }
                LOG.error("Cannot parse HTML: [" + htmlString + "]", new String[]{errorMsg});
            }
        };
        StringReader reader = new StringReader(htmlString);
        try {
            new ParserDelegator().parse(reader, callback, true);
        }
        catch (IOException e) {
            LOG.error("Cannot parse HTML", (Throwable)e);
            return Collections.singletonList(new Fragment(StringUtil.removeHtmlTags((String)htmlString), defaultAttributes));
        }
        return res2;
    }

    public void appendHtml(@NotNull SimpleColoredComponent component, @NotNull @Nls String html, @NotNull SimpleTextAttributes defaultAttributes) {
        if (component == null) {
            HtmlToSimpleColoredComponentConverter.$$$reportNull$$$0(1);
        }
        if (html == null) {
            HtmlToSimpleColoredComponentConverter.$$$reportNull$$$0(2);
        }
        if (defaultAttributes == null) {
            HtmlToSimpleColoredComponentConverter.$$$reportNull$$$0(3);
        }
        this.convert(html, defaultAttributes).forEach(fragment -> component.append(fragment.myText, fragment.myAttributes));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAttributes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/HtmlToSimpleColoredComponentConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "convert";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendHtml";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface StyleTagHandler {
        public SimpleTextAttributes calcAttributes(HTML.Tag var1, MutableAttributeSet var2);

        default public StyleTagHandler extendWith(StyleTagHandler anotherMapper) {
            return (tag, attr) -> {
                SimpleTextAttributes anotherRes = anotherMapper.calcAttributes(tag, attr);
                return anotherRes != null ? anotherRes : this.calcAttributes(tag, attr);
            };
        }
    }

    private static class TextAttributesStack {
        private final Stack<Pair<String, SimpleTextAttributes>> myStack;

        private TextAttributesStack(@NotNull SimpleTextAttributes defaultAttributes) {
            if (defaultAttributes == null) {
                TextAttributesStack.$$$reportNull$$$0(0);
            }
            this.myStack = new Stack();
            this.myStack.push((Object)Pair.create(null, (Object)defaultAttributes));
        }

        public void push(@NotNull String tagName, @NotNull SimpleTextAttributes attributes) {
            if (tagName == null) {
                TextAttributesStack.$$$reportNull$$$0(1);
            }
            if (attributes == null) {
                TextAttributesStack.$$$reportNull$$$0(2);
            }
            this.myStack.push((Object)Pair.create((Object)tagName, (Object)attributes));
        }

        public void removeFromTop(@NotNull String tagName) {
            if (tagName == null) {
                TextAttributesStack.$$$reportNull$$$0(3);
            }
            if (tagName.equalsIgnoreCase((String)((Pair)this.myStack.peek()).first)) {
                this.myStack.pop();
            }
        }

        public SimpleTextAttributes peek() {
            return (SimpleTextAttributes)((Pair)this.myStack.peek()).second;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultAttributes";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/HtmlToSimpleColoredComponentConverter$TextAttributesStack";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "push";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeFromTop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Fragment {
        @NotNull
        @Nls
        private final String myText;
        @NotNull
        private final SimpleTextAttributes myAttributes;

        public Fragment(@NotNull @Nls String text, @NotNull SimpleTextAttributes attributes) {
            if (text == null) {
                Fragment.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                Fragment.$$$reportNull$$$0(1);
            }
            this.myText = text;
            this.myAttributes = attributes;
        }

        @NotNull
        @Nls
        public String getText() {
            String string = this.myText;
            if (string == null) {
                Fragment.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public SimpleTextAttributes getAttributes() {
            SimpleTextAttributes simpleTextAttributes = this.myAttributes;
            if (simpleTextAttributes == null) {
                Fragment.$$$reportNull$$$0(3);
            }
            return simpleTextAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/HtmlToSimpleColoredComponentConverter$Fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/HtmlToSimpleColoredComponentConverter$Fragment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class DefaultStyleTagHandler
    implements StyleTagHandler {
        private DefaultStyleTagHandler() {
        }

        @Override
        public SimpleTextAttributes calcAttributes(HTML.Tag tag, MutableAttributeSet attr) {
            SimpleTextAttributes styleAttributes = DefaultStyleTagHandler.parseStyleIfPossible(attr);
            if (tag == HTML.Tag.DIV || tag == HTML.Tag.SPAN) {
                return styleAttributes;
            }
            SimpleTextAttributes tagAttributes = null;
            if (tag == HTML.Tag.B) {
                tagAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            }
            if (tag == HTML.Tag.I) {
                tagAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
            }
            if (tag == HTML.Tag.U) {
                tagAttributes = new SimpleTextAttributes(16, null);
            }
            if (tag == HTML.Tag.S) {
                tagAttributes = new SimpleTextAttributes(4, null);
            }
            if (tag == HTML.Tag.A) {
                tagAttributes = SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES;
            }
            if (tagAttributes != null && styleAttributes != null) {
                return SimpleTextAttributes.merge((SimpleTextAttributes)tagAttributes, (SimpleTextAttributes)styleAttributes);
            }
            return tagAttributes;
        }

        private static SimpleTextAttributes parseStyleIfPossible(MutableAttributeSet attr) {
            Object attribute = attr.getAttribute(HTML.Attribute.STYLE);
            if (attribute == null) {
                return null;
            }
            String styleStr = attribute.toString();
            Map<String, String> styles = Arrays.stream(styleStr.split("\\s*;\\s*")).map(s -> s.split("\\s*:\\s*")).collect(Collectors.toMap(s -> s[0], s -> s[1]));
            String colorString = styles.get("color");
            String backgroundString = styles.get("background-color");
            return new SimpleTextAttributes(DefaultStyleTagHandler.parseColor(backgroundString), DefaultStyleTagHandler.parseColor(colorString), null, 0);
        }

        private static Color parseColor(String colorStr) {
            if (colorStr == null) {
                return null;
            }
            if ((colorStr = StringUtil.trimStart((String)colorStr, (String)"#")).length() != 6) {
                return null;
            }
            return ColorUtil.fromHex((String)colorStr);
        }
    }
}

