/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Graphics;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0014R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR.\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u000b\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8D@DX\u0084\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006'"}, d2={"Lcom/intellij/ui/InlineBannerBase;", "Lcom/intellij/ui/components/JBPanel;", "status", "Lcom/intellij/ui/EditorNotificationPanel$Status;", "gap", "", "messageText", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/ui/EditorNotificationPanel$Status;ILjava/lang/String;)V", "value", "getStatus", "()Lcom/intellij/ui/EditorNotificationPanel$Status;", "setStatus", "(Lcom/intellij/ui/EditorNotificationPanel$Status;)V", "getMessageText", "()Ljava/lang/String;", "setMessageText", "(Ljava/lang/String;)V", "iconPanel", "Ljavax/swing/JPanel;", "getIconPanel", "()Ljavax/swing/JPanel;", "centerPanel", "getCenterPanel", "message", "Ljavax/swing/JEditorPane;", "getMessage", "()Ljavax/swing/JEditorPane;", "setBounds", "", "x", "y", "width", "height", "paintComponent", "g", "Ljava/awt/Graphics;", "intellij.platform.ide"})
public abstract class InlineBannerBase
extends JBPanel<InlineBannerBase> {
    @NotNull
    private EditorNotificationPanel.Status status;
    @NotNull
    private final JPanel iconPanel;
    @NotNull
    private final JPanel centerPanel;
    @NotNull
    private final JEditorPane message;

    public InlineBannerBase(@NotNull EditorNotificationPanel.Status status, int gap, @NotNull String messageText) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
        this.status = status;
        this.iconPanel = new JPanel(new BorderLayout());
        this.centerPanel = new JPanel(new VerticalLayout(gap));
        this.message = new JEditorPane();
        this.setBorder(JBUI.Borders.empty((int)12));
        this.setOpaque(false);
        this.setBackground(status.background);
        this.iconPanel.setOpaque(this.isOpaque());
        this.iconPanel.setBackground(this.getBackground());
        this.centerPanel.setOpaque(this.isOpaque());
        this.centerPanel.setBackground(this.getBackground());
        this.message.setOpaque(this.isOpaque());
        this.message.setBackground(this.getBackground());
        this.message.setBorder(null);
        this.message.setEditable(false);
        this.message.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.message.setContentType("text/html");
        this.message.setEditorKit(new HTMLEditorKitBuilder().build());
        this.message.addHyperlinkListener((HyperlinkListener)((Object)new BrowserHyperlinkListener()));
        this.setMessageText(messageText);
    }

    @NotNull
    public EditorNotificationPanel.Status getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull EditorNotificationPanel.Status value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        this.status = value2;
        this.setBackground(value2.background);
        this.revalidate();
        this.repaint();
    }

    @NotNull
    protected final String getMessageText() {
        String string = this.message.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    protected final void setMessageText(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.message.setText(value2);
        if (this.message.getCaret() != null) {
            this.message.setCaretPosition(0);
        }
    }

    @NotNull
    protected final JPanel getIconPanel() {
        return this.iconPanel;
    }

    @NotNull
    protected final JPanel getCenterPanel() {
        return this.centerPanel;
    }

    @NotNull
    protected final JEditorPane getMessage() {
        return this.message;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, Math.max(width, JBUI.scale((int)256)), height);
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        int cornerRadius = JBUI.scale((int)16);
        g.setColor(this.getBackground());
        g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), cornerRadius, cornerRadius);
        g.setColor(this.getStatus().border);
        g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, cornerRadius, cornerRadius);
        config.restore();
    }
}

