/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListFocusTraversalPolicy
extends LayoutFocusTraversalPolicy {
    private final Component[] myComponents;
    private final ObjectIntMap<Component> myComponentToIndex;

    public ListFocusTraversalPolicy(@NotNull List<? extends Component> components) {
        if (components == null) {
            ListFocusTraversalPolicy.$$$reportNull$$$0(0);
        }
        this.myComponents = components.toArray(new Component[0]);
        this.myComponentToIndex = ListFocusTraversalPolicy.indexMap(this.myComponents);
    }

    @Override
    protected boolean accept(Component aComponent) {
        return super.accept(aComponent) && aComponent.isShowing();
    }

    @Override
    public Component getFirstComponent(Container aContainer) {
        return this.getNextComponent(0);
    }

    @Override
    public Component getLastComponent(Container aContainer) {
        return this.getPreviousComponent(this.myComponents.length - 1);
    }

    @Override
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        if (!this.myComponentToIndex.containsKey((Object)aComponent)) {
            return null;
        }
        int i = this.myComponentToIndex.get((Object)aComponent);
        return this.getNextComponent((i == -1 ? 0 : i) + 1);
    }

    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        if (!this.myComponentToIndex.containsKey((Object)aComponent)) {
            return null;
        }
        int i = this.myComponentToIndex.get((Object)aComponent);
        return this.getPreviousComponent((i == -1 ? 0 : i) - 1);
    }

    @Nullable
    private Component getNextComponent(int startIndex) {
        Component result2;
        int index;
        for (index = startIndex; index < this.myComponents.length; ++index) {
            result2 = this.myComponents[index];
            if (!this.accept(result2)) continue;
            return result2;
        }
        for (index = 0; index < startIndex; ++index) {
            result2 = this.myComponents[index];
            if (!this.accept(result2)) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    private Component getPreviousComponent(int startIndex) {
        Component result2;
        int index;
        for (index = startIndex; index >= 0; --index) {
            result2 = this.myComponents[index];
            if (!this.accept(result2)) continue;
            return result2;
        }
        for (index = this.myComponents.length - 1; index > startIndex; --index) {
            result2 = this.myComponents[index];
            if (!this.accept(result2)) continue;
            return result2;
        }
        return null;
    }

    @NotNull
    private static <X> ObjectIntMap<X> indexMap(X @NotNull [] array) {
        if (array == null) {
            ListFocusTraversalPolicy.$$$reportNull$$$0(1);
        }
        ObjectIntHashMap map = new ObjectIntHashMap(array.length);
        for (X x : array) {
            if (map.containsKey(x)) continue;
            map.put(x, map.size());
        }
        ObjectIntHashMap objectIntHashMap = map;
        if (objectIntHashMap == null) {
            ListFocusTraversalPolicy.$$$reportNull$$$0(2);
        }
        return objectIntHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ListFocusTraversalPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ListFocusTraversalPolicy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "indexMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "indexMap";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

