/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ScrollPaneScrolledState;
import com.intellij.ui.ScrolledState;
import java.awt.Adjustable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0017\u001a\u00020\u0007J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ui/ScrollPaneScrolledStateTracker;", "", "scrollPane", "Ljavax/swing/JScrollPane;", "callback", "Lkotlin/Function1;", "Lcom/intellij/ui/ScrollPaneScrolledState;", "", "<init>", "(Ljavax/swing/JScrollPane;Lkotlin/jvm/functions/Function1;)V", "getScrollPane", "()Ljavax/swing/JScrollPane;", "boundsListener", "Lcom/intellij/ui/ScrollPaneScrolledStateTracker$BoundsListener;", "horizontalListener", "Lcom/intellij/ui/ScrollPaneScrolledStateTracker$ScrollBarValueListener;", "verticalListener", "value", "state", "getState", "()Lcom/intellij/ui/ScrollPaneScrolledState;", "scrollBarListener", "Ljava/beans/PropertyChangeListener;", "detach", "fireCallback", "fireAnyway", "", "ScrollBarValueListener", "BoundsListener", "intellij.platform.ide"})
@ApiStatus.Internal
public final class ScrollPaneScrolledStateTracker {
    @NotNull
    private final JScrollPane scrollPane;
    @NotNull
    private final Function1<ScrollPaneScrolledState, Unit> callback;
    @NotNull
    private final BoundsListener boundsListener;
    @NotNull
    private final ScrollBarValueListener horizontalListener;
    @NotNull
    private final ScrollBarValueListener verticalListener;
    @NotNull
    private ScrollPaneScrolledState state;
    @NotNull
    private final PropertyChangeListener scrollBarListener;

    public ScrollPaneScrolledStateTracker(@NotNull JScrollPane scrollPane2, @NotNull Function1<? super ScrollPaneScrolledState, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)scrollPane2, (String)"scrollPane");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.scrollPane = scrollPane2;
        this.callback = callback;
        this.boundsListener = new BoundsListener();
        this.horizontalListener = new ScrollBarValueListener();
        this.verticalListener = new ScrollBarValueListener();
        this.state = new ScrollPaneScrolledState(this.scrollPane, new ScrolledState(true, true, true, true));
        this.scrollBarListener = arg_0 -> ScrollPaneScrolledStateTracker.scrollBarListener$lambda$0(this, arg_0);
        this.scrollPane.addComponentListener(this.boundsListener);
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        if (jScrollBar != null) {
            jScrollBar.addAdjustmentListener(this.horizontalListener);
        }
        JScrollBar jScrollBar2 = this.scrollPane.getVerticalScrollBar();
        if (jScrollBar2 != null) {
            jScrollBar2.addAdjustmentListener(this.verticalListener);
        }
        this.scrollPane.addPropertyChangeListener(this.scrollBarListener);
    }

    @NotNull
    public final JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @NotNull
    public final ScrollPaneScrolledState getState() {
        return this.state;
    }

    public final void detach() {
        this.scrollPane.removePropertyChangeListener(this.scrollBarListener);
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        if (jScrollBar != null) {
            jScrollBar.removeAdjustmentListener(this.horizontalListener);
        }
        JScrollBar jScrollBar2 = this.scrollPane.getVerticalScrollBar();
        if (jScrollBar2 != null) {
            jScrollBar2.removeAdjustmentListener(this.verticalListener);
        }
        this.scrollPane.removeComponentListener(this.boundsListener);
    }

    private final void fireCallback(boolean fireAnyway) {
        ScrollPaneScrolledState newState = new ScrollPaneScrolledState(this.scrollPane, new ScrolledState(this.horizontalListener.isAtStart(), this.horizontalListener.isAtEnd(), this.verticalListener.isAtStart(), this.verticalListener.isAtEnd()));
        if (fireAnyway || !Intrinsics.areEqual((Object)newState, (Object)this.state)) {
            this.state = newState;
            this.callback.invoke((Object)newState);
        }
    }

    private static final void scrollBarListener$lambda$0(ScrollPaneScrolledStateTracker this$0, PropertyChangeEvent e) {
        block4: {
            String string;
            block3: {
                string = e.getPropertyName();
                if (!Intrinsics.areEqual((Object)string, (Object)"horizontalScrollBar")) break block3;
                Object object = e.getOldValue();
                JScrollBar jScrollBar = object instanceof JScrollBar ? (JScrollBar)object : null;
                if (jScrollBar != null) {
                    jScrollBar.removeAdjustmentListener(this$0.horizontalListener);
                }
                object = e.getNewValue();
                JScrollBar jScrollBar2 = object instanceof JScrollBar ? (JScrollBar)object : null;
                if (jScrollBar2 == null) break block4;
                jScrollBar2.addAdjustmentListener(this$0.horizontalListener);
                break block4;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"verticalScrollBar")) break block4;
            Object object = e.getOldValue();
            JScrollBar jScrollBar = object instanceof JScrollBar ? (JScrollBar)object : null;
            if (jScrollBar != null) {
                jScrollBar.removeAdjustmentListener(this$0.verticalListener);
            }
            object = e.getNewValue();
            JScrollBar jScrollBar3 = object instanceof JScrollBar ? (JScrollBar)object : null;
            if (jScrollBar3 != null) {
                jScrollBar3.addAdjustmentListener(this$0.verticalListener);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ui/ScrollPaneScrolledStateTracker$BoundsListener;", "Ljava/awt/event/ComponentAdapter;", "<init>", "(Lcom/intellij/ui/ScrollPaneScrolledStateTracker;)V", "componentShown", "", "e", "Ljava/awt/event/ComponentEvent;", "componentMoved", "componentResized", "intellij.platform.ide"})
    private final class BoundsListener
    extends ComponentAdapter {
        @Override
        public void componentShown(@Nullable ComponentEvent e) {
            ScrollPaneScrolledStateTracker.this.fireCallback(true);
        }

        @Override
        public void componentMoved(@Nullable ComponentEvent e) {
            ScrollPaneScrolledStateTracker.this.fireCallback(true);
        }

        @Override
        public void componentResized(@Nullable ComponentEvent e) {
            ScrollPaneScrolledStateTracker.this.fireCallback(true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0006\"\u0004\b\n\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ui/ScrollPaneScrolledStateTracker$ScrollBarValueListener;", "Ljava/awt/event/AdjustmentListener;", "<init>", "(Lcom/intellij/ui/ScrollPaneScrolledStateTracker;)V", "isAtStart", "", "()Z", "setAtStart", "(Z)V", "isAtEnd", "setAtEnd", "adjustmentValueChanged", "", "e", "Ljava/awt/event/AdjustmentEvent;", "intellij.platform.ide"})
    @SourceDebugExtension(value={"SMAP\nScrollPaneTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollPaneTracker.kt\ncom/intellij/ui/ScrollPaneScrolledStateTracker$ScrollBarValueListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
    private final class ScrollBarValueListener
    implements AdjustmentListener {
        private boolean isAtStart = true;
        private boolean isAtEnd = true;

        public final boolean isAtStart() {
            return this.isAtStart;
        }

        public final void setAtStart(boolean bl) {
            this.isAtStart = bl;
        }

        public final boolean isAtEnd() {
            return this.isAtEnd;
        }

        public final void setAtEnd(boolean bl) {
            this.isAtEnd = bl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void adjustmentValueChanged(@NotNull AdjustmentEvent e) {
            void $this$adjustmentValueChanged_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.isAtStart = e.getValue() == 0;
            Adjustable adjustable = e.getAdjustable();
            int n = e.getValue();
            ScrollBarValueListener scrollBarValueListener = this;
            boolean bl = false;
            int n2 = $this$adjustmentValueChanged_u24lambda_u240.getMaximum() - $this$adjustmentValueChanged_u24lambda_u240.getVisibleAmount();
            scrollBarValueListener.isAtEnd = n == n2;
            ScrollPaneScrolledStateTracker.this.fireCallback(false);
        }
    }
}

