/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnchorableComponent;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DisabledTraversalPolicy;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.JBComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBLabel
extends JLabel
implements AnchorableComponent,
JBComponent<JBLabel> {
    private UIUtil.ComponentStyle myComponentStyle;
    private UIUtil.FontColor myFontColor;
    private JComponent myAnchor;
    private JEditorPane myEditorPane;
    private JLabel myIconLabel;
    private boolean myMultiline;
    private boolean myAllowAutoWrapping;

    public JBLabel() {
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
    }

    public JBLabel(@NotNull UIUtil.ComponentStyle componentStyle) {
        if (componentStyle == null) {
            JBLabel.$$$reportNull$$$0(0);
        }
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
        this.setComponentStyle(componentStyle);
    }

    public JBLabel(@Nullable Icon image) {
        super(image);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
    }

    public JBLabel(@NlsContexts.Label @NotNull String text) {
        if (text == null) {
            JBLabel.$$$reportNull$$$0(1);
        }
        super(text);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
    }

    public JBLabel(@NlsContexts.Label @NotNull String text, @NotNull UIUtil.ComponentStyle componentStyle) {
        if (text == null) {
            JBLabel.$$$reportNull$$$0(2);
        }
        if (componentStyle == null) {
            JBLabel.$$$reportNull$$$0(3);
        }
        super(text);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
        this.setComponentStyle(componentStyle);
    }

    public JBLabel(@NlsContexts.Label @NotNull String text, @NotNull UIUtil.ComponentStyle componentStyle, @NotNull UIUtil.FontColor fontColor) {
        if (text == null) {
            JBLabel.$$$reportNull$$$0(4);
        }
        if (componentStyle == null) {
            JBLabel.$$$reportNull$$$0(5);
        }
        if (fontColor == null) {
            JBLabel.$$$reportNull$$$0(6);
        }
        super(text);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
        this.setComponentStyle(componentStyle);
        this.setFontColor(fontColor);
    }

    public JBLabel(@NlsContexts.Label @NotNull String text, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        if (text == null) {
            JBLabel.$$$reportNull$$$0(7);
        }
        super(text, horizontalAlignment);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
    }

    public JBLabel(@Nullable Icon image, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
    }

    public JBLabel(@NlsContexts.Label @NotNull String text, @Nullable Icon icon, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        if (text == null) {
            JBLabel.$$$reportNull$$$0(8);
        }
        super(text, icon, horizontalAlignment);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
    }

    public void setComponentStyle(@NotNull UIUtil.ComponentStyle componentStyle) {
        if (componentStyle == null) {
            JBLabel.$$$reportNull$$$0(9);
        }
        this.myComponentStyle = componentStyle;
        UIUtil.applyStyle((UIUtil.ComponentStyle)componentStyle, (Component)this);
    }

    public UIUtil.ComponentStyle getComponentStyle() {
        return this.myComponentStyle;
    }

    public UIUtil.FontColor getFontColor() {
        return this.myFontColor;
    }

    public void setFontColor(@NotNull UIUtil.FontColor fontColor) {
        if (fontColor == null) {
            JBLabel.$$$reportNull$$$0(10);
        }
        this.myFontColor = fontColor;
    }

    @Override
    public Color getForeground() {
        if (!this.isEnabled()) {
            return UIUtil.getLabelDisabledForeground();
        }
        if (this.myFontColor != null) {
            return UIUtil.getLabelFontColor((UIUtil.FontColor)this.myFontColor);
        }
        return super.getForeground();
    }

    @Override
    public void setForeground(Color fg) {
        this.myFontColor = null;
        super.setForeground(fg);
        if (this.myEditorPane != null) {
            this.updateEditorPaneStyle();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.myEditorPane != null) {
            this.myEditorPane.setEnabled(enabled);
        }
    }

    public void setAnchor(@Nullable JComponent anchor) {
        if (this.myAnchor != anchor) {
            this.myAnchor = anchor;
            this.invalidate();
        }
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myAnchor != null && this.myAnchor != this) {
            return this.myAnchor.getPreferredSize();
        }
        if (this.myEditorPane != null) {
            return this.getLayout().preferredLayoutSize(this);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.myAnchor != null && this.myAnchor != this) {
            return this.myAnchor.getMinimumSize();
        }
        if (this.myEditorPane != null) {
            return this.getLayout().minimumLayoutSize(this);
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.myAnchor != null && this.myAnchor != this) {
            return this.myAnchor.getMaximumSize();
        }
        if (this.myEditorPane != null) {
            return this.getLayout().maximumLayoutSize(this);
        }
        return super.getMaximumSize();
    }

    @Override
    public BorderLayout getLayout() {
        return (BorderLayout)super.getLayout();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.myEditorPane == null) {
            super.paintComponent(g);
        }
    }

    @Override
    public void setText(@NlsContexts.Label String text) {
        super.setText(text);
        if (this.myEditorPane != null) {
            this.myEditorPane.setText(this.getText());
            this.updateEditorPaneStyle();
            this.checkMultiline();
            this.updateTextAlignment();
        }
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        if (this.myIconLabel != null) {
            this.myIconLabel.setIcon(icon);
            this.updateLayout();
            this.updateTextAlignment();
        }
    }

    public void setIconWithAlignment(Icon icon, int horizontalAlignment, int verticalAlignment) {
        super.setIcon(icon);
        if (this.myIconLabel != null) {
            this.myIconLabel.setIcon(icon);
            this.myIconLabel.setHorizontalAlignment(horizontalAlignment);
            this.myIconLabel.setVerticalAlignment(verticalAlignment);
            this.updateLayout();
            this.updateTextAlignment();
        }
    }

    @Override
    public void setFocusable(boolean focusable) {
        super.setFocusable(focusable);
        if (this.myEditorPane != null) {
            this.myEditorPane.setFocusable(focusable);
        }
    }

    private void checkMultiline() {
        String text = this.getText();
        this.myMultiline = text != null && StringUtil.removeHtmlTags((String)text).contains(System.lineSeparator());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.myEditorPane != null) {
            this.updateEditorPaneStyle();
            this.updateTextAlignment();
        }
    }

    @Override
    public void setIconTextGap(int iconTextGap) {
        super.setIconTextGap(iconTextGap);
        if (this.myEditorPane != null) {
            this.updateLayout();
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.myEditorPane != null) {
            this.updateTextAlignment();
        }
    }

    @Override
    public void setVerticalTextPosition(int textPosition) {
        super.setVerticalTextPosition(textPosition);
        if (this.myEditorPane != null) {
            this.updateTextAlignment();
        }
    }

    @Override
    public void setHorizontalTextPosition(int textPosition) {
        super.setHorizontalTextPosition(textPosition);
        if (this.myEditorPane != null) {
            this.updateLayout();
        }
    }

    private void updateLayout() {
        String iconConstraint;
        this.setLayout(new BorderLayout(this.getIcon() == null ? 0 : this.getIconTextGap(), 0));
        int position = this.getHorizontalTextPosition();
        String string = iconConstraint = this.getComponentOrientation().isLeftToRight() ? "West" : "East";
        if (this.getComponentOrientation().isLeftToRight() && position == 10) {
            iconConstraint = "East";
        }
        if (!this.getComponentOrientation().isLeftToRight() && position == 11) {
            iconConstraint = "East";
        }
        if (position == 2) {
            iconConstraint = "East";
        }
        this.add((Component)this.myIconLabel, iconConstraint);
        this.add((Component)this.myEditorPane, "Center");
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myEditorPane != null) {
            this.setCopyable(false);
            this.setCopyable(true);
        }
        GraphicsUtil.setAntialiasingType((JComponent)this, (Object)AntialiasingType.getAATextInfoForSwingComponent());
    }

    @NotNull
    protected HyperlinkListener createHyperlinkListener() {
        BrowserHyperlinkListener browserHyperlinkListener = BrowserHyperlinkListener.INSTANCE;
        if (browserHyperlinkListener == null) {
            JBLabel.$$$reportNull$$$0(11);
        }
        return browserHyperlinkListener;
    }

    public JBLabel setCopyable(boolean copyable) {
        if (copyable ^ this.myEditorPane != null) {
            if (this.myEditorPane == null) {
                final JBLabel ellipsisLabel = new JBLabel("...");
                this.myIconLabel = new JLabel(this.getIcon());
                this.myEditorPane = new JEditorPane(){

                    @Override
                    public void paint(Graphics g) {
                        boolean paintEllipsis;
                        Dimension size = this.getSize();
                        boolean bl = paintEllipsis = this.getPreferredSize().width > size.width && !JBLabel.this.myMultiline && !JBLabel.this.myAllowAutoWrapping;
                        if (!paintEllipsis) {
                            super.paint(g);
                        } else {
                            Dimension ellipsisSize = ellipsisLabel.getPreferredSize();
                            int endOffset = size.width - ellipsisSize.width;
                            try {
                                endOffset = this.modelToView((int)(this.viewToModel((Point)new Point((int)endOffset, (int)(this.getHeight() / 2))) - 1)).x;
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                            Shape oldClip = g.getClip();
                            g.clipRect(0, 0, endOffset, size.height);
                            super.paint(g);
                            g.setClip(oldClip);
                            g.translate(endOffset, 0);
                            ellipsisLabel.setSize(ellipsisSize);
                            ellipsisLabel.paint(g);
                            g.translate(-endOffset, 0);
                        }
                    }
                };
                this.myEditorPane.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (JBLabel.this.myEditorPane == null) {
                            return;
                        }
                        int caretPosition = JBLabel.this.myEditorPane.getCaretPosition();
                        JBLabel.this.myEditorPane.setSelectionStart(caretPosition);
                        JBLabel.this.myEditorPane.setSelectionEnd(caretPosition);
                    }
                });
                this.myEditorPane.setContentType("text/html");
                this.myEditorPane.setEditable(false);
                this.myEditorPane.setBackground(UIUtil.TRANSPARENT_COLOR);
                this.myEditorPane.setOpaque(false);
                this.myEditorPane.addHyperlinkListener(this.createHyperlinkListener());
                ComponentUtil.putClientProperty((JComponent)this.myEditorPane, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, Collections.singleton(ellipsisLabel));
                this.myEditorPane.setEditorKit(HTMLEditorKitBuilder.simple());
                this.updateEditorPaneStyle();
                if (this.myEditorPane.getCaret() instanceof DefaultCaret) {
                    ((DefaultCaret)this.myEditorPane.getCaret()).setUpdatePolicy(1);
                }
                this.myEditorPane.setToolTipText(this.getToolTipText());
                this.myEditorPane.setText(this.getText());
                this.checkMultiline();
                this.myEditorPane.setCaretPosition(0);
                this.updateLayout();
                this.updateTextAlignment();
                this.setFocusTraversalPolicyProvider(true);
                this.setFocusTraversalPolicy(new DisabledTraversalPolicy());
            } else {
                this.removeAll();
                this.myEditorPane = null;
                this.myIconLabel = null;
            }
        }
        return this;
    }

    private void updateEditorPaneStyle() {
        this.myEditorPane.setFont(this.getFont());
        this.myEditorPane.setForeground(this.getForeground());
        EditorKit kit = this.myEditorPane.getEditorKit();
        if (kit instanceof HTMLEditorKit) {
            StyleSheet css = ((HTMLEditorKit)kit).getStyleSheet();
            css.addRule("body, p {color:#" + ColorUtil.toHex((Color)this.getForeground()) + ";font-family:" + this.getFont().getFamily() + ";font-size:" + this.getFont().getSize() + "pt;white-space:" + (this.myAllowAutoWrapping ? "normal" : "nowrap") + ";}");
        }
    }

    public JBLabel setAllowAutoWrapping(boolean allowAutoWrapping) {
        this.myAllowAutoWrapping = allowAutoWrapping;
        return this;
    }

    public boolean isAllowAutoWrapping() {
        return this.myAllowAutoWrapping;
    }

    private void updateTextAlignment() {
        if (this.myEditorPane == null) {
            return;
        }
        EmptyBorder newBorder = null;
        int verticalTextPosition = this.getVerticalTextPosition();
        if (verticalTextPosition == 0 || verticalTextPosition == 3) {
            Insets insets = this.myEditorPane.getInsets();
            int preferredHeightWithoutInsets = this.myEditorPane.getPreferredSize().height - insets.top - insets.bottom;
            int availableHeight = this.getHeight();
            if (preferredHeightWithoutInsets > 0 && availableHeight > preferredHeightWithoutInsets) {
                newBorder = new EmptyBorder(verticalTextPosition == 0 ? (availableHeight - preferredHeightWithoutInsets + 1) / 2 : availableHeight - preferredHeightWithoutInsets, 0, 0, 0);
            }
        }
        this.myEditorPane.setBorder(newBorder);
    }

    public JBLabel withBorder(Border border) {
        this.setBorder(border);
        return this;
    }

    public JBLabel withFont(JBFont font) {
        this.setFont((Font)font);
        return this;
    }

    public JBLabel andTransparent() {
        this.setOpaque(false);
        return this;
    }

    public JBLabel andOpaque() {
        this.setOpaque(true);
        return this;
    }

    @Override
    public void setToolTipText(@NlsContexts.Tooltip @Nullable String text) {
        super.setToolTipText(text);
        if (this.myEditorPane != null) {
            this.myEditorPane.setToolTipText(text);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentStyle";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontColor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/JBLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/JBLabel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createHyperlinkListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setComponentStyle";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setFontColor";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

