/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.SwingUndoUtil;
import com.intellij.util.ui.TextLayoutUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.plaf.TextUI;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JBTextField
extends JTextField
implements ComponentWithEmptyText,
TextAccessor {
    private TextComponentEmptyText myEmptyText;
    @ApiStatus.Internal
    public static final String IS_FORCE_INNER_BACKGROUND_PAINT = "JTextField.isForceInnerBackgroundPaint";

    public JBTextField() {
        this.init();
    }

    public JBTextField(int columns) {
        super(columns);
        this.init();
    }

    public JBTextField(@Nls String text) {
        super(text);
        this.init();
    }

    public JBTextField(@Nls String text, int columns) {
        super(text, columns);
        this.init();
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    private void init() {
        SwingUndoUtil.addUndoRedoActions((JTextComponent)this);
        this.myEmptyText = new TextComponentEmptyText(this, true){

            @Override
            protected Rectangle getTextComponentBound() {
                return JBTextField.this.getEmptyTextComponentBounds(super.getTextComponentBound());
            }
        };
    }

    protected Rectangle getEmptyTextComponentBounds(Rectangle bounds) {
        return bounds;
    }

    public void setTextToTriggerEmptyTextStatus(String t) {
        this.myEmptyText.setTextToTriggerStatus(t);
    }

    @Override
    public void setText(String t) {
        if (Objects.equals(t, this.getText())) {
            return;
        }
        super.setText(t);
        SwingUndoUtil.resetUndoRedoActions((JTextComponent)this);
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        TextComponentEmptyText textComponentEmptyText = this.myEmptyText;
        if (textComponentEmptyText == null) {
            JBTextField.$$$reportNull$$$0(0);
        }
        return textComponentEmptyText;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getParent() != null) {
            this.myEmptyText.resetFont();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.myEmptyText.getStatusTriggerText().isEmpty() && this.myEmptyText.isStatusVisible()) {
            g.setColor(this.getBackground());
            Rectangle rect = new Rectangle(this.getSize());
            JBInsets.removeFrom((Rectangle)rect, (Insets)this.getInsets());
            JBInsets.removeFrom((Rectangle)rect, (Insets)this.getMargin());
            ((Graphics2D)g).fill(rect);
            g.setColor(this.getForeground());
        }
        this.myEmptyText.paintStatusText(g);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        TextUI ui = this.getUI();
        String text = ui == null ? null : ui.getToolTipText2D(this, event.getPoint());
        return text != null ? text : this.getToolTipText();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJBTextField();
        }
        return this.accessibleContext;
    }

    @Override
    protected Document createDefaultModel() {
        Document model = super.createDefaultModel();
        TextLayoutUtil.disableTextLayoutIfNeeded((Document)model);
        return model;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/JBTextField", "getEmptyText"));
    }

    private class AccessibleJBTextField
    extends JTextField.AccessibleJTextField {
        private AccessibleJBTextField() {
            super(JBTextField.this);
        }

        @Override
        public String getAccessibleDescription() {
            String emptyText;
            String description = super.getAccessibleDescription();
            if (description == null && StringUtil.isEmpty((String)JBTextField.this.getText()) && !(emptyText = JBTextField.this.myEmptyText.toString()).isEmpty()) {
                return AccessibleContextUtil.getUniqueDescription((AccessibleContext)this, (String)emptyText);
            }
            return description;
        }
    }
}

