/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields.valueEditors;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.fields.valueEditors.AbstractValueEditor;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldValueEditor<T>
extends AbstractValueEditor<T> {
    private final JTextField myField;

    public TextFieldValueEditor(@NotNull JTextField field, @Nullable String valueName, @NotNull T defaultValue) {
        if (field == null) {
            TextFieldValueEditor.$$$reportNull$$$0(0);
        }
        if (defaultValue == null) {
            TextFieldValueEditor.$$$reportNull$$$0(1);
        }
        super(valueName, defaultValue);
        this.myField = field;
        this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                String errorText;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                TextFieldValueEditor.this.highlightState(!TextFieldValueEditor.this.isShowError(errorText = TextFieldValueEditor.this.validateTextOnChange(TextFieldValueEditor.this.myField.getText(), e)));
                TextFieldValueEditor.this.setErrorText(errorText);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/components/fields/valueEditors/TextFieldValueEditor$1", "textChanged"));
            }
        });
    }

    protected boolean isShowError(@Nullable String errorText) {
        return errorText != null && StringUtil.isNotEmpty((String)errorText);
    }

    protected String validateTextOnChange(String text, DocumentEvent e) {
        try {
            Object newValue = this.parseValue(text);
            this.fireValueChanged(newValue);
            return null;
        }
        catch (InvalidDataException ex) {
            return ex.getMessage();
        }
    }

    private void highlightState(boolean isValid) {
        this.myField.putClientProperty("JComponent.outline", isValid ? null : "error");
    }

    protected void setErrorText(@Nullable String errorText) {
    }

    @Override
    public String getValueText() {
        return this.myField.getText();
    }

    @Override
    public void setValueText(@NotNull String text) {
        if (text == null) {
            TextFieldValueEditor.$$$reportNull$$$0(2);
        }
        this.myField.setText(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/components/fields/valueEditors/TextFieldValueEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setValueText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

