/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.navigation;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.navigation.HistoryListener;
import com.intellij.ui.navigation.Place;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class History {
    public static final DataKey<History> KEY = DataKey.create((String)"History");
    private final List<Place> history;
    private int currentPos;
    private final Place.Navigator root;
    private boolean navigatedNow;
    private final CopyOnWriteArraySet<HistoryListener> listeners;

    public History(@NotNull Place.Navigator root) {
        if (root == null) {
            History.$$$reportNull$$$0(0);
        }
        this.history = new ArrayList<Place>();
        this.listeners = new CopyOnWriteArraySet();
        this.root = root;
    }

    @RequiresEdt
    public void pushQueryPlace() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isNavigatingNow()) {
            return;
        }
        Place place = this.query();
        this.pushPlace(place);
    }

    private synchronized void pushPlace(@NotNull Place place) {
        if (place == null) {
            History.$$$reportNull$$$0(1);
        }
        while (this.currentPos >= 0 && this.currentPos < this.history.size() - 1) {
            this.history.remove(this.history.size() - 1);
        }
        if (!this.history.isEmpty()) {
            Place prev = this.history.get(this.history.size() - 1);
            if (prev.equals(place)) {
                return;
            }
            if (prev.isMoreGeneralFor(place)) {
                this.history.remove(prev);
            }
        }
        this.addPlace(place);
    }

    private synchronized void addPlace(Place place) {
        this.history.add(place);
        this.currentPos = this.history.size() - 1;
    }

    public void pushPlaceForElement(String name, Object value2) {
        if (!this.canNavigateFor(name)) {
            return;
        }
        Place checkPlace = this.getCheckPlace(name);
        if (checkPlace == null) {
            return;
        }
        this.pushPlace(checkPlace.cloneForElement(name, value2));
    }

    public void navigateTo(Place place) {
        this.root.navigateTo(place, false);
    }

    @RequiresEdt
    public void back() {
        ThreadingAssertions.assertEventDispatchThread();
        int next = this.findValid(-1);
        if (next == -1) {
            return;
        }
        this.goThere(next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findValid(int increment) {
        int first;
        ArrayList<Place> places = new ArrayList<Place>();
        History history = this;
        synchronized (history) {
            for (int idx = first = this.currentPos + increment; idx >= 0 && idx < this.history.size(); idx += increment) {
                places.add(this.history.get(idx));
            }
        }
        int index = ContainerUtil.indexOf(places, place -> this.root.isValid((Place)place));
        return index == -1 ? -1 : first + index * increment;
    }

    private void goThere(int nextPos) {
        this.navigatedNow = true;
        Place next = this.history.get(nextPos);
        Place from = this.getCurrent();
        this.fireStarted(from, next);
        try {
            ActionCallback callback = this.root.navigateTo(next, false);
            assert (callback != null);
            callback.doWhenDone(() -> {
                History history = this;
                synchronized (history) {
                    this.currentPos = nextPos;
                }
            }).doWhenProcessed(() -> {
                this.navigatedNow = false;
                this.fireFinished(from, next);
            });
        }
        catch (Throwable e) {
            this.navigatedNow = false;
            throw new RuntimeException(e);
        }
    }

    public boolean isNavigatingNow() {
        return this.navigatedNow;
    }

    public boolean canGoBack() {
        return this.findValid(-1) != -1;
    }

    @RequiresEdt
    public void forward() {
        ThreadingAssertions.assertEventDispatchThread();
        int next = this.findValid(1);
        if (next == -1) {
            return;
        }
        this.goThere(next);
    }

    public boolean canGoForward() {
        return this.findValid(1) != -1;
    }

    @RequiresEdt
    public synchronized void clear() {
        ThreadingAssertions.assertEventDispatchThread();
        this.history.clear();
        this.currentPos = -1;
    }

    @NotNull
    public Place query() {
        Place result2 = new Place();
        this.root.queryPlace(result2);
        Place place = result2;
        if (place == null) {
            History.$$$reportNull$$$0(2);
        }
        return place;
    }

    private synchronized Place getCurrent() {
        if (this.currentPos >= 0 && this.currentPos < this.history.size()) {
            return this.history.get(this.currentPos);
        }
        return null;
    }

    private boolean canNavigateFor(String pathElement) {
        if (this.isNavigatingNow()) {
            return false;
        }
        Place checkPlace = this.getCheckPlace(pathElement);
        return checkPlace != null && checkPlace.getPath(pathElement) != null;
    }

    @Nullable
    private Place getCheckPlace(String pathElement) {
        Place checkPlace = this.getCurrent();
        if (checkPlace == null || checkPlace.getPath(pathElement) == null) {
            checkPlace = this.query();
        }
        return checkPlace.getPath(pathElement) != null ? checkPlace : null;
    }

    public void addListener(final HistoryListener listener2, Disposable parent) {
        this.listeners.add(listener2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                History.this.listeners.remove(listener2);
            }
        });
    }

    private void fireStarted(Place from, Place to) {
        for (HistoryListener each : this.listeners) {
            each.navigationStarted(from, to);
        }
    }

    private void fireFinished(Place from, Place to) {
        for (HistoryListener each : this.listeners) {
            each.navigationFinished(from, to);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/navigation/History";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/navigation/History";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "pushPlace";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

