/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.multiRow;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.multiRow.CompressibleMultiRowLayout;
import com.intellij.ui.tabs.impl.multiRow.MultiRowPassInfo;
import com.intellij.ui.tabs.impl.multiRow.ScrollableMultiRowLayout;
import com.intellij.ui.tabs.impl.multiRow.TabsRow;
import com.intellij.ui.tabs.impl.multiRow.WrapMultiRowLayout;
import com.intellij.ui.tabs.impl.table.TableLayout;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010\u0019\u001a\u00020\rH \u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0016H\u0002J.\u0010\"\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0004J\b\u0010%\u001a\u00020\u001eH\u0016J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001eH\u0016J\b\u0010(\u001a\u00020\u0005H\u0016J \u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u001eH\u0016J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u001e2\u0006\u0010/\u001a\u000200H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u0082\u0001\u0003234\u00a8\u00065"}, d2={"Lcom/intellij/ui/tabs/impl/multiRow/MultiRowLayout;", "Lcom/intellij/ui/tabs/impl/table/TableLayout;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "showPinnedTabsSeparately", "", "<init>", "(Lcom/intellij/ui/tabs/impl/JBTabsImpl;Z)V", "getTabs", "()Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "getShowPinnedTabsSeparately", "()Z", "prevLayoutPassInfo", "Lcom/intellij/ui/tabs/impl/multiRow/MultiRowPassInfo;", "getPrevLayoutPassInfo$intellij_platform_ide", "()Lcom/intellij/ui/tabs/impl/multiRow/MultiRowPassInfo;", "setPrevLayoutPassInfo$intellij_platform_ide", "(Lcom/intellij/ui/tabs/impl/multiRow/MultiRowPassInfo;)V", "layoutTable", "Lcom/intellij/ui/tabs/impl/LayoutPassInfo;", "visibleInfos", "", "Lcom/intellij/ui/tabs/TabInfo;", "splitToRows", "Lcom/intellij/ui/tabs/impl/multiRow/TabsRow;", "data", "splitToRows$intellij_platform_ide", "layoutRows", "", "getRowY", "", "row", "layoutTabComponent", "info", "splitToPinnedUnpinned", "Lkotlin/Pair;", "infosToSplit", "getScrollOffset", "scroll", "units", "isWithScrollBar", "isDragOut", "tabLabel", "Lcom/intellij/ui/tabs/impl/TabLabel;", "deltaX", "deltaY", "getDropIndexFor", "point", "Ljava/awt/Point;", "doGetDropIndexFor", "Lcom/intellij/ui/tabs/impl/multiRow/CompressibleMultiRowLayout;", "Lcom/intellij/ui/tabs/impl/multiRow/ScrollableMultiRowLayout;", "Lcom/intellij/ui/tabs/impl/multiRow/WrapMultiRowLayout;", "intellij.platform.ide"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMultiRowLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiRowLayout.kt\ncom/intellij/ui/tabs/impl/multiRow/MultiRowLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n1#2:198\n1#2:216\n388#3,7:199\n1617#3,9:206\n1869#3:215\n1870#3:217\n1626#3:218\n1761#3,3:219\n*S KotlinDebug\n*F\n+ 1 MultiRowLayout.kt\ncom/intellij/ui/tabs/impl/multiRow/MultiRowLayout\n*L\n155#1:216\n109#1:199,7\n155#1:206,9\n155#1:215\n155#1:217\n155#1:218\n188#1:219,3\n*E\n"})
public abstract sealed class MultiRowLayout
extends TableLayout
permits CompressibleMultiRowLayout, ScrollableMultiRowLayout, WrapMultiRowLayout {
    @NotNull
    private final JBTabsImpl tabs;
    private final boolean showPinnedTabsSeparately;
    @Nullable
    private MultiRowPassInfo prevLayoutPassInfo;

    private MultiRowLayout(JBTabsImpl tabs, boolean showPinnedTabsSeparately) {
        super(tabs);
        this.tabs = tabs;
        this.showPinnedTabsSeparately = showPinnedTabsSeparately;
    }

    @NotNull
    protected final JBTabsImpl getTabs() {
        return this.tabs;
    }

    protected final boolean getShowPinnedTabsSeparately() {
        return this.showPinnedTabsSeparately;
    }

    @Nullable
    public final MultiRowPassInfo getPrevLayoutPassInfo$intellij_platform_ide() {
        return this.prevLayoutPassInfo;
    }

    public final void setPrevLayoutPassInfo$intellij_platform_ide(@Nullable MultiRowPassInfo multiRowPassInfo) {
        this.prevLayoutPassInfo = multiRowPassInfo;
    }

    @Override
    @NotNull
    public LayoutPassInfo layoutTable(@NotNull List<TabInfo> visibleInfos) {
        MultiRowPassInfo data;
        block2: {
            Intrinsics.checkNotNullParameter(visibleInfos, (String)"visibleInfos");
            this.tabs.resetLayout(true);
            Insets insets = this.tabs.getLayoutInsets();
            Rectangle toFitRec = new Rectangle(insets.left, insets.top, this.tabs.getWidth() - insets.left - insets.right, this.tabs.getHeight() - insets.top - insets.bottom);
            this.prevLayoutPassInfo = data = new MultiRowPassInfo(this.tabs, visibleInfos, toFitRec, this.getScrollOffset());
            if (!(this.tabs.isHideTabs() || visibleInfos.isEmpty() || data.toFitRec.isEmpty())) {
                List<TabsRow> rows = this.splitToRows$intellij_platform_ide(data);
                data.getRows().addAll((Collection<TabsRow>)rows);
                this.layoutRows(data);
                int topRowInd = this.tabs.getTabsPosition() == JBTabsPosition.top ? 0 : rows.size() - 1;
                data.setTabsRectangle(new Rectangle(toFitRec.x, this.getRowY(data, topRowInd), toFitRec.width, data.getRowCount() * data.getRowHeight()));
            }
            this.tabs.getTitleWrapper().setBounds(data.titleRect);
            ActionToolbar actionToolbar = this.tabs.getMoreToolbar();
            Intrinsics.checkNotNull((Object)actionToolbar);
            actionToolbar.getComponent().setBounds(data.moreRect);
            Object object = this.tabs.entryPointToolbar;
            if (object != null && (object = object.getComponent()) != null) {
                ((Component)object).setBounds(data.entryPointRect);
            }
            TabInfo tabInfo = this.tabs.getSelectedInfo();
            if (tabInfo == null) break block2;
            TabInfo it = tabInfo;
            boolean bl = false;
            this.layoutTabComponent(data, it);
        }
        return data;
    }

    @NotNull
    public abstract List<TabsRow> splitToRows$intellij_platform_ide(@NotNull MultiRowPassInfo var1);

    private final void layoutRows(MultiRowPassInfo data) {
        Iterator iterator = ((Iterable)data.getRows()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            TabsRow row = (TabsRow)iterator.next();
            int y = this.getRowY(data, index);
            row.layoutRow$intellij_platform_ide(data, y);
        }
    }

    private final int getRowY(MultiRowPassInfo data, int row) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.tabs.getTabsPosition().ordinal()]) {
            case 1 -> data.toFitRec.y + row * data.getRowHeight();
            case 2 -> data.toFitRec.y + data.toFitRec.height - (row + 1) * data.getRowHeight();
            default -> throw new IllegalStateException("MultiRowLayout is not supported for vertical placements".toString());
        };
    }

    private final void layoutTabComponent(MultiRowPassInfo data, TabInfo info) {
        JBTabsImpl.Toolbar toolbar = this.tabs.getInfoToToolbar().get(info);
        int componentY = switch (WhenMappings.$EnumSwitchMapping$0[this.tabs.getTabsPosition().ordinal()]) {
            case 1 -> data.getRowCount() * data.getRowHeight();
            case 2 -> 0;
            default -> throw new IllegalStateException("MultiRowLayout is not supported for vertical placements".toString());
        };
        int componentHeight = switch (WhenMappings.$EnumSwitchMapping$0[this.tabs.getTabsPosition().ordinal()]) {
            case 1 -> this.tabs.getHeight();
            case 2 -> this.tabs.getHeight() - data.getRowCount() * data.getRowHeight();
            default -> throw new IllegalStateException("MultiRowLayout is not supported for vertical placements".toString());
        };
        if (!this.tabs.getHorizontalSide() && toolbar != null && !toolbar.isEmpty()) {
            int vSeparatorWidth;
            int toolbarWidth = toolbar.getPreferredSize().width;
            int n = vSeparatorWidth = toolbarWidth > 0 ? this.tabs.separatorWidth : 0;
            if (this.tabs.isSideComponentBefore()) {
                Rectangle compRect = this.tabs.layoutComp(new Rectangle(toolbarWidth + vSeparatorWidth, componentY, this.tabs.getWidth(), componentHeight), info.getComponent(), 0, 0);
                v3 = this.tabs.layout(toolbar, compRect.x - toolbarWidth - vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
            } else {
                int width = this.tabs.getWidth() - toolbarWidth - vSeparatorWidth;
                Rectangle compRect = this.tabs.layoutComp(new Rectangle(0, componentY, width, componentHeight), info.getComponent(), 0, 0);
                v3 = this.tabs.layout(toolbar, compRect.x + compRect.width + vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
            }
        } else {
            v3 = this.tabs.layoutComp(new Rectangle(0, componentY, this.tabs.getWidth(), componentHeight), info.getComponent(), 0, 0);
        }
    }

    @NotNull
    protected final Pair<List<TabInfo>, List<TabInfo>> splitToPinnedUnpinned(@NotNull List<TabInfo> infosToSplit) {
        boolean bl;
        int lastPinnedInd;
        TabInfo it;
        List infos;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter(infosToSplit, (String)"infosToSplit");
            List $this$indexOfLast$iv = infos = CollectionsKt.toList((Iterable)infosToSplit);
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                it = (TabInfo)iterator$iv.previous();
                boolean bl2 = false;
                if (!it.isPinned()) continue;
                n = iterator$iv.nextIndex();
                break block4;
            }
            n = lastPinnedInd = -1;
        }
        if (lastPinnedInd == -1) {
            return TuplesKt.to((Object)CollectionsKt.emptyList(), (Object)infos);
        }
        TabInfo tabInfo = (TabInfo)CollectionsKt.getOrNull((List)infos, (int)(lastPinnedInd + 1));
        if (tabInfo != null) {
            it = tabInfo;
            boolean bl3 = false;
            bl = this.tabs.isDropTarget(it);
        } else {
            bl = false;
        }
        int pinnedRowEndInd = bl ? lastPinnedInd + 1 : lastPinnedInd;
        List pinned = infos.subList(0, pinnedRowEndInd + 1);
        List unpinned = infos.subList(pinnedRowEndInd + 1, infos.size());
        return TuplesKt.to(pinned, unpinned);
    }

    @Override
    public int getScrollOffset() {
        return 0;
    }

    @Override
    public void scroll(int units) {
    }

    @Override
    public boolean isWithScrollBar() {
        return false;
    }

    @Override
    public boolean isDragOut(@NotNull TabLabel tabLabel, int deltaX, int deltaY) {
        Intrinsics.checkNotNullParameter((Object)tabLabel, (String)"tabLabel");
        MultiRowPassInfo data = this.prevLayoutPassInfo;
        if (data == null) {
            return super.isDragOut(tabLabel, deltaX, deltaY);
        }
        return (double)Math.abs(deltaY) > (double)data.getTabsRectangle().height * TableLayout.getDragOutMultiplier();
    }

    @Override
    public int getDropIndexFor(@NotNull Point point) {
        Point point2;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        int tabsAt = this.doGetDropIndexFor(point);
        if (tabsAt != -1) {
            return tabsAt;
        }
        int tolerance = JBUI.scale((int)15);
        Point point3 = point2 = new Point(point);
        MultiRowLayout multiRowLayout = this;
        boolean bl = false;
        $this$getDropIndexFor_u24lambda_u240.y += tolerance;
        int tabsBelow = multiRowLayout.doGetDropIndexFor(point2);
        if (tabsBelow != -1) {
            return tabsBelow;
        }
        Point $this$getDropIndexFor_u24lambda_u240 = point2 = new Point(point);
        multiRowLayout = this;
        boolean bl2 = false;
        $this$getDropIndexFor_u24lambda_u241.y -= tolerance;
        return multiRowLayout.doGetDropIndexFor(point2);
    }

    /*
     * WARNING - void declaration
     */
    private final int doGetDropIndexFor(Point point) {
        void $this$mapNotNullTo$iv$iv2;
        MultiRowPassInfo data = this.prevLayoutPassInfo;
        if (data == null) {
            return -1;
        }
        int result2 = -1;
        Iterable $this$mapNotNull$iv = data.getRows();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TabInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TabsRow it = (TabsRow)element$iv$iv;
            boolean bl2 = false;
            if ((TabInfo)CollectionsKt.lastOrNull(it.getInfos()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List lastInRow = (List)destination$iv$iv;
        Component component = this.tabs.getComponentAt(point);
        if (component instanceof JBTabsImpl) {
            int $this$mapNotNullTo$iv$iv2 = data.visibleInfos.size() - 1;
            for (int i = 0; i < $this$mapNotNullTo$iv$iv2; ++i) {
                boolean between;
                TabLabel second;
                TabLabel first;
                TabInfo firstInfo = (TabInfo)data.visibleInfos.get(i);
                TabInfo secondInfo = (TabInfo)data.visibleInfos.get(i + 1);
                Intrinsics.checkNotNull((Object)firstInfo);
                Intrinsics.checkNotNull((Object)this.tabs.getTabLabel(firstInfo));
                Intrinsics.checkNotNull((Object)secondInfo);
                Intrinsics.checkNotNull((Object)this.tabs.getTabLabel(secondInfo));
                Rectangle firstBounds = first.getBounds();
                Rectangle secondBounds = second.getBounds();
                boolean bl = between = firstBounds.getMaxX() < (double)point.x && secondBounds.getX() > (double)point.x && firstBounds.y < point.y && secondBounds.getMaxY() > (double)point.y;
                if (between) {
                    component = first;
                    break;
                }
                if (!lastInRow.contains(firstInfo) || firstBounds.y > point.y || !(firstBounds.getMaxY() >= (double)point.y) || !(firstBounds.getMaxX() <= (double)point.x)) continue;
                component = second;
                break;
            }
        }
        if (component instanceof TabLabel) {
            TabInfo info = ((TabLabel)component).getInfo();
            int index = data.visibleInfos.indexOf(info);
            if (!this.tabs.isDropTarget(info)) {
                boolean bl;
                block12: {
                    Iterable $this$any$iv = data.visibleInfos.subList(0, index + 1);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            TabInfo it = (TabInfo)element$iv;
                            boolean bl4 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!this.tabs.isDropTarget(it)) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                boolean dropTargetBefore = bl;
                result2 = index - (dropTargetBefore ? 1 : 0);
            } else if (index < data.visibleInfos.size()) {
                result2 = index;
            }
        }
        return result2;
    }

    public /* synthetic */ MultiRowLayout(JBTabsImpl tabs, boolean showPinnedTabsSeparately, DefaultConstructorMarker $constructor_marker) {
        this(tabs, showPinnedTabsSeparately);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JBTabsPosition.values().length];
            try {
                nArray[JBTabsPosition.top.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JBTabsPosition.bottom.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

