/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.ide.navigation.NavigationOptions;
import com.intellij.platform.ide.navigation.NavigationService;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.tree.ExpandOnDoubleClick;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010\u0007\u001a\u00020\b2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u001a\u0010\u0016\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/EditSourceOnDoubleClickHandler;", "", "<init>", "()V", "INSTALLED", "Lcom/intellij/openapi/util/Key;", "", "install", "", "tree", "Ljavax/swing/JTree;", "whenPerformed", "Ljava/lang/Runnable;", "treeTable", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "table", "Ljavax/swing/JTable;", "list", "Ljavax/swing/JList;", "isToggleEvent", "e", "Ljava/awt/event/MouseEvent;", "isExpandPreferable", "path", "Ljavax/swing/tree/TreePath;", "TreeMouseListener", "intellij.platform.ide"})
public final class EditSourceOnDoubleClickHandler {
    @NotNull
    public static final EditSourceOnDoubleClickHandler INSTANCE = new EditSourceOnDoubleClickHandler();
    @JvmField
    @ApiStatus.Internal
    @NotNull
    public static final Key<Boolean> INSTALLED;

    private EditSourceOnDoubleClickHandler() {
    }

    @JvmStatic
    @JvmOverloads
    public static final void install(@NotNull JTree tree, @Nullable Runnable whenPerformed) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        new TreeMouseListener(tree, whenPerformed).installOn(tree);
    }

    public static /* synthetic */ void install$default(JTree jTree, Runnable runnable, int n, Object object) {
        if ((n & 2) != 0) {
            runnable = null;
        }
        EditSourceOnDoubleClickHandler.install(jTree, runnable);
    }

    @JvmStatic
    public static final void install(@NotNull TreeTable treeTable) {
        Intrinsics.checkNotNullParameter((Object)treeTable, (String)"treeTable");
        new DoubleClickListener(treeTable){
            final /* synthetic */ TreeTable $treeTable;
            {
                this.$treeTable = $treeTable;
            }

            protected boolean onDoubleClick(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!ModalityState.current().accepts(ModalityState.nonModal()) || this.$treeTable.getTree().getPathForLocation(e.getX(), e.getY()) == null) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.$treeTable);
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                DataContext dataContext2 = dataContext;
                if ((Project)CommonDataKeys.PROJECT.getData(dataContext2) == null) {
                    return false;
                }
                OpenSourceUtil.openSourcesFrom(dataContext2, true);
                return true;
            }
        }.installOn(treeTable);
    }

    @JvmStatic
    public static final void install(@NotNull JTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        new DoubleClickListener(table){
            final /* synthetic */ JTable $table;
            {
                this.$table = $table;
            }

            protected boolean onDoubleClick(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!ModalityState.current().accepts(ModalityState.nonModal()) || this.$table.columnAtPoint(e.getPoint()) < 0 || this.$table.rowAtPoint(e.getPoint()) < 0) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.$table);
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                DataContext dataContext2 = dataContext;
                if ((Project)CommonDataKeys.PROJECT.getData(dataContext2) == null) {
                    return false;
                }
                OpenSourceUtil.openSourcesFrom(dataContext2, true);
                return true;
            }
        }.installOn(table);
    }

    @JvmStatic
    @JvmOverloads
    public static final void install(@NotNull JList<?> list, @Nullable Runnable whenPerformed) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        new DoubleClickListener(list, whenPerformed){
            final /* synthetic */ JList<?> $list;
            final /* synthetic */ Runnable $whenPerformed;
            {
                this.$list = $list;
                this.$whenPerformed = $whenPerformed;
            }

            protected boolean onDoubleClick(MouseEvent e) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Point point = e.getPoint();
                    int index = this.$list.locationToIndex(point);
                    if (index == -1 || !this.$list.getCellBounds(index, index).contains(point)) {
                        return false;
                    }
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.$list);
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                    DataContext dataContext2 = dataContext;
                    OpenSourceUtil.openSourcesFrom(dataContext2, true);
                    Runnable runnable = this.$whenPerformed;
                    if (runnable == null) break block1;
                    runnable.run();
                }
                return true;
            }
        }.installOn(list);
    }

    public static /* synthetic */ void install$default(JList jList, Runnable runnable, int n, Object object) {
        if ((n & 2) != 0) {
            runnable = null;
        }
        EditSourceOnDoubleClickHandler.install(jList, runnable);
    }

    @JvmStatic
    public static final boolean isToggleEvent(@NotNull JTree tree, @NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return false;
        }
        int count = tree.getToggleClickCount();
        if (count <= 0 || e.getClickCount() % count != 0) {
            return false;
        }
        return EditSourceOnDoubleClickHandler.isExpandPreferable(tree, tree.getSelectionPath());
    }

    @JvmStatic
    public static final boolean isExpandPreferable(@NotNull JTree tree, @Nullable TreePath path) {
        Navigatable navigatable;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        if (path == null) {
            return false;
        }
        ExpandOnDoubleClick expandOnDoubleClick = ExpandOnDoubleClick.getBehavior(tree);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)expandOnDoubleClick), (String)"getBehavior(...)");
        ExpandOnDoubleClick behavior = expandOnDoubleClick;
        if (behavior == ExpandOnDoubleClick.NEVER) {
            return false;
        }
        TreeModel model = tree.getModel();
        if (model == null || model.isLeaf(path.getLastPathComponent())) {
            return false;
        }
        if (!ClientProperty.isTrue((Component)tree, INSTALLED)) {
            return true;
        }
        if (behavior == ExpandOnDoubleClick.NAVIGATABLE && (navigatable = TreeUtil.getNavigatable(tree, path)) != null && navigatable.canNavigateToSource()) {
            return false;
        }
        if (behavior == ExpandOnDoubleClick.ALWAYS) {
            return true;
        }
        NodeDescriptor descriptor2 = TreeUtil.getLastUserObject(NodeDescriptor.class, path);
        return descriptor2 == null || descriptor2.expandOnDoubleClick();
    }

    @JvmStatic
    @JvmOverloads
    public static final void install(@NotNull JTree tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        EditSourceOnDoubleClickHandler.install$default(tree, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void install(@NotNull JList<?> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        EditSourceOnDoubleClickHandler.install$default(list, null, 2, null);
    }

    static {
        Key key = Key.create((String)"EditSourceOnDoubleClickHandlerInstalled");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        INSTALLED = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/util/EditSourceOnDoubleClickHandler$TreeMouseListener;", "Lcom/intellij/ui/DoubleClickListener;", "tree", "Ljavax/swing/JTree;", "whenPerformed", "Ljava/lang/Runnable;", "<init>", "(Ljavax/swing/JTree;Ljava/lang/Runnable;)V", "installOn", "", "c", "Ljava/awt/Component;", "allowDragWhileClicking", "", "uninstall", "onDoubleClick", "e", "Ljava/awt/event/MouseEvent;", "processDoubleClick", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "treePath", "Ljavax/swing/tree/TreePath;", "intellij.platform.ide"})
    public static class TreeMouseListener
    extends DoubleClickListener {
        @NotNull
        private final JTree tree;
        @Nullable
        private final Runnable whenPerformed;

        @JvmOverloads
        public TreeMouseListener(@NotNull JTree tree, @Nullable Runnable whenPerformed) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            this.tree = tree;
            this.whenPerformed = whenPerformed;
        }

        public /* synthetic */ TreeMouseListener(JTree jTree, Runnable runnable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                runnable = null;
            }
            this(jTree, runnable);
        }

        public void installOn(@NotNull Component c, boolean allowDragWhileClicking) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            super.installOn(c, allowDragWhileClicking);
            this.tree.putClientProperty(INSTALLED, true);
        }

        public void uninstall(@NotNull Component c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            super.uninstall(c);
            this.tree.putClientProperty(INSTALLED, null);
        }

        @Override
        public boolean onDoubleClick(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TreePath treePath = WideSelectionTreeUI.isWideSelection((JTree)this.tree) ? this.tree.getClosestPathForLocation(e.getX(), e.getY()) : this.tree.getPathForLocation(e.getX(), e.getY());
            if (treePath == null) {
                return false;
            }
            TreePath clickPath = treePath;
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.tree);
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            DataContext dataContext2 = dataContext;
            if ((Project)CommonDataKeys.PROJECT.getData(dataContext2) == null) {
                return false;
            }
            TreePath selectionPath = this.tree.getSelectionPath();
            if (!Intrinsics.areEqual((Object)clickPath, (Object)selectionPath)) {
                return false;
            }
            if (EditSourceOnDoubleClickHandler.isToggleEvent(this.tree, e)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)selectionPath);
            this.processDoubleClick(e, dataContext2, selectionPath);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processDoubleClick(@NotNull MouseEvent e, @NotNull DataContext dataContext, @NotNull TreePath treePath) {
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                    Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
                    if (!Registry.Companion.is("ide.navigation.requests")) break block7;
                    Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
                    if (project == null) {
                        return;
                    }
                    Project project2 = project;
                    DataContext dataContext2 = IdeUiService.getInstance().createAsyncDataContext(dataContext);
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"createAsyncDataContext(...)");
                    DataContext asyncContext = dataContext2;
                    BuildersKt.launch$default((CoroutineScope)((ComponentManagerEx)project2).getCoroutineScope(), (CoroutineContext)ClientId.Companion.coroutineContext(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project2, asyncContext, this, null){
                        Object L$0;
                        Object L$1;
                        int I$0;
                        int label;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ DataContext $asyncContext;
                        final /* synthetic */ TreeMouseListener this$0;
                        {
                            this.$project = $project;
                            this.$asyncContext = $asyncContext;
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    options = NavigationOptions.Companion.defaultOptions().requestFocus(true).preserveCaret(true);
                                    $this$serviceAsync$iv = (ComponentManager)this.$project;
                                    $i$f$serviceAsync = 0;
                                    Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                                    this.L$0 = options;
                                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                                    this.I$0 = $i$f$serviceAsync;
                                    this.label = 1;
                                    v0 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(NavigationService.class, (Continuation)this);
                                    if (v0 == var7_2) {
                                        return var7_2;
                                    }
                                    ** GOTO lbl24
                                }
                                case 1: {
                                    $i$f$serviceAsync = this.I$0;
                                    $this$serviceAsync$iv = (ComponentManager)this.L$1;
                                    options = (NavigationOptions)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl24:
                                    // 2 sources

                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)options);
                                    this.L$1 = null;
                                    this.label = 2;
                                    v1 = ((NavigationService)v0).navigate(this.$asyncContext, options, (Continuation<? super Unit>)((Continuation)this));
                                    if (v1 == var7_2) {
                                        return var7_2;
                                    }
                                    ** GOTO lbl35
                                }
                                case 2: {
                                    options = (NavigationOptions)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl35:
                                    // 2 sources

                                    v2 = TreeMouseListener.access$getWhenPerformed$p(this.this$0);
                                    if (v2 == null) break;
                                    task = v2;
                                    $i$a$-let-EditSourceOnDoubleClickHandler$TreeMouseListener$processDoubleClick$1$1 = 0;
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)options);
                                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)task);
                                    this.I$0 = $i$a$-let-EditSourceOnDoubleClickHandler$TreeMouseListener$processDoubleClick$1$1;
                                    this.label = 3;
                                    v3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(task, null){
                                        int label;
                                        final /* synthetic */ Runnable $task;
                                        {
                                            this.$task = $task;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    this.label = 1;
                                                    Object object2 = CoroutinesKt.writeIntentReadAction(() -> processDoubleClick.1.1.invokeSuspend$lambda$0(this.$task), (Continuation)((Continuation)this));
                                                    if (object2 != object) return Unit.INSTANCE;
                                                    return object;
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    Object object2 = $result;
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }

                                        private static final Unit invokeSuspend$lambda$0(Runnable $task) {
                                            $task.run();
                                            return Unit.INSTANCE;
                                        }
                                    }), (Continuation)this);
                                    if (v3 == var7_2) {
                                        return var7_2;
                                    }
                                    break;
                                }
                                case 3: {
                                    $i$a$-let-EditSourceOnDoubleClickHandler$TreeMouseListener$processDoubleClick$1$1 = this.I$0;
                                    task = (Runnable)this.L$1;
                                    options = (NavigationOptions)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v3 = $result;
                                    break;
                                }
                            }
                            return Unit.INSTANCE;
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    break block8;
                }
                AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"IDEA-304701, EA-659716");
                Throwable throwable = null;
                try {
                    AccessToken it = (AccessToken)autoCloseable;
                    boolean bl = false;
                    OpenSourceUtil.openSourcesFrom(dataContext, true);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                Runnable runnable = this.whenPerformed;
                if (runnable == null) break block8;
                runnable.run();
            }
        }

        @JvmOverloads
        public TreeMouseListener(@NotNull JTree tree) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            this(tree, null, 2, null);
        }

        public static final /* synthetic */ Runnable access$getWhenPerformed$p(TreeMouseListener $this) {
            return $this.whenPerformed;
        }
    }
}

