/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.pom.StatePreservingNavigatable;
import com.intellij.util.OpenSourceUtilKt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OpenSourceUtil {
    private OpenSourceUtil() {
    }

    public static void openSourcesFrom(@NotNull DataContext context, boolean requestFocus) {
        if (context == null) {
            OpenSourceUtil.$$$reportNull$$$0(0);
        }
        if (Registry.is((String)"ide.navigation.requests")) {
            OpenSourceUtilKt.openSourcesFrom(context, requestFocus);
            return;
        }
        OpenSourceUtil.navigate(requestFocus, false, (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(context));
    }

    public static void navigate(Navigatable ... navigatables) {
        OpenSourceUtil.navigate(true, navigatables);
    }

    public static void navigate(boolean requestFocus, Navigatable ... navigatables) {
        OpenSourceUtil.navigate(requestFocus, false, navigatables);
    }

    public static void navigate(boolean requestFocus, boolean tryNotToScroll, Navigatable ... navigatables) {
        if (navigatables != null && navigatables.length > 0) {
            OpenSourceUtil.navigate(requestFocus, tryNotToScroll, List.of(navigatables));
        }
    }

    public static boolean navigate(boolean requestFocus, boolean tryNotToScroll, @Nullable Iterable<? extends Navigatable> navigatables) {
        Project project;
        if (navigatables == null) {
            return false;
        }
        if (Registry.is((String)"ide.navigation.requests") && (project = OpenSourceUtilKt.findProject(navigatables)) != null) {
            return OpenSourceUtilKt.navigate(project, requestFocus, tryNotToScroll, navigatables);
        }
        Navigatable nonSourceNavigatable = null;
        int maxSourcesToNavigate = Registry.intValue((String)"ide.source.file.navigation.limit", (int)100);
        int navigatedSourcesCounter = 0;
        for (Navigatable navigatable : navigatables) {
            if (maxSourcesToNavigate > 0 && navigatedSourcesCounter >= maxSourcesToNavigate) break;
            if (OpenSourceUtil.navigateToSource(requestFocus, tryNotToScroll, navigatable)) {
                ++navigatedSourcesCounter;
                continue;
            }
            if (navigatedSourcesCounter != 0 || nonSourceNavigatable != null || navigatable == null || !navigatable.canNavigate()) continue;
            nonSourceNavigatable = navigatable;
        }
        if (navigatedSourcesCounter > 0) {
            return true;
        }
        if (nonSourceNavigatable == null) {
            return false;
        }
        nonSourceNavigatable.navigate(requestFocus);
        return true;
    }

    public static boolean navigateToSource(boolean requestFocus, boolean tryNotToScroll, @Nullable Iterable<? extends Navigatable> navigatables) {
        if (navigatables == null) {
            return false;
        }
        boolean alreadyNavigatedToSource = false;
        for (Navigatable navigatable : navigatables) {
            if (!OpenSourceUtil.navigateToSource(requestFocus, tryNotToScroll, navigatable)) continue;
            alreadyNavigatedToSource = true;
        }
        return alreadyNavigatedToSource;
    }

    public static boolean navigateToSource(boolean requestFocus, boolean tryNotToScroll, @Nullable Navigatable navigatable) {
        Project project;
        if (navigatable == null) {
            return false;
        }
        if (Registry.is((String)"ide.navigation.requests") && (project = OpenSourceUtilKt.findProject(navigatable)) != null) {
            return OpenSourceUtilKt.navigateToSource(project, requestFocus, tryNotToScroll, navigatable);
        }
        if (!navigatable.canNavigateToSource()) {
            return false;
        }
        if (tryNotToScroll && navigatable instanceof StatePreservingNavigatable) {
            ((StatePreservingNavigatable)navigatable).navigate(requestFocus, true);
        } else {
            navigatable.navigate(requestFocus);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/util/OpenSourceUtil", "openSourcesFrom"));
    }
}

