/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@State(name="DateTimeFormatter", storages={@Storage(value="ui-datetime.xml")}, category=SettingsCategory.SYSTEM)
@ApiStatus.Internal
public final class DateTimeFormatManager
implements PersistentStateComponent<DateTimeFormatManager> {
    private static final String DEFAULT_DATE_FORMAT = "dd MMM yyyy";
    private boolean myOverrideSystemDateFormat = false;
    private boolean myUse24HourTime = true;
    private String myPattern = "dd MMM yyyy";
    private boolean myPrettyFormattingAllowed = true;
    private volatile Formats myFormats;

    public DateTimeFormatManager getState() {
        return this;
    }

    public void loadState(@NotNull DateTimeFormatManager state) {
        if (state == null) {
            DateTimeFormatManager.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        this.resetFormats();
    }

    public boolean isOverrideSystemDateFormat() {
        return this.myOverrideSystemDateFormat;
    }

    public void setOverrideSystemDateFormat(boolean overrideSystemDateFormat) {
        this.myOverrideSystemDateFormat = overrideSystemDateFormat;
    }

    public boolean isUse24HourTime() {
        return this.myUse24HourTime;
    }

    public void setUse24HourTime(boolean use24HourTime) {
        this.myUse24HourTime = use24HourTime;
    }

    @NotNull
    public String getDateFormatPattern() {
        String string = this.myPattern;
        if (string == null) {
            DateTimeFormatManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setDateFormatPattern(@NotNull String pattern) {
        if (pattern == null) {
            DateTimeFormatManager.$$$reportNull$$$0(2);
        }
        try {
            new SimpleDateFormat(pattern);
            this.myPattern = pattern;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isPrettyFormattingAllowed() {
        return this.myPrettyFormattingAllowed;
    }

    public void setPrettyFormattingAllowed(boolean prettyFormattingAllowed) {
        this.myPrettyFormattingAllowed = prettyFormattingAllowed;
    }

    public static DateTimeFormatManager getInstance() {
        return (DateTimeFormatManager)ApplicationManager.getApplication().getService(DateTimeFormatManager.class);
    }

    Formats getFormats() {
        Formats formats = this.myFormats;
        if (formats == null) {
            formats = this.myOverrideSystemDateFormat ? DateFormatUtil.getCustomFormats(this) : DateFormatUtil.getSystemFormats();
            this.myFormats = formats;
        }
        return formats;
    }

    @ApiStatus.Internal
    @NotNull
    public DateFormat getDateFormat() {
        DateFormat dateFormat = this.getFormats().dateFmt;
        if (dateFormat == null) {
            DateTimeFormatManager.$$$reportNull$$$0(3);
        }
        return dateFormat;
    }

    @ApiStatus.Internal
    public void resetFormats() {
        this.myFormats = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/DateTimeFormatManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/DateTimeFormatManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateFormatPattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDateFormatPattern";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    record Formats(DateTimeFormatter date, DateTimeFormatter timeShort, DateTimeFormatter timeMedium, DateTimeFormatter dateTime, DateFormat dateFmt, DateFormat dateTimeFmt) {
    }
}

