/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.execution.ui.FragmentStatisticsService;
import com.intellij.execution.ui.FragmentWrapper;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentHintManager {
    private final List<SettingsEditorFragment<?, ?>> myFragments;
    private final Set<String> myHints;
    @NotNull
    private final Consumer<? super String> myHintConsumer;
    private final String myDefaultHint;
    private final String myConfigId;
    private long myHintsShownTime;

    public FragmentHintManager(@NotNull Consumer<? super @NlsContexts.DialogMessage String> hintConsumer, @NlsContexts.DialogMessage @Nullable String defaultHint, @Nullable String configId, @NotNull Disposable disposable) {
        if (hintConsumer == null) {
            FragmentHintManager.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            FragmentHintManager.$$$reportNull$$$0(1);
        }
        this.myFragments = new ArrayList();
        this.myHints = new HashSet<String>();
        this.myHintConsumer = hintConsumer;
        this.myDefaultHint = defaultHint;
        this.myConfigId = configId;
        hintConsumer.consume((Object)defaultHint);
        AWTEventListener listener2 = event -> this.processKeyEvent((KeyEvent)event);
        Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 8L);
        Disposer.register((Disposable)disposable, () -> Toolkit.getDefaultToolkit().removeAWTEventListener(listener2));
    }

    public void registerFragments(Collection<? extends SettingsEditorFragment<?, ?>> fragments2) {
        fragments2.forEach(fragment -> this.registerFragment((SettingsEditorFragment<?, ?>)((Object)fragment)));
    }

    public void registerFragment(SettingsEditorFragment<?, ?> fragment) {
        this.myFragments.add(fragment);
        for (JComponent jComponent : fragment.getAllComponents()) {
            this.registerComponent(fragment, FragmentHintManager.getComponent(jComponent));
        }
    }

    private void registerComponent(final SettingsEditorFragment<?, ?> fragment, final JComponent component) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                FragmentHintManager.this.showHint(fragment, component);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FragmentHintManager.this.showHint(null, component);
            }
        });
        component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                FragmentHintManager.this.showHint(fragment, component);
            }

            @Override
            public void focusLost(FocusEvent e) {
                FragmentHintManager.this.showHint(null, component);
            }
        });
    }

    private static JComponent getComponent(JComponent component) {
        if (component instanceof LabeledComponent) {
            component = ((LabeledComponent)component).getComponent();
        }
        if (component instanceof FragmentWrapper) {
            FragmentWrapper wrapper = (FragmentWrapper)((Object)component);
            component = wrapper.getComponentToRegister();
        }
        if (component instanceof ComponentWithBrowseButton) {
            component = ((ComponentWithBrowseButton)component).getChildComponent();
        }
        return component;
    }

    private void showHint(@Nullable SettingsEditorFragment<?, ?> fragment, @Nullable JComponent component) {
        String text;
        String hint = this.myDefaultHint;
        if (fragment != null) {
            hint = fragment.getHint(component);
        } else {
            fragment = (SettingsEditorFragment)((Object)ContainerUtil.find(this.myFragments, f -> f.getEditorComponent().hasFocus()));
            if (fragment != null) {
                hint = fragment.getHint(component);
            }
        }
        if (fragment != null && (text = FragmentHintManager.getShortcutText(fragment)) != null) {
            hint = hint == null ? text : StringUtil.trimEnd((String)hint, (String)".") + ". " + text;
        }
        this.myHintConsumer.consume((Object)(hint == null ? this.myDefaultHint : hint));
    }

    @Nullable
    @NlsSafe
    private static String getShortcutText(@NotNull SettingsEditorFragment<?, ?> fragment) {
        ShortcutSet shortcut;
        if (fragment == null) {
            FragmentHintManager.$$$reportNull$$$0(2);
        }
        if ((shortcut = ActionUtil.getMnemonicAsShortcut(EmptyAction.createEmptyAction(fragment.getName(), null, false))) != null && shortcut.hasShortcuts()) {
            return KeymapUtil.getShortcutsText(new Shortcut[]{(Shortcut)ArrayUtil.getLastElement((Object[])shortcut.getShortcuts())});
        }
        return null;
    }

    private void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 18) {
            return;
        }
        if (keyEvent.getID() == 401) {
            for (SettingsEditorFragment<?, ?> fragment : this.myFragments) {
                JComponent component = fragment.getComponent();
                Window window = ComponentUtil.getWindow((Component)component);
                if (window == null || !window.isFocused()) {
                    return;
                }
                if (!fragment.isSelected() || fragment.getName() == null || component.getRootPane() == null || this.myHints.contains(fragment.toString())) continue;
                JComponent hintComponent = FragmentHintManager.createHintComponent(fragment);
                Rectangle rect = component.getVisibleRect();
                if (rect.height < component.getHeight()) continue;
                RelativePoint point = new RelativePoint((Component)component, new Point(rect.x + rect.width - hintComponent.getPreferredSize().width, rect.y - hintComponent.getPreferredSize().height + 5));
                HintManager.getInstance().showHint(hintComponent, point, 2, -1);
                this.myHints.add(fragment.toString());
            }
            if (!this.myHints.isEmpty() && this.myHintsShownTime == 0L) {
                this.myHintsShownTime = System.currentTimeMillis();
            }
        } else if (keyEvent.getID() == 402 && !this.myHints.isEmpty()) {
            HintManager.getInstance().hideAllHints();
            Project project = (Project)DataManager.getInstance().getDataContext(keyEvent.getComponent()).getData(CommonDataKeys.PROJECT);
            FragmentStatisticsService.getInstance().logHintsShown(project, this.myConfigId, this.myHints.size(), System.currentTimeMillis() - this.myHintsShownTime);
            this.myHintsShownTime = 0L;
            this.myHints.clear();
        } else {
            HintManager.getInstance().hideAllHints();
            this.myHintsShownTime = 0L;
            this.myHints.clear();
        }
    }

    private static JComponent createHintComponent(SettingsEditorFragment<?, ?> fragment) {
        SimpleColoredComponent component = new SimpleColoredComponent();
        component.append(fragment.getName().replace("\u001b", ""), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        String shortcutText = FragmentHintManager.getShortcutText(fragment);
        if (shortcutText != null) {
            String last = StringUtil.last((CharSequence)shortcutText, (int)1, (boolean)false).toString();
            component.append(" " + StringUtil.trimEnd((String)shortcutText, (String)last), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            component.append(last);
        }
        return component;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintConsumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/ui/FragmentHintManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getShortcutText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

