/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.exclusion;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

abstract class TreeNodeExclusionAction<T extends TreeNode>
extends AnAction {
    private static final Logger LOG = Logger.getInstance(TreeNodeExclusionAction.class);
    private final boolean myIsExclude;

    TreeNodeExclusionAction(boolean isExclude) {
        this.myIsExclude = isExclude;
        this.getTemplatePresentation().setText(this.getActionText(false));
    }

    public void update(@NotNull AnActionEvent e) {
        JTree tree;
        Presentation presentation;
        ExclusionHandler exclusionProcessor;
        block9: {
            block8: {
                if (e == null) {
                    TreeNodeExclusionAction.$$$reportNull$$$0(0);
                }
                if ((exclusionProcessor = (ExclusionHandler)e.getData(ExclusionHandler.EXCLUSION_HANDLER)) == null) {
                    e.getPresentation().setEnabledAndVisible(false);
                    return;
                }
                Component component = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
                presentation = e.getPresentation();
                if (!(component instanceof JTree)) break block8;
                tree = (JTree)component;
                if (exclusionProcessor.isActionEnabled(this.myIsExclude)) break block9;
            }
            presentation.setEnabledAndVisible(false);
            return;
        }
        List selection = TreeCollector.TreePathRoots.collect((TreePath[])tree.getSelectionPaths());
        if (selection.isEmpty()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        boolean[] isEnabled = new boolean[]{false};
        for (TreePath path : selection) {
            TreeNode node = (TreeNode)path.getLastPathComponent();
            TreeUtil.traverse(node, n -> {
                if (!exclusionProcessor.isNodeExclusionAvailable((TreeNode)n)) {
                    return true;
                }
                boolean isNodeExcluded = exclusionProcessor.isNodeExcluded((TreeNode)n);
                if (this.myIsExclude != isNodeExcluded) {
                    isEnabled[0] = true;
                    return false;
                }
                return true;
            });
        }
        presentation.setEnabledAndVisible(isEnabled[0]);
        if (isEnabled[0]) {
            presentation.setText(this.getActionText(selection.size() > 1));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            TreeNodeExclusionAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        JTree tree;
        if (e == null) {
            TreeNodeExclusionAction.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((tree = (JTree)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)) != null);
        TreePath[] paths = tree.getSelectionPaths();
        LOG.assertTrue(paths != null);
        ExclusionHandler exclusionProcessor = (ExclusionHandler)e.getData(ExclusionHandler.EXCLUSION_HANDLER);
        LOG.assertTrue(exclusionProcessor != null);
        for (TreePath path : paths) {
            TreeNode node = (TreeNode)path.getLastPathComponent();
            TreeUtil.traverse(node, n -> {
                if (!exclusionProcessor.isNodeExclusionAvailable((TreeNode)n)) {
                    return true;
                }
                if (this.myIsExclude != exclusionProcessor.isNodeExcluded((TreeNode)n)) {
                    if (this.myIsExclude) {
                        exclusionProcessor.excludeNode(node);
                    } else {
                        exclusionProcessor.includeNode(node);
                    }
                }
                return true;
            });
        }
        exclusionProcessor.onDone(this.myIsExclude);
    }

    @NlsActions.ActionText
    private String getActionText(boolean plural) {
        if (plural) {
            return this.myIsExclude ? IdeBundle.message("action.exclude.all.text", new Object[0]) : IdeBundle.message("action.include.all.text", new Object[0]);
        }
        return this.myIsExclude ? IdeBundle.message("button.exclude", new Object[0]) : IdeBundle.message("button.include", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/exclusion/TreeNodeExclusionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/exclusion/TreeNodeExclusionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

