/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.paint.LinePainter2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public final class DrawUtil {
    private DrawUtil() {
    }

    public static void drawRoundRect(Graphics g, double x1d, double y1d, double x2d, double y2d, Color color) {
        Color oldColor = g.getColor();
        g.setColor(color);
        int x1 = (int)Math.round(x1d);
        int x2 = (int)Math.round(x2d);
        int y1 = (int)Math.round(y1d);
        int y2 = (int)Math.round(y2d);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x1 + 1), (double)y1, (double)(x2 - 1), (double)y1);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x1 + 1), (double)y2, (double)(x2 - 1), (double)y2);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x1, (double)(y1 + 1), (double)x1, (double)(y2 - 1));
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x2, (double)(y1 + 1), (double)x2, (double)(y2 - 1));
        g.setColor(oldColor);
    }

    public static void drawPlainRect(Graphics g, int x1, int y1, int x2, int y2) {
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x1, (double)y1, (double)(x2 - 1), (double)y1);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x2, (double)y1, (double)x2, (double)(y2 - 1));
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x1 + 1), (double)y2, (double)x2, (double)y2);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x1, (double)(y1 + 1), (double)x1, (double)y2);
    }

    public static boolean isSimplifiedUI() {
        return Registry.is((String)"ui.no.bangs.and.whistles", (boolean)false) || Registry.is((String)"ui.simplified", (boolean)false) || RemoteDesktopService.isRemoteSession() || PowerSaveMode.isEnabled();
    }
}

