/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.table.JBTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OrderPanel<T>
extends JPanel {
    private final JBTable myEntryTable;
    @NotNull
    private final Class<T> myEntryClass;
    @NotNull
    private final MyTableModel myModel;
    private final @NlsContexts.ColumnName @NotNull String myCheckboxColumnName;

    protected OrderPanel(@NotNull Class<T> entryClass) {
        if (entryClass == null) {
            OrderPanel.$$$reportNull$$$0(0);
        }
        this(entryClass, true, "");
    }

    protected OrderPanel(@NotNull Class<T> entryClass, boolean showCheckboxes, @NlsContexts.ColumnName @Nullable String checkboxColumnName) {
        if (entryClass == null) {
            OrderPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myEntryTable = new JBTable();
        this.myEntryClass = entryClass;
        this.myModel = new MyTableModel(showCheckboxes);
        this.myCheckboxColumnName = checkboxColumnName != null ? checkboxColumnName : UIBundle.message("order.entries.panel.export.column.name", new Object[0]);
        this.myEntryTable.setModel(this.myModel);
        this.myEntryTable.setShowGrid(false);
        this.myEntryTable.setDragEnabled(false);
        this.myEntryTable.setShowHorizontalLines(false);
        this.myEntryTable.setShowVerticalLines(false);
        this.myEntryTable.setIntercellSpacing(new Dimension(0, 0));
        this.myEntryTable.getSelectionModel().setSelectionMode(2);
        this.myEntryTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OrderPanel.this.getCheckboxColumn() == -1) {
                    return;
                }
                int[] selectedRows = OrderPanel.this.myEntryTable.getSelectedRows();
                boolean currentlyMarked = true;
                for (int selectedRow : selectedRows) {
                    if (selectedRow < 0 || !OrderPanel.this.myEntryTable.isCellEditable(selectedRow, OrderPanel.this.getCheckboxColumn())) {
                        return;
                    }
                    currentlyMarked &= ((Boolean)OrderPanel.this.myEntryTable.getValueAt(selectedRow, OrderPanel.this.getCheckboxColumn())).booleanValue();
                }
                for (int selectedRow : selectedRows) {
                    OrderPanel.this.myEntryTable.setValueAt(currentlyMarked ? Boolean.FALSE : Boolean.TRUE, selectedRow, OrderPanel.this.getCheckboxColumn());
                }
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.setCheckboxColumnWidth();
        this.add((Component)ScrollPaneFactory.createScrollPane(this.myEntryTable), "Center");
        if (this.myEntryTable.getRowCount() > 0) {
            this.myEntryTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void setCheckboxColumnWidth() {
        TableColumnModel columnModel = this.myEntryTable.getColumnModel();
        TableColumn checkboxColumn = columnModel.getColumn(this.getCheckboxColumn());
        if (this.myCheckboxColumnName.isEmpty()) {
            TableUtil.setupCheckboxColumn((TableColumn)checkboxColumn, (int)columnModel.getColumnMargin());
        } else {
            int width = this.myEntryTable.getFontMetrics(this.myEntryTable.getFont()).stringWidth(" " + this.myCheckboxColumnName + " ") + 4;
            checkboxColumn.setWidth(width);
            checkboxColumn.setPreferredWidth(width);
            checkboxColumn.setMaxWidth(width);
            checkboxColumn.setMinWidth(width);
        }
    }

    @NotNull
    protected final JTable getEntryTable() {
        JBTable jBTable = this.myEntryTable;
        if (jBTable == null) {
            OrderPanel.$$$reportNull$$$0(2);
        }
        return jBTable;
    }

    public final void clear() {
        while (this.myModel.getRowCount() > 0) {
            this.myModel.removeRow(0);
        }
    }

    public final void remove(T orderEntry) {
        int rowCount = this.myModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.myModel.getValueAt(i) != orderEntry) continue;
            this.myModel.removeRow(i);
            return;
        }
    }

    public final void add(@NotNull T orderEntry) {
        Object[] objectArray;
        if (orderEntry == null) {
            OrderPanel.$$$reportNull$$$0(3);
        }
        if (this.getCheckboxColumn() == -1) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = orderEntry;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = this.isChecked(orderEntry);
            objectArray = objectArray3;
            objectArray3[1] = orderEntry;
        }
        Object[] row = objectArray;
        this.myModel.addRow(row);
    }

    public void addAll(@NotNull Collection<? extends T> orderEntries) {
        if (orderEntries == null) {
            OrderPanel.$$$reportNull$$$0(4);
        }
        for (T orderEntry : orderEntries) {
            this.add(orderEntry);
        }
    }

    protected final int getEntryColumn() {
        return this.myModel.myEntryColumn;
    }

    protected final int getCheckboxColumn() {
        return this.myModel.myCheckboxColumn;
    }

    protected final T getValueAt(int row) {
        return this.myModel.getValueAt(row);
    }

    public boolean isCheckable(@NotNull T entry) {
        if (entry == null) {
            OrderPanel.$$$reportNull$$$0(5);
        }
        return true;
    }

    public abstract boolean isChecked(@NotNull T var1);

    public abstract void setChecked(@NotNull T var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/OrderPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/OrderPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCheckable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private class MyTableModel
    extends DefaultTableModel {
        private final int myColumnCount;
        private final int myEntryColumn;
        private final int myCheckboxColumn;

        MyTableModel(boolean showCheckboxes) {
            this.myColumnCount = showCheckboxes ? 2 : 1;
            this.myEntryColumn = this.myColumnCount - 1;
            this.myCheckboxColumn = this.myColumnCount - 2;
        }

        @Override
        @Nullable
        public String getColumnName(int column) {
            return column == this.myEntryColumn ? "" : (column == this.myCheckboxColumn ? OrderPanel.this.myCheckboxColumnName : null);
        }

        @Override
        @NotNull
        public Class<?> getColumnClass(int column) {
            Class<Object> clazz = column == this.myEntryColumn ? OrderPanel.this.myEntryClass : (column == this.myCheckboxColumn ? Boolean.class : super.getColumnClass(column));
            if (clazz == null) {
                MyTableModel.$$$reportNull$$$0(0);
            }
            return clazz;
        }

        @Override
        public int getColumnCount() {
            return this.myColumnCount;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == this.myCheckboxColumn && OrderPanel.this.isCheckable(this.getValueAt(row));
        }

        @Override
        public void setValueAt(Object value2, int row, int column) {
            super.setValueAt(value2, row, column);
            if (column == this.myCheckboxColumn) {
                OrderPanel.this.setChecked(this.getValueAt(row), (Boolean)value2);
            }
        }

        private T getValueAt(int row) {
            return this.getValueAt(row, this.myEntryColumn);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/OrderPanel$MyTableModel", "getColumnClass"));
        }
    }
}

