/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.Border;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public final class ScrollPaneFactory
implements ScrollPaneConstants {
    private ScrollPaneFactory() {
    }

    @NotNull
    public static JScrollPane createScrollPane() {
        return new JBScrollPane();
    }

    @NotNull
    public static JScrollPane createScrollPane(Component view) {
        return new JBScrollPane(view);
    }

    @NotNull
    public static JScrollPane createScrollPane(@JdkConstants.VerticalScrollBarPolicy int vsbPolicy, @JdkConstants.HorizontalScrollBarPolicy int hsbPolicy) {
        return new JBScrollPane(vsbPolicy, hsbPolicy);
    }

    @NotNull
    public static JScrollPane createScrollPane(Component view, @JdkConstants.VerticalScrollBarPolicy int vsbPolicy, @JdkConstants.HorizontalScrollBarPolicy int hsbPolicy) {
        return new JBScrollPane(view, vsbPolicy, hsbPolicy);
    }

    @NotNull
    public static JScrollPane createScrollPane(Component view, @JdkConstants.VerticalScrollBarPolicy int vsbPolicy, @JdkConstants.HorizontalScrollBarPolicy int hsbPolicy, boolean withoutBorder) {
        JBScrollPane scrollPane2 = new JBScrollPane(view, vsbPolicy, hsbPolicy);
        if (withoutBorder) {
            ScrollPaneFactory.setScrollPaneEmptyBorder(scrollPane2);
        }
        JBScrollPane jBScrollPane = scrollPane2;
        if (jBScrollPane == null) {
            ScrollPaneFactory.$$$reportNull$$$0(0);
        }
        return jBScrollPane;
    }

    @NotNull
    public static JScrollPane createScrollPane(Component view, boolean withoutBorder) {
        JBScrollPane scrollPane2 = new JBScrollPane(view);
        if (withoutBorder) {
            ScrollPaneFactory.setScrollPaneEmptyBorder(scrollPane2);
        }
        JBScrollPane jBScrollPane = scrollPane2;
        if (jBScrollPane == null) {
            ScrollPaneFactory.$$$reportNull$$$0(1);
        }
        return jBScrollPane;
    }

    @NotNull
    public static JScrollPane createScrollPane(Component view, int borders) {
        JBScrollPane scrollPane2 = new JBScrollPane(view);
        scrollPane2.setBorder(IdeBorderFactory.createBorder(borders));
        JBScrollPane jBScrollPane = scrollPane2;
        if (jBScrollPane == null) {
            ScrollPaneFactory.$$$reportNull$$$0(2);
        }
        return jBScrollPane;
    }

    private static void setScrollPaneEmptyBorder(JBScrollPane scrollPane2) {
        scrollPane2.setBorder((Border)JBUI.Borders.empty());
        scrollPane2.setViewportBorder((Border)JBUI.Borders.empty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/ScrollPaneFactory", "createScrollPane"));
    }
}

