/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListToolbarDecorator;
import com.intellij.ui.TableToolbarDecorator;
import com.intellij.ui.TreeToolbarDecorator;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.table.TableView;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolbarDecorator
implements CommonActionsPanel.ListenerFactory {
    public static final String DECORATOR_KEY = "ToolbarDecoratorMarker";
    protected Border myPanelBorder;
    protected Border myToolbarBorder;
    protected Border myScrollPaneBorder;
    protected boolean myAddActionEnabled;
    protected boolean myEditActionEnabled;
    protected boolean myRemoveActionEnabled;
    protected boolean myUpActionEnabled;
    protected boolean myDownActionEnabled;
    private final List<AnAction> myExtraActions = new SmartList();
    private ActionToolbarPosition myToolbarPosition;
    protected AnActionButtonRunnable myAddAction;
    protected AnActionButtonRunnable myEditAction;
    protected AnActionButtonRunnable myRemoveAction;
    protected AnActionButtonRunnable myUpAction;
    protected AnActionButtonRunnable myDownAction;
    @NlsContexts.Button
    private String myAddName;
    @NlsContexts.Button
    private String myEditName;
    @NlsContexts.Button
    private String myRemoveName;
    @NlsContexts.Button
    private String myMoveUpName;
    @NlsContexts.Button
    private String myMoveDownName;
    private AnActionButtonUpdater myAddActionUpdater;
    private AnActionButtonUpdater myRemoveActionUpdater;
    private AnActionButtonUpdater myEditActionUpdater;
    private AnActionButtonUpdater myMoveUpActionUpdater;
    private AnActionButtonUpdater myMoveDownActionUpdater;
    private Dimension myPreferredSize;
    private Dimension myMinimumSize;
    private CommonActionsPanel myActionsPanel;
    private Comparator<? super AnAction> myButtonComparator;
    private Icon myAddIcon;
    private boolean myForcedDnD;

    @NotNull
    protected abstract JComponent getComponent();

    protected abstract void updateButtons();

    protected void updateExtraElementActions(boolean someElementSelected) {
        for (AnAction action : this.myExtraActions) {
            if (!(action instanceof ElementActionButton)) continue;
            ElementActionButton elementActionButton = (ElementActionButton)action;
            elementActionButton.setEnabled(someElementSelected);
        }
    }

    public final CommonActionsPanel getActionsPanel() {
        return this.myActionsPanel;
    }

    @NotNull
    public ToolbarDecorator initPosition() {
        this.setToolbarPosition(SystemInfo.isMac && Registry.is((String)"action.toolbar.position.bottom.on.mac") ? ActionToolbarPosition.BOTTOM : ActionToolbarPosition.TOP);
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(0);
        }
        return toolbarDecorator;
    }

    @Deprecated
    public ToolbarDecorator setAsUsualTopToolbar() {
        return this.setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder((Border)JBUI.Borders.empty());
    }

    @NotNull
    public static ToolbarDecorator createDecorator(@NotNull JComponent component) {
        if (component == null) {
            ToolbarDecorator.$$$reportNull$$$0(1);
        }
        return ToolbarDecorator.createDecorator(component, null);
    }

    @NotNull
    public static ToolbarDecorator createDecorator(@NotNull JComponent component, @Nullable ElementProducer<?> producer) {
        ToolbarDecorator toolbarDecorator;
        if (component == null) {
            ToolbarDecorator.$$$reportNull$$$0(2);
        }
        if (component instanceof JTree) {
            return ToolbarDecorator.createDecorator((JTree)component, producer);
        }
        if (component instanceof JTable) {
            if (producer == null) {
                return ToolbarDecorator.createDecorator((JTable)component);
            }
            throw new IllegalArgumentException("unexpected producer " + String.valueOf(producer.getClass()));
        }
        if (component instanceof JList) {
            if (producer == null) {
                return ToolbarDecorator.createDecorator((JList)component);
            }
            throw new IllegalArgumentException("unexpected producer " + String.valueOf(producer.getClass()));
        }
        try {
            Class<?> type = Class.forName("com.intellij.ui.components.JBTreeTable", false, ToolbarDecorator.class.getClassLoader());
            JTree tree = (JTree)type.getDeclaredMethod("getTree", new Class[0]).invoke((Object)component, new Object[0]);
            toolbarDecorator = new TreeToolbarDecorator(component, tree, producer).initPosition();
        }
        catch (Exception | LinkageError exception) {
            throw new IllegalArgumentException("unsupported component " + String.valueOf(component.getClass()), exception);
        }
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(3);
        }
        return toolbarDecorator;
    }

    @NotNull
    public static ToolbarDecorator createDecorator(@NotNull JTable table) {
        if (table == null) {
            ToolbarDecorator.$$$reportNull$$$0(4);
        }
        ToolbarDecorator toolbarDecorator = new TableToolbarDecorator(table, null).initPosition();
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(5);
        }
        return toolbarDecorator;
    }

    @NotNull
    public static ToolbarDecorator createDecorator(@NotNull JTree tree) {
        if (tree == null) {
            ToolbarDecorator.$$$reportNull$$$0(6);
        }
        return ToolbarDecorator.createDecorator(tree, null);
    }

    @NotNull
    private static ToolbarDecorator createDecorator(@NotNull JTree tree, @Nullable ElementProducer<?> producer) {
        if (tree == null) {
            ToolbarDecorator.$$$reportNull$$$0(7);
        }
        ToolbarDecorator toolbarDecorator = new TreeToolbarDecorator(tree, producer).initPosition();
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(8);
        }
        return toolbarDecorator;
    }

    @NotNull
    public static <T> ToolbarDecorator createDecorator(@NotNull JList<T> list) {
        if (list == null) {
            ToolbarDecorator.$$$reportNull$$$0(9);
        }
        ToolbarDecorator toolbarDecorator = new ListToolbarDecorator<T>(list, null).initPosition();
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(10);
        }
        return toolbarDecorator;
    }

    @NotNull
    public static <T> ToolbarDecorator createDecorator(@NotNull JList<T> list, EditableModel editableModel) {
        if (list == null) {
            ToolbarDecorator.$$$reportNull$$$0(11);
        }
        ToolbarDecorator toolbarDecorator = new ListToolbarDecorator<T>(list, editableModel).initPosition();
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(12);
        }
        return toolbarDecorator;
    }

    @NotNull
    public static <T> ToolbarDecorator createDecorator(@NotNull TableView<T> table, @Nullable ElementProducer<T> producer) {
        if (table == null) {
            ToolbarDecorator.$$$reportNull$$$0(13);
        }
        ToolbarDecorator toolbarDecorator = new TableToolbarDecorator(table, producer).initPosition();
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(14);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator disableAddAction() {
        ToolbarDecorator toolbarDecorator = this.setAddAction(null);
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(15);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator disableRemoveAction() {
        ToolbarDecorator toolbarDecorator = this.setRemoveAction(null);
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(16);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator disableUpAction() {
        ToolbarDecorator toolbarDecorator = this.setMoveUpAction(null);
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(17);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator disableUpDownActions() {
        this.disableUpAction();
        ToolbarDecorator toolbarDecorator = this.disableDownAction();
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(18);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator disableDownAction() {
        ToolbarDecorator toolbarDecorator = this.setMoveDownAction(null);
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(19);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setPanelBorder(Border border) {
        this.myPanelBorder = border;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(20);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setToolbarBorder(Border border) {
        this.myToolbarBorder = border;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(21);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setScrollPaneBorder(Border border) {
        this.myScrollPaneBorder = border;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(22);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setButtonComparator(String ... actionNames) {
        if (actionNames == null) {
            ToolbarDecorator.$$$reportNull$$$0(23);
        }
        List<String> names = Arrays.asList(actionNames);
        this.myButtonComparator = (o1, o2) -> {
            String t1 = o1.getTemplatePresentation().getText();
            String t2 = o2.getTemplatePresentation().getText();
            if (t1 == null || t2 == null) {
                return 0;
            }
            int ind1 = names.indexOf(t1);
            int ind2 = names.indexOf(t2);
            if (ind1 == -1 && ind2 >= 0) {
                return 1;
            }
            if (ind2 == -1 && ind1 >= 0) {
                return -1;
            }
            return ind1 - ind2;
        };
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(24);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator addExtraAction(@NotNull AnAction action) {
        if (action == null) {
            ToolbarDecorator.$$$reportNull$$$0(25);
        }
        this.myExtraActions.add(action);
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(26);
        }
        return toolbarDecorator;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public ToolbarDecorator addExtraAction(@NotNull AnActionButton action) {
        if (action == null) {
            ToolbarDecorator.$$$reportNull$$$0(27);
        }
        this.myExtraActions.add(action);
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(28);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator addExtraActions(AnAction ... actions) {
        if (actions == null) {
            ToolbarDecorator.$$$reportNull$$$0(29);
        }
        for (AnAction action : actions) {
            if (action == null) continue;
            this.addExtraAction(action);
        }
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(30);
        }
        return toolbarDecorator;
    }

    @Deprecated
    @NotNull
    public ToolbarDecorator addExtraActions(AnActionButton ... actions) {
        if (actions == null) {
            ToolbarDecorator.$$$reportNull$$$0(31);
        }
        for (AnActionButton action : actions) {
            if (action == null) continue;
            this.addExtraAction(action);
        }
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(32);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setToolbarPosition(ActionToolbarPosition position) {
        this.myToolbarPosition = position;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(33);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setAddAction(AnActionButtonRunnable action) {
        this.myAddActionEnabled = action != null;
        this.myAddAction = action;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(34);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setEditAction(AnActionButtonRunnable action) {
        this.myEditActionEnabled = action != null;
        this.myEditAction = action;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(35);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setRemoveAction(AnActionButtonRunnable action) {
        this.myRemoveActionEnabled = action != null;
        this.myRemoveAction = action;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(36);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMoveUpAction(AnActionButtonRunnable action) {
        this.myUpActionEnabled = action != null;
        this.myUpAction = action;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(37);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMoveDownAction(AnActionButtonRunnable action) {
        this.myDownActionEnabled = action != null;
        this.myDownAction = action;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(38);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setAddActionName(@NlsActions.ActionText String name) {
        this.myAddName = name;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(39);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setEditActionName(@NlsActions.ActionText String name) {
        this.myEditName = name;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(40);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setRemoveActionName(@NlsActions.ActionText String name) {
        this.myRemoveName = name;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(41);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMoveUpActionName(@NlsActions.ActionText String name) {
        this.myMoveUpName = name;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(42);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMoveDownActionName(@NlsActions.ActionText String name) {
        this.myMoveDownName = name;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(43);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setAddActionUpdater(AnActionButtonUpdater updater) {
        this.myAddActionUpdater = updater;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(44);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setRemoveActionUpdater(AnActionButtonUpdater updater) {
        this.myRemoveActionUpdater = updater;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(45);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setEditActionUpdater(AnActionButtonUpdater updater) {
        this.myEditActionUpdater = updater;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(46);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMoveUpActionUpdater(AnActionButtonUpdater updater) {
        this.myMoveUpActionUpdater = updater;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(47);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMoveDownActionUpdater(AnActionButtonUpdater updater) {
        this.myMoveDownActionUpdater = updater;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(48);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setForcedDnD() {
        this.myForcedDnD = true;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(49);
        }
        return toolbarDecorator;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public ToolbarDecorator setActionGroup(@NotNull ActionGroup actionGroup) {
        AnAction[] actions;
        AnAction[] anActionArray;
        if (actionGroup == null) {
            ToolbarDecorator.$$$reportNull$$$0(50);
        }
        if (actionGroup instanceof DefaultActionGroup) {
            DefaultActionGroup o = (DefaultActionGroup)actionGroup;
            anActionArray = o.getChildren(ActionManager.getInstance());
        } else {
            anActionArray = actionGroup.getChildren(null);
        }
        for (AnAction action : actions = anActionArray) {
            if (action instanceof Separator) continue;
            this.addExtraAction(action);
        }
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(51);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setPreferredSize(Dimension size) {
        this.myPreferredSize = size;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(52);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMinimumSize(Dimension size) {
        this.myMinimumSize = size;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(53);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setVisibleRowCount(int rowCount) {
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(54);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setAddIcon(Icon addIcon) {
        this.myAddIcon = addIcon;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(55);
        }
        return toolbarDecorator;
    }

    @NotNull
    public JPanel createPanel() {
        CommonActionsPanel.Buttons[] buttons = this.getButtons();
        final JComponent contextComponent = this.getComponent();
        UIUtil.putClientProperty((JComponent)contextComponent, JBViewport.FORCE_VISIBLE_ROW_COUNT_KEY, (Object)true);
        this.myActionsPanel = new CommonActionsPanel(this, contextComponent, this.myToolbarPosition, this.myExtraActions.toArray(AnAction.EMPTY_ARRAY), this.myButtonComparator, this.myAddName, this.myRemoveName, this.myMoveUpName, this.myMoveDownName, this.myEditName, this.myAddIcon, buttons);
        JBScrollPane scrollPane2 = null;
        if (contextComponent instanceof JTree || contextComponent instanceof JTable || contextComponent instanceof JList) {
            scrollPane2 = new JBScrollPane(contextComponent){

                @Override
                public Dimension getPreferredSize() {
                    Dimension preferredSize = super.getPreferredSize();
                    Dimension preferredViewportSize = ((Scrollable)((Object)contextComponent)).getPreferredScrollableViewportSize();
                    if (!this.isPreferredSizeSet() && preferredViewportSize == null) {
                        this.setPreferredSize(new Dimension(0, preferredSize.height));
                    }
                    return preferredSize;
                }
            };
            scrollPane2.setBorder((Border)JBUI.Borders.empty());
            scrollPane2.setViewportBorder((Border)JBUI.Borders.empty());
            if (this.myPreferredSize != null) {
                scrollPane2.setPreferredSize(this.myPreferredSize);
            }
            if (this.myMinimumSize != null) {
                scrollPane2.setMinimumSize(this.myMinimumSize);
            }
        }
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                ToolbarDecorator.this.updateButtons();
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                contextComponent.setEnabled(enabled);
            }
        };
        panel2.add((Component)(scrollPane2 != null ? scrollPane2 : contextComponent), "Center");
        panel2.add((Component)this.myActionsPanel, ToolbarDecorator.getPlacement(this.myToolbarPosition));
        this.installUpdaters();
        this.updateButtons();
        this.installDnD();
        panel2.putClientProperty(DECORATOR_KEY, Boolean.TRUE);
        panel2.putClientProperty("ACTION_TOOLBAR", this.myActionsPanel.getComponent(0));
        panel2.putClientProperty((Object)DslComponentProperty.INTERACTIVE_COMPONENT, contextComponent);
        panel2.putClientProperty((Object)DslComponentProperty.VERTICAL_COMPONENT_GAP, VerticalComponentGap.BOTH);
        panel2.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, UnscaledGaps.EMPTY);
        panel2.setBorder(this.myPanelBorder != null ? this.myPanelBorder : IdeBorderFactory.createBorder(15));
        Border scrollPaneBorder = null;
        if (scrollPane2 != null && (this.myScrollPaneBorder != null || this.myPanelBorder instanceof EmptyBorder)) {
            scrollPaneBorder = this.myScrollPaneBorder != null ? this.myScrollPaneBorder : IdeBorderFactory.createBorder(15);
            scrollPane2.setBorder(scrollPaneBorder);
        }
        if ((this.myToolbarBorder == null || this.myToolbarBorder instanceof EmptyBorder) && scrollPaneBorder == null || scrollPaneBorder instanceof EmptyBorder) {
            this.myToolbarBorder = new CustomLineBorder(this.myToolbarPosition == ActionToolbarPosition.BOTTOM ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.RIGHT ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.TOP ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.LEFT ? 1 : 0);
        }
        this.myActionsPanel.setBorder(this.myToolbarBorder != null ? this.myToolbarBorder : JBUI.Borders.empty());
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ToolbarDecorator.$$$reportNull$$$0(56);
        }
        return jPanel;
    }

    private void installUpdaters() {
        this.installUpdater(this.myAddActionEnabled, this.myAddAction, this.myAddActionUpdater, CommonActionsPanel.Buttons.ADD);
        this.installUpdater(this.myEditActionEnabled, this.myEditAction, this.myEditActionUpdater, CommonActionsPanel.Buttons.EDIT);
        this.installUpdater(this.myRemoveActionEnabled, this.myRemoveAction, this.myRemoveActionUpdater, CommonActionsPanel.Buttons.REMOVE);
        this.installUpdater(this.myUpActionEnabled, this.myUpAction, this.myMoveUpActionUpdater, CommonActionsPanel.Buttons.UP);
        this.installUpdater(this.myDownActionEnabled, this.myDownAction, this.myMoveDownActionUpdater, CommonActionsPanel.Buttons.DOWN);
    }

    private void installUpdater(boolean isEnabled, @Nullable AnActionButtonRunnable anActionButtonRunnable, @Nullable AnActionButtonUpdater updater, CommonActionsPanel.Buttons button2) {
        AnActionButton anActionButton;
        if (isEnabled && anActionButtonRunnable != null && updater != null && (anActionButton = this.myActionsPanel.getAnActionButton(button2)) != null) {
            anActionButton.addCustomUpdater(updater);
        }
    }

    protected void installDnD() {
        if ((this.myForcedDnD || this.myUpAction != null && this.myUpActionEnabled && this.myDownAction != null && this.myDownActionEnabled) && !ApplicationManager.getApplication().isHeadlessEnvironment() && this.isModelEditable()) {
            this.installDnDSupport();
        }
    }

    protected abstract void installDnDSupport();

    protected abstract boolean isModelEditable();

    @NotNull
    static Object getPlacement(@NotNull ActionToolbarPosition position) {
        if (position == null) {
            ToolbarDecorator.$$$reportNull$$$0(57);
        }
        return switch (position) {
            default -> throw new MatchException(null, null);
            case ActionToolbarPosition.TOP -> "North";
            case ActionToolbarPosition.LEFT -> "West";
            case ActionToolbarPosition.BOTTOM -> "South";
            case ActionToolbarPosition.RIGHT -> "East";
        };
    }

    private CommonActionsPanel.Buttons @NotNull [] getButtons() {
        ArrayList<CommonActionsPanel.Buttons> buttons = new ArrayList<CommonActionsPanel.Buttons>();
        HashMap<CommonActionsPanel.Buttons, Pair> map = new HashMap<CommonActionsPanel.Buttons, Pair>();
        map.put(CommonActionsPanel.Buttons.ADD, Pair.create((Object)this.myAddActionEnabled, (Object)this.myAddAction));
        map.put(CommonActionsPanel.Buttons.REMOVE, Pair.create((Object)this.myRemoveActionEnabled, (Object)this.myRemoveAction));
        map.put(CommonActionsPanel.Buttons.EDIT, Pair.create((Object)this.myEditActionEnabled, (Object)this.myEditAction));
        map.put(CommonActionsPanel.Buttons.UP, Pair.create((Object)this.myUpActionEnabled, (Object)this.myUpAction));
        map.put(CommonActionsPanel.Buttons.DOWN, Pair.create((Object)this.myDownActionEnabled, (Object)this.myDownAction));
        for (CommonActionsPanel.Buttons button2 : CommonActionsPanel.Buttons.values()) {
            Pair action = (Pair)map.get((Object)button2);
            if (action == null || action.first == null || !((Boolean)action.first).booleanValue() || action.second == null) continue;
            buttons.add(button2);
        }
        CommonActionsPanel.Buttons[] buttonsArray = buttons.toArray(new CommonActionsPanel.Buttons[0]);
        if (buttonsArray == null) {
            ToolbarDecorator.$$$reportNull$$$0(58);
        }
        return buttonsArray;
    }

    @Override
    @NotNull
    public CommonActionsPanel.Listener createListener(final @NotNull CommonActionsPanel panel2) {
        if (panel2 == null) {
            ToolbarDecorator.$$$reportNull$$$0(59);
        }
        return new CommonActionsPanel.Listener(){

            @Override
            public void doAdd() {
                if (ToolbarDecorator.this.myAddAction != null) {
                    ToolbarDecorator.this.myAddAction.run((Object)panel2.getAnActionButton(CommonActionsPanel.Buttons.ADD));
                }
            }

            @Override
            public void doEdit() {
                if (ToolbarDecorator.this.myEditAction != null) {
                    ToolbarDecorator.this.myEditAction.run((Object)panel2.getAnActionButton(CommonActionsPanel.Buttons.EDIT));
                }
            }

            @Override
            public void doRemove() {
                if (ToolbarDecorator.this.myRemoveAction != null) {
                    ToolbarDecorator.this.myRemoveAction.run((Object)panel2.getAnActionButton(CommonActionsPanel.Buttons.REMOVE));
                }
            }

            @Override
            public void doUp() {
                if (ToolbarDecorator.this.myUpAction != null) {
                    ToolbarDecorator.this.myUpAction.run((Object)panel2.getAnActionButton(CommonActionsPanel.Buttons.UP));
                }
            }

            @Override
            public void doDown() {
                if (ToolbarDecorator.this.myDownAction != null) {
                    ToolbarDecorator.this.myDownAction.run((Object)panel2.getAnActionButton(CommonActionsPanel.Buttons.DOWN));
                }
            }
        };
    }

    @Nullable
    public static AnActionButton findAddButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(60);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.ADD);
    }

    @Nullable
    public static AnActionButton findEditButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(61);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.EDIT);
    }

    @Nullable
    public static AnActionButton findRemoveButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(62);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.REMOVE);
    }

    @Nullable
    public static AnActionButton findUpButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(63);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.UP);
    }

    @Nullable
    public static AnActionButton findDownButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(64);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.DOWN);
    }

    @Nullable
    private static AnActionButton findButton(JComponent comp, CommonActionsPanel.Buttons type) {
        CommonActionsPanel panel2 = (CommonActionsPanel)UIUtil.findComponentOfType((JComponent)comp, CommonActionsPanel.class);
        if (panel2 != null) {
            return panel2.getAnActionButton(type);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 6, 7, 9, 11, 13, 23, 25, 27, 29, 31, 50, 57, 59, 60, 61, 62, 63, 64 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ToolbarDecorator";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionNames";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initPosition";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 50: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ToolbarDecorator";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDecorator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "disableAddAction";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "disableRemoveAction";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "disableUpAction";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "disableUpDownActions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "disableDownAction";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "setPanelBorder";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "setToolbarBorder";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "setScrollPaneBorder";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "setButtonComparator";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "addExtraAction";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "addExtraActions";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "setToolbarPosition";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "setAddAction";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "setEditAction";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "setRemoveAction";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveUpAction";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveDownAction";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "setAddActionName";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "setEditActionName";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "setRemoveActionName";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveUpActionName";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveDownActionName";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "setAddActionUpdater";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "setRemoveActionUpdater";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "setEditActionUpdater";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveUpActionUpdater";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveDownActionUpdater";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "setForcedDnD";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "setActionGroup";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "setPreferredSize";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "setMinimumSize";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "setVisibleRowCount";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "setAddIcon";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getButtons";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDecorator";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setButtonComparator";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addExtraAction";
                break;
            }
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addExtraActions";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setActionGroup";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getPlacement";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createListener";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "findAddButton";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "findEditButton";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "findRemoveButton";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findUpButton";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "findDownButton";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 6, 7, 9, 11, 13, 23, 25, 27, 29, 31, 50, 57, 59, 60, 61, 62, 63, 64 -> new IllegalArgumentException(string);
        };
    }

    @Deprecated(forRemoval=true)
    public static abstract class ElementActionButton
    extends AnActionButton {
        public ElementActionButton(@NlsContexts.Button String text, @NlsContexts.Tooltip String description, @Nullable Icon icon) {
            super(text, description, icon);
        }

        public ElementActionButton(@NlsContexts.Button String text, Icon icon) {
            super(text, icon);
        }

        public ElementActionButton() {
        }

        public ElementActionButton(@NlsContexts.Button String text) {
            super(text);
        }
    }
}

