/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class Interpolator {
    private static final int PERIOD = 7;
    private static final long TIMEOUT = 500000000L;
    private final Supplier<Integer> myInput;
    private final Consumer<? super Integer> myOutput;
    private final Timer myTimer;
    private final Deque<Segment> mySegments;
    private boolean myProcessEvents;
    private long myPreviousEventMoment;

    public Interpolator(@NotNull Supplier<Integer> input, @NotNull Consumer<? super Integer> output) {
        if (input == null) {
            Interpolator.$$$reportNull$$$0(0);
        }
        if (output == null) {
            Interpolator.$$$reportNull$$$0(1);
        }
        this.myTimer = new Timer(7, new TimerListener());
        this.mySegments = new ArrayDeque<Segment>();
        this.myProcessEvents = true;
        this.myPreviousEventMoment = 0L;
        this.myInput = input;
        this.myOutput = output;
    }

    public void setTarget(int value2, int delay) {
        if (!this.myProcessEvents) {
            return;
        }
        if (Objects.equals(this.getTarget(), value2)) {
            return;
        }
        long moment = System.nanoTime();
        long elapsed = moment - this.myPreviousEventMoment;
        if (this.mySegments.isEmpty()) {
            this.mySegments.add(new Line(new Position(moment, this.myInput.get()), new Position(moment + (long)delay * 1000000L, value2)));
        } else {
            Segment segment = this.mySegments.getLast();
            this.mySegments.add(new Line(new Position(segment.getEnd().getMoment(), segment.getEnd().getValue()), new Position(segment.getEnd().getMoment() + elapsed, value2)));
        }
        this.myPreviousEventMoment = moment;
        if (!this.myTimer.isRunning()) {
            this.myTimer.start();
        }
    }

    public int getTarget() {
        return this.mySegments.isEmpty() ? this.myInput.get().intValue() : this.mySegments.getLast().getEnd().getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "input";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "output";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/components/Interpolator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            long moment = System.nanoTime();
            Segment segment = null;
            while (!Interpolator.this.mySegments.isEmpty()) {
                segment = Interpolator.this.mySegments.getFirst();
                if (segment.getEnd().getMoment() < moment) {
                    Interpolator.this.mySegments.removeFirst();
                    continue;
                }
                Integer v = segment.getValueAt(moment);
                if (v == null || Objects.equals(v, Interpolator.this.myInput.get())) break;
                this.setValue(v);
                break;
            }
            if (Interpolator.this.mySegments.isEmpty() && segment != null) {
                this.setValue(segment.getEnd().getValue());
            }
            if (moment > Interpolator.this.myPreviousEventMoment + 500000000L) {
                Interpolator.this.myTimer.stop();
            }
        }

        private void setValue(Integer v) {
            Interpolator.this.myProcessEvents = false;
            Interpolator.this.myOutput.accept(v);
            Interpolator.this.myProcessEvents = true;
        }
    }

    private static final class Line
    extends Segment {
        private Line(Position begin, Position end) {
            super(begin, end);
        }

        @Override
        protected Integer get(long moment) {
            int range = this.myEnd.getValue() - this.myBegin.getValue();
            long duration = this.myEnd.getMoment() - this.myBegin.getMoment();
            long elapsed = moment - this.myBegin.getMoment();
            double fraction = (double)elapsed / (double)duration;
            return (int)Math.round((double)this.myBegin.getValue() + fraction * (double)range);
        }
    }

    private static final class Position {
        private final long myMoment;
        private final int myValue;

        private Position(long moment, int value2) {
            this.myMoment = moment;
            this.myValue = value2;
        }

        long getMoment() {
            return this.myMoment;
        }

        int getValue() {
            return this.myValue;
        }
    }

    private static abstract class Segment {
        protected final Position myBegin;
        protected final Position myEnd;

        private Segment(Position begin, Position end) {
            this.myBegin = begin;
            this.myEnd = end;
        }

        Position getBegin() {
            return this.myBegin;
        }

        Position getEnd() {
            return this.myEnd;
        }

        long getDuration() {
            return this.myEnd.getMoment() - this.myBegin.getMoment();
        }

        int getDelta() {
            return this.myEnd.getValue() - this.myBegin.getValue();
        }

        Integer getValueAt(long moment) {
            return this.contains(moment) ? this.get(moment) : null;
        }

        boolean contains(long moment) {
            return this.myBegin.getMoment() <= moment && moment <= this.myEnd.getMoment();
        }

        protected abstract Integer get(long var1);
    }
}

