/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.breadcrumbs;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Crumb {
    default public Icon getIcon() {
        return null;
    }

    @Nls
    default public String getText() {
        return this.toString();
    }

    @NlsContexts.Tooltip
    @Nullable
    default public String getTooltip() {
        return null;
    }

    @NotNull
    default public List<? extends Action> getContextActions() {
        List list = Collections.emptyList();
        if (list == null) {
            Crumb.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/breadcrumbs/Crumb", "getContextActions"));
    }

    public static class Impl
    implements Crumb {
        private final Icon icon;
        @Nls
        private final String text;
        private final @NlsContexts.Tooltip String tooltip;
        @NotNull
        private final List<? extends Action> actions;

        public Impl(@NotNull BreadcrumbsProvider provider, @NotNull PsiElement element) {
            if (provider == null) {
                Impl.$$$reportNull$$$0(0);
            }
            if (element == null) {
                Impl.$$$reportNull$$$0(1);
            }
            this(provider.getElementIcon(element), provider.getElementInfo(element), provider.getElementTooltip(element), provider.getContextActions(element));
        }

        public Impl(Icon icon, @Nls String text, @NlsContexts.Tooltip String tooltip, Action ... actions) {
            this(icon, text, tooltip, actions == null || actions.length == 0 ? Collections.emptyList() : Arrays.asList(actions));
        }

        public Impl(Icon icon, @Nls String text, @NlsContexts.Tooltip String tooltip, @NotNull List<? extends Action> actions) {
            if (actions == null) {
                Impl.$$$reportNull$$$0(2);
            }
            this.icon = icon;
            this.text = text;
            this.tooltip = tooltip;
            this.actions = actions;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public String getTooltip() {
            return this.tooltip;
        }

        @Override
        @Nls
        public String getText() {
            return this.text;
        }

        @Override
        @NotNull
        public List<? extends Action> getContextActions() {
            List<? extends Action> list = this.actions;
            if (list == null) {
                Impl.$$$reportNull$$$0(3);
            }
            return list;
        }

        public String toString() {
            return this.getText();
        }

        @ApiStatus.Internal
        public static void moveEditorCaretTo(@NotNull Editor editor, int offset) {
            if (editor == null) {
                Impl.$$$reportNull$$$0(4);
            }
            if (offset >= 0) {
                editor.getCaretModel().moveToOffset(offset);
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }
        }

        @ApiStatus.Internal
        public static void select(@NotNull Editor editor, @Nullable TextRange range) {
            if (editor == null) {
                Impl.$$$reportNull$$$0(5);
            }
            if (range != null) {
                editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/components/breadcrumbs/Crumb$Impl";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/components/breadcrumbs/Crumb$Impl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContextActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "moveEditorCaretTo";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "select";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

