/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.panels;

import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class Wrapper
extends JPanel
implements NullableComponent {
    private JComponent myVerticalSizeReferent;
    private JComponent myHorizontalSizeReferent;

    public Wrapper() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
    }

    public Wrapper(@Nullable JComponent wrapped) {
        this.setLayout(new BorderLayout());
        if (wrapped != null) {
            this.add((Component)wrapped, "Center");
        }
        this.setOpaque(false);
    }

    public Wrapper(LayoutManager layout, @Nullable JComponent wrapped) {
        super(layout);
        if (wrapped != null) {
            this.add(wrapped);
        }
        this.setOpaque(false);
    }

    public Wrapper(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.setOpaque(false);
    }

    public Wrapper(LayoutManager layout) {
        super(layout);
        this.setOpaque(false);
    }

    public Wrapper(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.setOpaque(false);
    }

    public void setContent(@Nullable JComponent wrapped) {
        if (wrapped == this.getTargetComponent()) {
            return;
        }
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (wrapped != null) {
            this.add((Component)wrapped, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    public boolean isNull() {
        return this.getComponentCount() == 0;
    }

    @Override
    public void requestFocus() {
        if (this.getTargetComponent() == this) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> super.requestFocus());
            return;
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getTargetComponent(), true));
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.getTargetComponent() == this) {
            return super.requestFocusInWindow();
        }
        return this.getTargetComponent().requestFocusInWindow();
    }

    public void requestFocusInternal() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> super.requestFocus());
    }

    @Override
    public final boolean requestFocus(boolean temporary) {
        if (this.getTargetComponent() == this) {
            return super.requestFocus(temporary);
        }
        return this.getTargetComponent().requestFocus(temporary);
    }

    public JComponent getTargetComponent() {
        if (this.getComponentCount() == 1) {
            return (JComponent)this.getComponent(0);
        }
        return this;
    }

    public final Wrapper setVerticalSizeReferent(@Nullable JComponent verticalSizeReferent) {
        this.myVerticalSizeReferent = verticalSizeReferent;
        return this;
    }

    public final Wrapper setHorizontalSizeReferent(@Nullable JComponent horizontalSizeReferent) {
        this.myHorizontalSizeReferent = horizontalSizeReferent;
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.myHorizontalSizeReferent != null && this.myHorizontalSizeReferent.isShowing()) {
            size.width = Math.max(size.width, this.myHorizontalSizeReferent.getPreferredSize().width);
        }
        if (this.myVerticalSizeReferent != null && this.myVerticalSizeReferent.isShowing()) {
            size.height = Math.max(size.height, this.myVerticalSizeReferent.getPreferredSize().height);
        }
        return size;
    }

    public static final class North
    extends Wrapper {
        public North(JComponent wrapped) {
            super(new BorderLayout());
            this.add((Component)wrapped, "North");
        }
    }
}

