/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.multiRow;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.multiRow.TabsRow;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0016\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010%\u001a\u00020\nH\u0016J\b\u0010&\u001a\u00020\bH\u0016J\b\u0010'\u001a\u00020\nH\u0016J\b\u0010(\u001a\u00020\nH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0018\"\u0004\b$\u0010!\u00a8\u0006)"}, d2={"Lcom/intellij/ui/tabs/impl/multiRow/MultiRowPassInfo;", "Lcom/intellij/ui/tabs/impl/LayoutPassInfo;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "visibleInfos", "", "Lcom/intellij/ui/tabs/TabInfo;", "toFitRec", "Ljava/awt/Rectangle;", "scrollOffset", "", "<init>", "(Lcom/intellij/ui/tabs/impl/JBTabsImpl;Ljava/util/List;Ljava/awt/Rectangle;I)V", "rows", "", "Lcom/intellij/ui/tabs/impl/multiRow/TabsRow;", "getRows", "()Ljava/util/List;", "lengths", "", "getLengths", "()Ljava/util/Map;", "rowHeight", "getRowHeight", "()I", "tabsRectangle", "getTabsRectangle", "()Ljava/awt/Rectangle;", "setTabsRectangle", "(Ljava/awt/Rectangle;)V", "reqLength", "getReqLength", "setReqLength", "(I)V", "tabsLength", "getTabsLength", "setTabsLength", "getRowCount", "getHeaderRectangle", "getRequiredLength", "getScrollExtent", "intellij.platform.ide"})
public final class MultiRowPassInfo
extends LayoutPassInfo {
    @JvmField
    @NotNull
    public final JBTabsImpl tabs;
    @JvmField
    @NotNull
    public final Rectangle toFitRec;
    @JvmField
    public final int scrollOffset;
    @NotNull
    private final List<TabsRow> rows;
    @NotNull
    private final Map<TabInfo, Integer> lengths;
    @NotNull
    private Rectangle tabsRectangle;
    private int reqLength;
    private int tabsLength;

    public MultiRowPassInfo(@NotNull JBTabsImpl tabs, @NotNull List<TabInfo> visibleInfos, @NotNull Rectangle toFitRec, int scrollOffset) {
        Intrinsics.checkNotNullParameter((Object)tabs, (String)"tabs");
        Intrinsics.checkNotNullParameter(visibleInfos, (String)"visibleInfos");
        Intrinsics.checkNotNullParameter((Object)toFitRec, (String)"toFitRec");
        super(visibleInfos);
        this.tabs = tabs;
        this.toFitRec = toFitRec;
        this.scrollOffset = scrollOffset;
        this.rows = new ArrayList();
        this.lengths = new HashMap();
        this.tabsRectangle = new Rectangle();
        this.tabsLength = this.reqLength = this.toFitRec.width - this.toFitRec.x;
    }

    @NotNull
    public final List<TabsRow> getRows() {
        return this.rows;
    }

    @NotNull
    public final Map<TabInfo, Integer> getLengths() {
        return this.lengths;
    }

    public final int getRowHeight() {
        Dimension dimension = this.tabs.getHeaderFitSize();
        Intrinsics.checkNotNull((Object)dimension);
        return dimension.height;
    }

    @NotNull
    public final Rectangle getTabsRectangle() {
        return this.tabsRectangle;
    }

    public final void setTabsRectangle(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"<set-?>");
        this.tabsRectangle = rectangle;
    }

    public final int getReqLength() {
        return this.reqLength;
    }

    public final void setReqLength(int n) {
        this.reqLength = n;
    }

    public final int getTabsLength() {
        return this.tabsLength;
    }

    public final void setTabsLength(int n) {
        this.tabsLength = n;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    @NotNull
    public Rectangle getHeaderRectangle() {
        Object object = this.tabsRectangle.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Rectangle");
        return (Rectangle)object;
    }

    @Override
    public int getRequiredLength() {
        return this.reqLength;
    }

    @Override
    public int getScrollExtent() {
        return this.tabsLength;
    }
}

