/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.ShapeTransform;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayoutStrategy;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class SingleRowLayout
extends TabLayout {
    final JBTabsImpl tabs;
    public SingleRowPassInfo lastSingRowLayout;
    private final SingleRowLayoutStrategy myTop;
    private final SingleRowLayoutStrategy myLeft;
    private final SingleRowLayoutStrategy myBottom;
    private final SingleRowLayoutStrategy myRight;

    @Override
    public boolean isSideComponentOnTabs() {
        return this.getStrategy().isSideComponentOnTabs();
    }

    @Override
    public ShapeTransform createShapeTransform(Rectangle labelRec) {
        return this.getStrategy().createShapeTransform(labelRec);
    }

    @Override
    public boolean isDragOut(@NotNull TabLabel tabLabel, int deltaX, int deltaY) {
        if (tabLabel == null) {
            SingleRowLayout.$$$reportNull$$$0(0);
        }
        return this.getStrategy().isDragOut(tabLabel, deltaX, deltaY);
    }

    public SingleRowLayout(JBTabsImpl tabs) {
        this.tabs = tabs;
        this.myTop = new SingleRowLayoutStrategy.Top(this);
        this.myLeft = new SingleRowLayoutStrategy.Left(this);
        this.myBottom = new SingleRowLayoutStrategy.Bottom(this);
        this.myRight = new SingleRowLayoutStrategy.Right(this);
    }

    SingleRowLayoutStrategy getStrategy() {
        return switch (this.tabs.getPresentation().getTabsPosition()) {
            default -> throw new MatchException(null, null);
            case JBTabsPosition.top -> this.myTop;
            case JBTabsPosition.left -> this.myLeft;
            case JBTabsPosition.bottom -> this.myBottom;
            case JBTabsPosition.right -> this.myRight;
        };
    }

    protected boolean checkLayoutLabels(SingleRowPassInfo data) {
        boolean layoutLabels = true;
        if (!this.tabs.getForcedRelayout$intellij_platform_ide() && this.lastSingRowLayout != null && this.lastSingRowLayout.contentCount == this.tabs.getTabCount() && this.lastSingRowLayout.layoutSize.equals(this.tabs.getSize()) && this.lastSingRowLayout.scrollOffset == this.getScrollOffset()) {
            for (TabInfo each : data.visibleInfos) {
                TabLabel eachLabel = this.tabs.getTabLabel(each);
                if (!Objects.requireNonNull(eachLabel).isValid()) {
                    layoutLabels = true;
                    break;
                }
                if (this.tabs.getSelectedInfo() != each || eachLabel.getBounds().width == 0) continue;
                layoutLabels = false;
            }
        }
        return layoutLabels;
    }

    public LayoutPassInfo layoutSingleRow(List<TabInfo> visibleInfos) {
        SingleRowPassInfo data = new SingleRowPassInfo(this, visibleInfos);
        boolean shouldLayoutLabels = this.checkLayoutLabels(data);
        if (!shouldLayoutLabels) {
            data = this.lastSingRowLayout;
        }
        TabInfo selected2 = this.tabs.getSelectedInfo();
        this.prepareLayoutPassInfo(data, selected2);
        this.tabs.resetLayout(shouldLayoutLabels || this.tabs.isHideTabs());
        if (shouldLayoutLabels && !this.tabs.isHideTabs()) {
            this.recomputeToLayout(data);
            data.position = this.getStrategy().getStartPosition(data) - this.getScrollOffset();
            this.layoutTitle(data);
            if (ExperimentalUI.isNewUI() && this.tabs.getTabsPosition().isSide()) {
                this.layoutEntryPointButton(data);
                this.layoutMoreButton(data);
                this.layoutLabels(data);
            } else {
                this.layoutLabels(data);
                this.layoutEntryPointButton(data);
                this.layoutMoreButton(data);
            }
        }
        if (selected2 != null) {
            data.component = new WeakReference<JComponent>(selected2.getComponent());
            this.getStrategy().layoutComp(data);
        }
        data.tabRectangle = new Rectangle();
        if (!data.toLayout.isEmpty()) {
            TabLabel firstLabel = this.tabs.getTabLabel(data.toLayout.get(0));
            TabLabel lastLabel = this.findLastVisibleLabel(data);
            if (firstLabel != null && lastLabel != null) {
                data.tabRectangle.x = firstLabel.getBounds().x;
                data.tabRectangle.y = firstLabel.getBounds().y;
                data.tabRectangle.width = ExperimentalUI.isNewUI() ? (int)data.entryPointRect.getMaxX() + this.tabs.getActionsInsets().right - data.tabRectangle.x : (int)lastLabel.getBounds().getMaxX() - data.tabRectangle.x;
                data.tabRectangle.height = (int)lastLabel.getBounds().getMaxY() - data.tabRectangle.y;
            }
        }
        this.lastSingRowLayout = data;
        return data;
    }

    @Nullable
    protected TabLabel findLastVisibleLabel(SingleRowPassInfo data) {
        return this.tabs.getTabLabel(data.toLayout.get(data.toLayout.size() - 1));
    }

    protected void prepareLayoutPassInfo(SingleRowPassInfo data, TabInfo selected2) {
        JBTabsImpl.Toolbar selectedForeToolbar;
        data.insets = this.tabs.getLayoutInsets();
        if (this.tabs.isHorizontalTabs()) {
            data.insets.left += this.tabs.getFirstTabOffset();
        }
        data.hfToolbar = new WeakReference<Object>(((selectedForeToolbar = this.tabs.infoToForeToolbar.get(selected2)) != null && this.tabs.getHorizontalSide() && !selectedForeToolbar.isEmpty() ? selectedForeToolbar : null));
        JBTabsImpl.Toolbar selectedToolbar = this.tabs.getInfoToToolbar().get(selected2);
        data.hToolbar = new WeakReference<Object>((selectedToolbar != null && this.tabs.getHorizontalSide() && !selectedToolbar.isEmpty() ? selectedToolbar : null));
        data.vToolbar = new WeakReference<Object>((selectedToolbar != null && !this.tabs.getHorizontalSide() && !selectedToolbar.isEmpty() ? selectedToolbar : null));
        data.toFitLength = this.getStrategy().getToFitLength(data);
    }

    protected void layoutTitle(SingleRowPassInfo data) {
        data.titleRect = this.getStrategy().getTitleRect(data);
        data.position = data.position + (this.tabs.isHorizontalTabs() ? data.titleRect.width : data.titleRect.height);
    }

    protected void layoutMoreButton(SingleRowPassInfo data) {
        if (!data.toDrop.isEmpty()) {
            data.moreRect = this.getStrategy().getMoreRect(data);
        }
    }

    protected void layoutEntryPointButton(SingleRowPassInfo data) {
        data.entryPointRect = this.getStrategy().getEntryPointRect(data);
    }

    protected void layoutLabels(SingleRowPassInfo data) {
        boolean layoutStopped = false;
        for (TabInfo eachInfo : data.toLayout) {
            TabLabel label2 = this.tabs.getTabLabel(eachInfo);
            if (layoutStopped) {
                Rectangle rec = this.getStrategy().getLayoutRect(data, 0, 0);
                this.tabs.layout(Objects.requireNonNull(label2), rec);
                continue;
            }
            Dimension eachSize = Objects.requireNonNull(label2).getPreferredSize();
            int length = this.getStrategy().getLengthIncrement(eachSize);
            boolean continueLayout = this.applyTabLayout(data, label2, length);
            data.position = this.getStrategy().getMaxPosition(label2.getBounds());
            data.position += this.tabs.getTabHGap();
            if (continueLayout) continue;
            layoutStopped = true;
        }
        for (TabInfo eachInfo : data.toDrop) {
            JBTabsImpl.Companion.resetLayout(this.tabs.getTabLabel(eachInfo));
        }
    }

    protected boolean applyTabLayout(SingleRowPassInfo data, TabLabel label2, int length) {
        int startPosition;
        TabLabel.TabLabelLayout layout = (TabLabel.TabLabelLayout)ObjectUtils.tryCast((Object)label2.getLayout(), TabLabel.TabLabelLayout.class);
        if (layout != null) {
            layout.setRightAlignment(false);
        }
        Rectangle rec = this.getStrategy().getLayoutRect(data, data.position, length);
        if (data.hfToolbar.get() != null && rec.x < (startPosition = this.getStrategy().getStartPosition(data))) {
            rec.width -= startPosition - rec.x;
            rec.x = startPosition;
            if (layout != null) {
                layout.setRightAlignment(true);
            }
        }
        this.tabs.layout(label2, rec);
        label2.setAlignmentToCenter(this.tabs.isEditorTabs() && this.getStrategy().isToCenterTextWhenStretched());
        return true;
    }

    protected abstract void recomputeToLayout(SingleRowPassInfo var1);

    protected void calculateRequiredLength(SingleRowPassInfo data) {
        data.requiredLength = data.requiredLength + (this.tabs.isHorizontalTabs() ? data.insets.left + data.insets.right : data.insets.top + data.insets.bottom);
        for (TabInfo eachInfo : data.visibleInfos) {
            data.requiredLength += this.getRequiredLength(eachInfo);
            data.toLayout.add(eachInfo);
        }
        data.requiredLength += this.getStrategy().getAdditionalLength(data);
    }

    protected int getRequiredLength(TabInfo eachInfo) {
        TabLabel label2 = this.tabs.getTabLabel(eachInfo);
        return this.getStrategy().getLengthIncrement(label2 != null ? label2.getPreferredSize() : new Dimension()) + (this.tabs.isEditorTabs() ? this.tabs.getTabHGap() : 0);
    }

    @Override
    public boolean isTabHidden(@NotNull TabInfo info) {
        if (info == null) {
            SingleRowLayout.$$$reportNull$$$0(1);
        }
        return this.lastSingRowLayout != null && this.lastSingRowLayout.toDrop.contains(info);
    }

    @Override
    public int getDropIndexFor(@NotNull Point point) {
        if (point == null) {
            SingleRowLayout.$$$reportNull$$$0(2);
        }
        if (this.lastSingRowLayout == null) {
            return -1;
        }
        int result2 = -1;
        Point adjustedPoint = this.getStrategy().adjustDropPoint(point);
        Component c = this.tabs.getComponentAt(adjustedPoint);
        if (c instanceof JBTabsImpl) {
            for (int i = 0; i < this.lastSingRowLayout.visibleInfos.size() - 1; ++i) {
                boolean between;
                TabLabel first = this.tabs.getTabLabel((TabInfo)this.lastSingRowLayout.visibleInfos.get(i));
                TabLabel second = this.tabs.getTabLabel((TabInfo)this.lastSingRowLayout.visibleInfos.get(i + 1));
                Rectangle firstBounds = Objects.requireNonNull(first).getBounds();
                Rectangle secondBounds = Objects.requireNonNull(second).getBounds();
                boolean horizontal = this.getStrategy() instanceof SingleRowLayoutStrategy.Horizontal;
                if (horizontal) {
                    between = firstBounds.getMaxX() < (double)adjustedPoint.x && secondBounds.getX() > (double)adjustedPoint.x && firstBounds.y < adjustedPoint.y && secondBounds.getMaxY() > (double)adjustedPoint.y;
                } else {
                    boolean bl = between = firstBounds.getMaxY() < (double)adjustedPoint.y && secondBounds.getY() > (double)adjustedPoint.y && firstBounds.x < adjustedPoint.x && secondBounds.getMaxX() > (double)adjustedPoint.x;
                }
                if (!between) continue;
                c = first;
                break;
            }
        }
        if (c instanceof TabLabel) {
            TabInfo info = ((TabLabel)c).getInfo();
            int index = this.lastSingRowLayout.visibleInfos.indexOf(info);
            boolean isDropTarget = this.tabs.isDropTarget(info);
            if (!isDropTarget) {
                for (int i = 0; i <= index; ++i) {
                    if (!this.tabs.isDropTarget((TabInfo)this.lastSingRowLayout.visibleInfos.get(i))) continue;
                    --index;
                    break;
                }
                result2 = index;
            } else if (index < this.lastSingRowLayout.visibleInfos.size()) {
                result2 = index;
            }
        }
        return result2;
    }

    @Override
    public int getDropSideFor(@NotNull Point point) {
        if (point == null) {
            SingleRowLayout.$$$reportNull$$$0(3);
        }
        return TabsUtil.getDropSideFor(point, this.tabs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabLabel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tabs/impl/singleRow/SingleRowLayout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDragOut";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isTabHidden";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDropIndexFor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDropSideFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

