/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.treetable;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.treeStructure.TreeBulkExpansionEvent;
import com.intellij.ui.treeStructure.TreeBulkExpansionListener;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class TreeTableModelAdapter
extends AbstractTableModel {
    private final AtomicInteger modificationStamp = new AtomicInteger();
    private final JTree tree;
    private final TreeTableModel treeTableModel;
    private final JTable table;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree, JTable table) {
        this.tree = tree;
        this.treeTableModel = treeTableModel;
        this.table = table;
        this.treeTableModel.setTree(tree);
        tree.addTreeExpansionListener(new TreeBulkExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (!1.isBulkOperationInProgress(event)) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                if (!1.isBulkOperationInProgress(event)) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            }

            private static boolean isBulkOperationInProgress(TreeExpansionEvent event) {
                TreeBulkExpansionEvent bulkEvent;
                return event instanceof TreeBulkExpansionEvent && (bulkEvent = (TreeBulkExpansionEvent)event).isBulkOperationInProgress();
            }

            @Override
            public void treeBulkExpansionEnded(@NotNull TreeBulkExpansionEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            @Override
            public void treeBulkCollapseEnded(@NotNull TreeBulkExpansionEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/ui/treeStructure/treetable/TreeTableModelAdapter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "treeBulkExpansionEnded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "treeBulkCollapseEnded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        return treePath == null ? null : treePath.getLastPathComponent();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object o = this.nodeForRow(row);
        return o == null ? null : this.treeTableModel.getValueAt(o, column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        Object o = this.nodeForRow(row);
        return o != null && this.treeTableModel.isCellEditable(o, column);
    }

    @Override
    public void setValueAt(Object value2, int row, int column) {
        Object o = this.nodeForRow(row);
        if (o != null) {
            this.treeTableModel.setValueAt(value2, o, column);
        }
    }

    protected void delayedFireTableDataChanged() {
        long stamp = this.modificationStamp.incrementAndGet();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (stamp == (long)this.modificationStamp.get()) {
                this.fireTableDataChanged();
            }
        });
    }

    @Override
    public void fireTableDataChanged() {
        TreePath[] treePaths = this.tree.getSelectionPaths();
        super.fireTableDataChanged();
        if (treePaths != null) {
            for (TreePath treePath : treePaths) {
                int row = this.tree.getRowForPath(treePath);
                this.table.getSelectionModel().addSelectionInterval(row, row);
            }
        }
    }
}

