/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.util.animation.CubicBezierEasing;

@FunctionalInterface
public interface Easing {
    public static final Easing EASE = Easing.bezier(0.25, 0.1, 0.25, 1.0);
    public static final Easing LINEAR = n -> n;
    public static final Easing EASE_IN = Easing.bezier(0.42, 0.0, 1.0, 1.0);
    public static final Easing EASE_OUT = Easing.bezier(0.0, 0.0, 0.58, 1.0);
    public static final Easing EASE_IN_OUT = Easing.bezier(0.42, 0.0, 0.58, 1.0);

    public double calc(double var1);

    public static Easing bezier(double c1x, double c1y, double c2x, double c2y) {
        return new CubicBezierEasing(c1x, c1y, c2x, c2y);
    }

    default public Easing convert(double t, double b, double c, double d) {
        return x -> c * this.calc(t / d) + b;
    }

    default public Easing reverse() {
        return x -> this.calc(1.0 - x);
    }

    default public Easing invert() {
        return x -> 1.0 - this.calc(1.0 - x);
    }

    default public Easing mirror() {
        return x -> this.calc(x < 0.5 ? x * 2.0 : 1.0 - (x - 0.5) * 2.0);
    }

    default public Easing freeze(double before, double after) {
        return x -> {
            if (x < before) {
                return 0.0;
            }
            if (x > after) {
                return 1.0;
            }
            return this.calc((x - before) / (after - before));
        };
    }

    default public Easing coerceIn(double start2, double end) {
        return x -> this.calc(x * (end - start2) + start2);
    }

    default public Stateful stateful() {
        return new Stateful(this);
    }

    public static final class Stateful
    implements Easing {
        private final Easing delegate;
        public double value;

        private Stateful(Easing delegate) {
            this.delegate = delegate;
        }

        @Override
        public double calc(double x) {
            this.value = x;
            return this.delegate.calc(this.value);
        }
    }
}

