/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.animation.JBAnimator;
import com.sun.jna.Native;
import com.sun.jna.win32.StdCallLibrary;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JBAnimatorHelper {
    private static final String PROPERTY_NAME = "WIN_MM_LIB_HIGH_PRECISION_TIMER";
    private static final boolean DEFAULT_VALUE = ApplicationManager.getApplication().isInternal() && SystemInfoRt.isWindows;
    private static final int PERIOD = 1;
    @NotNull
    private final Set<JBAnimator> requestors = ConcurrentHashMap.newKeySet();
    @NotNull
    private final WinMM lib;
    @Nullable
    private static Throwable exceptionInInitialization = null;

    private static JBAnimatorHelper getInstance() {
        return JBAnimatorHelperHolder.INSTANCE;
    }

    @ApiStatus.Experimental
    public static void requestHighPrecisionTimer(@NotNull JBAnimator requestor) {
        if (requestor == null) {
            JBAnimatorHelper.$$$reportNull$$$0(0);
        }
        if (JBAnimatorHelper.isAvailable()) {
            JBAnimatorHelper helper = JBAnimatorHelper.getInstance();
            if (helper.requestors.add(requestor)) {
                helper.lib.timeBeginPeriod(1);
            }
        }
    }

    @ApiStatus.Experimental
    public static void cancelHighPrecisionTimer(@NotNull JBAnimator requestor) {
        if (requestor == null) {
            JBAnimatorHelper.$$$reportNull$$$0(1);
        }
        if (JBAnimatorHelper.isAvailable()) {
            JBAnimatorHelper helper = JBAnimatorHelper.getInstance();
            if (helper.requestors.remove(requestor)) {
                helper.lib.timeEndPeriod(1);
            }
        }
    }

    public static boolean isAvailable() {
        if (!SystemInfoRt.isWindows || exceptionInInitialization != null) {
            return false;
        }
        return PropertiesComponent.getInstance().getBoolean(PROPERTY_NAME, DEFAULT_VALUE);
    }

    public static void setAvailable(boolean value2) {
        if (exceptionInInitialization != null) {
            Logger.getInstance(JBAnimatorHelper.class).error(exceptionInInitialization);
        }
        if (!SystemInfoRt.isWindows) {
            throw new IllegalArgumentException("This option can be set only on Windows");
        }
        PropertiesComponent.getInstance().setValue(PROPERTY_NAME, value2, DEFAULT_VALUE);
        JBAnimatorHelper helper = JBAnimatorHelper.getInstance();
        if (!helper.requestors.isEmpty()) {
            helper.requestors.clear();
            helper.lib.timeEndPeriod(1);
        }
    }

    private JBAnimatorHelper() {
        WinMM library = null;
        try {
            if (SystemInfoRt.isWindows) {
                library = (WinMM)Native.load((String)"winmm", WinMM.class);
            }
        }
        catch (Throwable t) {
            exceptionInInitialization = new RuntimeException("Cannot load 'winmm.dll' library", t instanceof UnsatisfiedLinkError ? null : t);
        }
        this.lib = library != null ? library : new WinMM(this){

            @Override
            public int timeBeginPeriod(int period) {
                return 0;
            }

            @Override
            public int timeEndPeriod(int period) {
                return 0;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "requestor";
        objectArray2[1] = "com/intellij/util/animation/JBAnimatorHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "requestHighPrecisionTimer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelHighPrecisionTimer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JBAnimatorHelperHolder {
        private static final JBAnimatorHelper INSTANCE = new JBAnimatorHelper();

        private JBAnimatorHelperHolder() {
        }
    }

    private static interface WinMM
    extends StdCallLibrary {
        public int timeBeginPeriod(int var1);

        public int timeEndPeriod(int var1);
    }
}

