/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.internal;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.util.net.DisabledProxyAuthPromptsManager;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.ProxyConfiguration;
import com.intellij.util.net.ProxyCredentialStore;
import com.intellij.util.net.ProxySettings;
import com.intellij.util.net.internal.HttpConfigurableToCredentialStoreAdapter;
import com.intellij.util.net.internal.HttpConfigurableToDisabledPromptsManager;
import com.intellij.util.net.internal.HttpConfigurableToProxySettingsAdapter;
import com.intellij.util.text.StringKt;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0001\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u0002\u001a\u0014\u0010\b\u001a\u00020\u0004*\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u000b\u001a\u0010\u0010\f\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00020\u000e\u001a\u0010\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00020\u000e\u001a\u0010\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00020\u000e\u00a8\u0006\u0013"}, d2={"getProxyConfiguration", "Lcom/intellij/util/net/ProxyConfiguration;", "Lcom/intellij/util/net/HttpConfigurable;", "setFromProxyConfiguration", "", "proxyConf", "getCredentials", "Lcom/intellij/credentialStore/Credentials;", "setCredentials", "credentials", "toCredentials", "Ljava/net/PasswordAuthentication;", "asProxySettings", "Lcom/intellij/util/net/ProxySettings;", "Lkotlin/Function0;", "asProxyCredentialStore", "Lcom/intellij/util/net/ProxyCredentialStore;", "asDisabledProxyAuthPromptsManager", "Lcom/intellij/util/net/DisabledProxyAuthPromptsManager;", "intellij.platform.ide"})
@ApiStatus.Internal
public final class HttpConfigurableMigrationUtilsKt {
    @NotNull
    public static final ProxyConfiguration getProxyConfiguration(@NotNull HttpConfigurable $this$getProxyConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$getProxyConfiguration, (String)"<this>");
        try {
            Object object;
            if ($this$getProxyConfiguration.USE_PROXY_PAC) {
                Object object2;
                String pacUrl = $this$getProxyConfiguration.PAC_URL;
                if ($this$getProxyConfiguration.USE_PAC_URL && !((object2 = (CharSequence)pacUrl) == null || object2.length() == 0)) {
                    try {
                        object2 = ProxyConfiguration.Companion.proxyAutoConfiguration(new URL(pacUrl));
                    }
                    catch (MalformedURLException malformedURLException) {
                        object2 = ProxyConfiguration.Companion.getAutodetect();
                    }
                    object = object2;
                } else {
                    object = ProxyConfiguration.Companion.getAutodetect();
                }
            } else if ($this$getProxyConfiguration.USE_HTTP_PROXY) {
                ProxyConfiguration.ProxyProtocol proxyProtocol = $this$getProxyConfiguration.PROXY_TYPE_IS_SOCKS ? ProxyConfiguration.ProxyProtocol.SOCKS : ProxyConfiguration.ProxyProtocol.HTTP;
                String string = $this$getProxyConfiguration.PROXY_HOST;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PROXY_HOST");
                int n = $this$getProxyConfiguration.PROXY_PORT;
                String string2 = $this$getProxyConfiguration.PROXY_EXCEPTIONS;
                if (string2 == null) {
                    string2 = "";
                }
                object = ProxyConfiguration.Companion.proxy(proxyProtocol, string, n, string2);
            } else {
                object = ProxyConfiguration.Companion.getDirect();
            }
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ProxySettings.Companion.getDefaultProxyConfiguration();
        }
    }

    public static final void setFromProxyConfiguration(@NotNull HttpConfigurable $this$setFromProxyConfiguration, @NotNull ProxyConfiguration proxyConf) {
        Intrinsics.checkNotNullParameter((Object)$this$setFromProxyConfiguration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)proxyConf, (String)"proxyConf");
        ProxyConfiguration proxyConfiguration = proxyConf;
        if (proxyConfiguration instanceof ProxyConfiguration.DirectProxy) {
            $this$setFromProxyConfiguration.USE_HTTP_PROXY = false;
            $this$setFromProxyConfiguration.USE_PROXY_PAC = false;
        } else if (proxyConfiguration instanceof ProxyConfiguration.AutoDetectProxy) {
            $this$setFromProxyConfiguration.USE_HTTP_PROXY = false;
            $this$setFromProxyConfiguration.USE_PROXY_PAC = true;
            $this$setFromProxyConfiguration.USE_PAC_URL = false;
            $this$setFromProxyConfiguration.PAC_URL = null;
        } else if (proxyConfiguration instanceof ProxyConfiguration.ProxyAutoConfiguration) {
            $this$setFromProxyConfiguration.USE_HTTP_PROXY = false;
            $this$setFromProxyConfiguration.USE_PROXY_PAC = true;
            $this$setFromProxyConfiguration.USE_PAC_URL = true;
            $this$setFromProxyConfiguration.PAC_URL = ((ProxyConfiguration.ProxyAutoConfiguration)proxyConf).getPacUrl().toString();
        } else if (proxyConfiguration instanceof ProxyConfiguration.StaticProxyConfiguration) {
            $this$setFromProxyConfiguration.USE_PROXY_PAC = false;
            $this$setFromProxyConfiguration.USE_HTTP_PROXY = true;
            $this$setFromProxyConfiguration.PROXY_TYPE_IS_SOCKS = ((ProxyConfiguration.StaticProxyConfiguration)proxyConf).getProtocol() == ProxyConfiguration.ProxyProtocol.SOCKS;
            $this$setFromProxyConfiguration.PROXY_HOST = ((ProxyConfiguration.StaticProxyConfiguration)proxyConf).getHost();
            $this$setFromProxyConfiguration.PROXY_PORT = ((ProxyConfiguration.StaticProxyConfiguration)proxyConf).getPort();
            $this$setFromProxyConfiguration.PROXY_EXCEPTIONS = ((ProxyConfiguration.StaticProxyConfiguration)proxyConf).getExceptions();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Nullable
    public static final Credentials getCredentials(@NotNull HttpConfigurable $this$getCredentials) {
        char[] cArray;
        String password;
        Intrinsics.checkNotNullParameter((Object)$this$getCredentials, (String)"<this>");
        if (!$this$getCredentials.PROXY_AUTHENTICATION) {
            return null;
        }
        String login = $this$getCredentials.getProxyLogin();
        CharSequence charSequence = login;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        String string = $this$getCredentials.getPlainProxyPassword();
        String string2 = password = string != null ? StringKt.nullize$default((String)string, (boolean)false, (int)1, null) : null;
        if (string2 != null) {
            char[] cArray2 = string2.toCharArray();
            cArray = cArray2;
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
        } else {
            cArray = null;
        }
        return new Credentials(login, cArray);
    }

    public static final void setCredentials(@NotNull HttpConfigurable $this$setCredentials, @Nullable Credentials credentials) {
        Intrinsics.checkNotNullParameter((Object)$this$setCredentials, (String)"<this>");
        if (credentials == null) {
            $this$setCredentials.PROXY_AUTHENTICATION = false;
            $this$setCredentials.setProxyLogin(null);
            $this$setCredentials.setPlainProxyPassword(null);
        } else {
            $this$setCredentials.PROXY_AUTHENTICATION = true;
            $this$setCredentials.setProxyLogin(credentials.getUserName());
            OneTimeString oneTimeString = credentials.getPassword();
            $this$setCredentials.setPlainProxyPassword(oneTimeString != null ? oneTimeString.toString() : null);
        }
    }

    @NotNull
    public static final Credentials toCredentials(@NotNull PasswordAuthentication $this$toCredentials) {
        Intrinsics.checkNotNullParameter((Object)$this$toCredentials, (String)"<this>");
        return new Credentials($this$toCredentials.getUserName(), $this$toCredentials.getPassword());
    }

    @NotNull
    public static final ProxySettings asProxySettings(@NotNull Function0<? extends HttpConfigurable> $this$asProxySettings) {
        Intrinsics.checkNotNullParameter($this$asProxySettings, (String)"<this>");
        return new HttpConfigurableToProxySettingsAdapter($this$asProxySettings);
    }

    @NotNull
    public static final ProxyCredentialStore asProxyCredentialStore(@NotNull Function0<? extends HttpConfigurable> $this$asProxyCredentialStore) {
        Intrinsics.checkNotNullParameter($this$asProxyCredentialStore, (String)"<this>");
        return new HttpConfigurableToCredentialStoreAdapter($this$asProxyCredentialStore);
    }

    @NotNull
    public static final DisabledProxyAuthPromptsManager asDisabledProxyAuthPromptsManager(@NotNull Function0<? extends HttpConfigurable> $this$asDisabledProxyAuthPromptsManager) {
        Intrinsics.checkNotNullParameter($this$asDisabledProxyAuthPromptsManager, (String)"<this>");
        return new HttpConfigurableToDisabledPromptsManager($this$asDisabledProxyAuthPromptsManager);
    }
}

