/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DigestUtilKt;
import com.intellij.util.net.ssl.CertificateListener;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.CertificateProvider;
import com.intellij.util.net.ssl.CertificateUtil;
import com.intellij.util.net.ssl.CertificateWarningDialogProvider;
import com.intellij.util.net.ssl.ClientOnlyTrustManager;
import com.intellij.util.net.ssl.InitialUntrustedCertificateStrategyProvider;
import com.intellij.util.net.ssl.OsCertificatesService;
import com.intellij.util.net.ssl.UntrustedCertificateStrategy;
import com.intellij.util.net.ssl.UntrustedCertificateStrategyWithReason;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class ConfirmingTrustManager
extends ClientOnlyTrustManager {
    private static final Logger LOG = Logger.getInstance(ConfirmingTrustManager.class);
    private static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    public final ThreadLocal<@Nullable UntrustedCertificateStrategy> myUntrustedCertificateStrategy = ThreadLocal.withInitial(() -> null);
    private final Set<X509Certificate> myRejectedCertificates = ConcurrentCollectionFactory.createConcurrentSet();
    private final List<X509TrustManager> mySystemManagers;
    private final MutableTrustManager myCustomManager;

    public static ConfirmingTrustManager createForStorage(@NotNull String path, @NotNull String password) {
        if (path == null) {
            ConfirmingTrustManager.$$$reportNull$$$0(0);
        }
        if (password == null) {
            ConfirmingTrustManager.$$$reportNull$$$0(1);
        }
        return new ConfirmingTrustManager(ConfirmingTrustManager.getSystemTrustManagers(), new MutableTrustManager(path, password));
    }

    @NotNull
    private static List<X509TrustManager> getSystemTrustManagers() {
        X509TrustManager javaRuntimeManager;
        ArrayList<X509TrustManager> result2 = new ArrayList<X509TrustManager>();
        X509TrustManager osManager = ConfirmingTrustManager.getOperatingSystemTrustManager();
        if (osManager != null) {
            result2.add(osManager);
        }
        if ((javaRuntimeManager = ConfirmingTrustManager.getJavaRuntimeDefaultTrustManager()) != null) {
            result2.add(javaRuntimeManager);
        }
        ArrayList<X509TrustManager> arrayList = result2;
        if (arrayList == null) {
            ConfirmingTrustManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    private static X509TrustManager getJavaRuntimeDefaultTrustManager() {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init((KeyStore)null);
            X509TrustManager systemManager = ConfirmingTrustManager.findX509TrustManager(factory.getTrustManagers());
            if (systemManager != null && systemManager.getAcceptedIssuers().length != 0) {
                return systemManager;
            }
        }
        catch (Exception e) {
            LOG.error("Cannot get default JVM trust store", (Throwable)e);
        }
        return null;
    }

    @Nullable
    private static X509TrustManager getOperatingSystemTrustManager() {
        try {
            Collection<X509Certificate> additionalTrustedCertificates = OsCertificatesService.getInstance().getCustomOsSpecificTrustedCertificates();
            if (additionalTrustedCertificates.isEmpty()) {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.warn("Received an empty list of custom trusted root certificates from the system. Check log above for possible errors, enable debug logging in category 'org.jetbrains.nativecerts' for more information");
                }
                return null;
            }
            X509TrustManager x509TrustManager = ConfirmingTrustManager.createTrustManagerFromCertificates(additionalTrustedCertificates);
            List<String> acceptedRoots = Arrays.stream(x509TrustManager.getAcceptedIssuers()).map(certificate -> certificate.getSubjectX500Principal().toString()).sorted().toList();
            LOG.debug("Accepted trusted certificate roots from the system: \n" + StringUtil.join(acceptedRoots, (String)"\n"));
            return x509TrustManager;
        }
        catch (Throwable exception) {
            LOG.error("Unable to build system trusted certificates manager, only JVM-bundled roots will be used: " + exception.getMessage(), exception);
            return null;
        }
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public static X509TrustManager createTrustManagerFromCertificates(@NotNull Collection<? extends X509Certificate> certificates) throws Exception {
        if (certificates == null) {
            ConfirmingTrustManager.$$$reportNull$$$0(3);
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        for (X509Certificate x509Certificate : certificates) {
            ks.setCertificateEntry(x509Certificate.getSubjectX500Principal().toString() + "-" + DigestUtilKt.hashToHexString((byte[])x509Certificate.getEncoded(), (MessageDigest)DigestUtilKt.sha3_256()), x509Certificate);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        List list = ContainerUtil.filterIsInstance((Object[])tmf.getTrustManagers(), X509TrustManager.class);
        if (list.isEmpty()) {
            throw new IllegalStateException("Unable to create X509TrustManager from keystore: no X509TrustManager instances returned, only " + Strings.join(Arrays.asList(tmf.getTrustManagers()), (String)" "));
        }
        if (list.size() > 1) {
            throw new IllegalStateException("Unable to create X509TrustManager from keystore: more than one X509TrustManager instance returned: " + Strings.join((Iterable)list, (String)" "));
        }
        X509TrustManager x509TrustManager = (X509TrustManager)list.get(0);
        if (x509TrustManager == null) {
            ConfirmingTrustManager.$$$reportNull$$$0(4);
        }
        return x509TrustManager;
    }

    private ConfirmingTrustManager(List<X509TrustManager> system, MutableTrustManager custom) {
        this.mySystemManagers = system;
        this.myCustomManager = custom;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public void addSystemTrustManager(X509TrustManager manager) {
        this.mySystemManagers.add(manager);
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public void removeSystemTrustManager(X509TrustManager manager) {
        if (!this.mySystemManagers.remove(manager)) {
            throw new IllegalArgumentException("trust manager was not in the list of system trust managers: " + String.valueOf(manager));
        }
    }

    @Nullable
    private static X509TrustManager findX509TrustManager(TrustManager[] managers) {
        for (TrustManager manager : managers) {
            if (!(manager instanceof X509TrustManager)) continue;
            return (X509TrustManager)manager;
        }
        return null;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkServerTrusted(chain, authType, (String)null);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        Object remoteHost;
        SocketAddress sa = socket.getRemoteSocketAddress();
        if (sa instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)sa;
            remoteHost = isa.getHostString() + ":" + isa.getPort();
        } else {
            remoteHost = sa.toString();
        }
        this.checkServerTrusted(chain, authType, (String)remoteHost);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        Object remoteHost = engine.getPeerHost();
        int peerPort = engine.getPeerPort();
        if (peerPort > 0) {
            remoteHost = (String)remoteHost + ":" + peerPort;
        }
        this.checkServerTrusted(chain, authType, (String)remoteHost);
    }

    private void checkServerTrusted(X509Certificate[] chain, String authType, String remoteHost) throws CertificateException {
        this.withCalculatedCertificateStrategy((ThrowableConsumer<? super UntrustedCertificateStrategyWithReason, ? extends CertificateException>)((ThrowableConsumer)strategyWithReason -> {
            boolean askUser = strategyWithReason.getStrategy() == UntrustedCertificateStrategy.ASK_USER;
            String askUserReason = strategyWithReason.getReason();
            this.checkServerTrusted(chain, authType, remoteHost, new CertificateConfirmationParameters(askUser, true, null, null, askUserReason));
        }));
    }

    private void withCalculatedCertificateStrategy(ThrowableConsumer<? super UntrustedCertificateStrategyWithReason, ? extends CertificateException> block) throws CertificateException {
        UntrustedCertificateStrategy initialStrategy = this.myUntrustedCertificateStrategy.get();
        if (initialStrategy != null) {
            block.consume((Object)new UntrustedCertificateStrategyWithReason(initialStrategy, null));
        } else {
            UntrustedCertificateStrategyWithReason strategy = ((InitialUntrustedCertificateStrategyProvider)ApplicationManager.getApplication().getService(InitialUntrustedCertificateStrategyProvider.class)).getStrategy();
            block.consume((Object)strategy);
        }
    }

    @Deprecated
    public void checkServerTrusted(X509Certificate[] chain, String authType, boolean addToKeyStore, boolean askUser) throws CertificateException {
        this.checkServerTrusted(chain, authType, null, new CertificateConfirmationParameters(askUser, addToKeyStore, null, null, null));
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType, @NotNull CertificateConfirmationParameters parameters) throws CertificateException {
        if (parameters == null) {
            ConfirmingTrustManager.$$$reportNull$$$0(5);
        }
        this.checkServerTrusted(chain, authType, null, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkServerTrusted(X509Certificate[] chain, String authType, String remoteHost, @NotNull CertificateConfirmationParameters parameters) throws CertificateException {
        if (parameters == null) {
            ConfirmingTrustManager.$$$reportNull$$$0(6);
        }
        CertificateException lastCertificateException = null;
        for (X509TrustManager trustManager : this.mySystemManagers) {
            try {
                trustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                lastCertificateException = e;
            }
        }
        MutableTrustManager mutableTrustManager = this.myCustomManager;
        synchronized (mutableTrustManager) {
            block9: {
                try {
                    this.myCustomManager.checkServerTrusted(chain, authType);
                }
                catch (CertificateException e) {
                    if (!this.myCustomManager.isBroken() && this.confirmAndUpdate(chain, remoteHost, parameters, authType)) break block9;
                    throw lastCertificateException != null ? lastCertificateException : e;
                }
            }
        }
    }

    private boolean confirmAndUpdate(X509Certificate[] chain, String remoteHost, @NotNull CertificateConfirmationParameters parameters, String authType) {
        if (parameters == null) {
            ConfirmingTrustManager.$$$reportNull$$$0(7);
        }
        Application app = ApplicationManager.getApplication();
        X509Certificate endPoint = chain[0];
        String threadClassName = Strings.notNullize((String)Thread.currentThread().getClass().getCanonicalName());
        if (threadClassName.equals("sun.awt.image.ImageFetcher")) {
            LOG.debug("Image Fetcher thread is detected. Certificate check will be skipped.");
            return true;
        }
        if (app.isHeadlessEnvironment() || CertificateManager.getInstance().getState().ACCEPT_AUTOMATICALLY) {
            LOG.debug("Certificate will be accepted automatically");
            if (parameters.myAddToKeyStore) {
                this.myCustomManager.addCertificate(endPoint);
            }
            return true;
        }
        if (app.isUnitTestMode()) {
            return false;
        }
        boolean accepted = false;
        CertificateProvider certificateProvider = new CertificateProvider();
        if (parameters.myAskUser) {
            String acceptLogMessage = "Going to ask user about certificate for: " + endPoint.getSubjectX500Principal().toString() + ", issuer: " + endPoint.getIssuerX500Principal().toString();
            if (parameters.myAskOrRejectReason != null) {
                acceptLogMessage = acceptLogMessage + ". Reason: " + parameters.myAskOrRejectReason;
            }
            LOG.info(acceptLogMessage);
            if (this.myRejectedCertificates.contains(endPoint)) {
                LOG.info("Certificate was already rejected");
            } else {
                CertificateWarningDialogProvider dialogProvider = CertificateWarningDialogProvider.Companion.getInstance();
                if (dialogProvider == null) {
                    LOG.warn("Accepting dialog wasn't shown, because DialogProvider in unavailable now");
                } else {
                    @Nullable Boolean dialogResult = CertificateManager.Companion.showAcceptDialog(() -> dialogProvider.createCertificateWarningDialog(Arrays.stream(chain).toList(), this.myCustomManager, remoteHost, authType, certificateProvider));
                    if (Boolean.FALSE.equals(dialogResult)) {
                        this.myRejectedCertificates.add(endPoint);
                    }
                    accepted = dialogResult != null && dialogResult != false;
                }
            }
        } else {
            String rejectLogMessage = "Didn't show certificate dialog for: " + endPoint.getSubjectX500Principal().toString() + ", issuer: " + endPoint.getIssuerX500Principal().toString();
            if (parameters.myAskOrRejectReason != null) {
                rejectLogMessage = rejectLogMessage + ". Reason: " + parameters.myAskOrRejectReason;
            }
            LOG.warn(rejectLogMessage);
        }
        if (accepted) {
            LOG.info("Certificate was accepted by user");
            if (parameters.myAddToKeyStore) {
                if (certificateProvider.getSelectedCertificate() == null) {
                    LOG.warn("Certificate wasn't selected, but accepted");
                    accepted = false;
                } else {
                    this.myCustomManager.addCertificate(certificateProvider.getSelectedCertificate());
                }
            }
            if (certificateProvider.isChainRemainUnsafe()) {
                LOG.info("The certificate chain remains untrusted. The request execution will not proceed");
                accepted = false;
            }
            if (parameters.myOnUserAcceptCallback != null) {
                parameters.myOnUserAcceptCallback.run();
            }
        }
        return accepted;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        HashSet<X509Certificate> certificates = new HashSet<X509Certificate>();
        for (X509TrustManager manager : this.mySystemManagers) {
            try {
                certificates.addAll(Arrays.asList(manager.getAcceptedIssuers()));
            }
            catch (Throwable exception) {
                LOG.error("Could not get list of accepted issuers (trusted root identities) from " + manager.toString() + " (" + manager.getClass().getName() + ")", exception);
            }
        }
        certificates.addAll(Arrays.asList(this.myCustomManager.getAcceptedIssuers()));
        return (X509Certificate[])certificates.toArray(X509Certificate[]::new);
    }

    public MutableTrustManager getCustomManager() {
        return this.myCustomManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/ssl/ConfirmingTrustManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificates";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/ssl/ConfirmingTrustManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemTrustManagers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrustManagerFromCertificates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createForStorage";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTrustManagerFromCertificates";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkServerTrusted";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "confirmAndUpdate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    public static final class MutableTrustManager
    extends ClientOnlyTrustManager {
        private final String myPath;
        private final String myPassword;
        private final TrustManagerFactory myFactory;
        private final KeyStore myKeyStore;
        private final ReadWriteLock myLock;
        private final Lock myReadLock;
        private final Lock myWriteLock;
        private X509TrustManager myTrustManager;
        private final EventDispatcher<CertificateListener> myDispatcher;

        private MutableTrustManager(@NotNull String path, @NotNull String password) {
            if (path == null) {
                MutableTrustManager.$$$reportNull$$$0(0);
            }
            if (password == null) {
                MutableTrustManager.$$$reportNull$$$0(1);
            }
            this.myLock = new ReentrantReadWriteLock();
            this.myReadLock = this.myLock.readLock();
            this.myWriteLock = this.myLock.writeLock();
            this.myDispatcher = EventDispatcher.create(CertificateListener.class);
            this.myPath = path;
            this.myPassword = password;
            this.myWriteLock.lock();
            try {
                this.myFactory = MutableTrustManager.createFactory();
                this.myKeyStore = MutableTrustManager.createKeyStore(path, password);
                this.myTrustManager = this.initFactoryAndGetManager();
            }
            finally {
                this.myWriteLock.unlock();
            }
        }

        private static TrustManagerFactory createFactory() {
            try {
                return TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("Cannot create trust manager factory", (Throwable)e);
                return null;
            }
        }

        private static KeyStore createKeyStore(@NotNull String path, @NotNull String password) {
            KeyStore keyStore;
            block13: {
                if (path == null) {
                    MutableTrustManager.$$$reportNull$$$0(2);
                }
                if (password == null) {
                    MutableTrustManager.$$$reportNull$$$0(3);
                }
                try {
                    keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    Path cacertsFile = Path.of(path, new String[0]);
                    if (Files.exists(cacertsFile, new LinkOption[0])) {
                        try (InputStream stream = Files.newInputStream(cacertsFile, new OpenOption[0]);){
                            keyStore.load(stream, password.toCharArray());
                            break block13;
                        }
                    }
                    try {
                        Files.createDirectories(cacertsFile.getParent(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        LOG.error("Cannot create directories: " + String.valueOf(cacertsFile.getParent()), (Throwable)e);
                        return null;
                    }
                    keyStore.load(null, password.toCharArray());
                }
                catch (Exception e) {
                    LOG.error("Cannot create key store", (Throwable)e);
                    return null;
                }
            }
            return keyStore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addCertificate(@NotNull X509Certificate certificate) {
            if (certificate == null) {
                MutableTrustManager.$$$reportNull$$$0(4);
            }
            this.myWriteLock.lock();
            try {
                if (this.isBroken()) {
                    boolean bl = false;
                    return bl;
                }
                this.myKeyStore.setCertificateEntry(MutableTrustManager.createAlias(certificate), certificate);
                this.flushKeyStore();
                LOG.info("Added certificate for '" + certificate.getSubjectX500Principal().toString() + "' to " + this.myPath);
                this.myTrustManager = this.initFactoryAndGetManager();
                ((CertificateListener)this.myDispatcher.getMulticaster()).certificateAdded(certificate);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                LOG.error("Cannot add certificate", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.myWriteLock.unlock();
            }
        }

        public boolean addCertificate(@NotNull String path) {
            X509Certificate certificate;
            if (path == null) {
                MutableTrustManager.$$$reportNull$$$0(5);
            }
            return (certificate = CertificateUtil.loadX509Certificate(path)) != null && this.addCertificate(certificate);
        }

        private static String createAlias(@NotNull X509Certificate certificate) {
            if (certificate == null) {
                MutableTrustManager.$$$reportNull$$$0(6);
            }
            return CertificateUtil.getCommonName(certificate);
        }

        public boolean removeCertificate(@NotNull X509Certificate certificate) {
            if (certificate == null) {
                MutableTrustManager.$$$reportNull$$$0(7);
            }
            return this.removeCertificate(MutableTrustManager.createAlias(certificate));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeCertificate(@NotNull String alias) {
            if (alias == null) {
                MutableTrustManager.$$$reportNull$$$0(8);
            }
            this.myWriteLock.lock();
            try {
                if (this.isBroken()) {
                    boolean bl = false;
                    return bl;
                }
                X509Certificate certificate = this.getCertificate(alias);
                if (certificate == null) {
                    LOG.error("No certificate found for alias: " + alias);
                    boolean bl = false;
                    return bl;
                }
                this.myKeyStore.deleteEntry(alias);
                this.flushKeyStore();
                this.myTrustManager = this.initFactoryAndGetManager();
                ((CertificateListener)this.myDispatcher.getMulticaster()).certificateRemoved(certificate);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                LOG.error("Cannot remove certificate for alias: " + alias, (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.myWriteLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public X509Certificate getCertificate(@NotNull String alias) {
            if (alias == null) {
                MutableTrustManager.$$$reportNull$$$0(9);
            }
            this.myReadLock.lock();
            try {
                X509Certificate x509Certificate = (X509Certificate)this.myKeyStore.getCertificate(alias);
                return x509Certificate;
            }
            catch (KeyStoreException e) {
                X509Certificate x509Certificate = null;
                return x509Certificate;
            }
            finally {
                this.myReadLock.unlock();
            }
        }

        public List<String> getAliases() {
            this.myReadLock.lock();
            try {
                ArrayList<String> arrayList = Collections.list(this.myKeyStore.aliases());
                return arrayList;
            }
            catch (KeyStoreException e) {
                List<String> list = Collections.emptyList();
                return list;
            }
            finally {
                this.myReadLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<X509Certificate> getCertificates() {
            this.myReadLock.lock();
            try {
                ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
                for (String alias : Collections.list(this.myKeyStore.aliases())) {
                    certificates.add(this.getCertificate(alias));
                }
                List list = List.copyOf(certificates);
                return list;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                List<X509Certificate> list = Collections.emptyList();
                return list;
            }
            finally {
                this.myReadLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsCertificate(@NotNull String alias) {
            if (alias == null) {
                MutableTrustManager.$$$reportNull$$$0(10);
            }
            this.myReadLock.lock();
            try {
                boolean bl = this.myKeyStore.containsAlias(alias);
                return bl;
            }
            catch (KeyStoreException e) {
                LOG.error((Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.myReadLock.unlock();
            }
        }

        @VisibleForTesting
        @ApiStatus.Internal
        public boolean removeAllCertificates() {
            for (X509Certificate certificate : this.getCertificates()) {
                if (this.removeCertificate(certificate)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certificates, String s) throws CertificateException {
            this.myReadLock.lock();
            try {
                if (this.keyStoreIsEmpty() || this.isBroken()) {
                    throw new CertificateException();
                }
                this.myTrustManager.checkServerTrusted(certificates, s);
            }
            finally {
                this.myReadLock.unlock();
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            this.myReadLock.lock();
            try {
                if (this.keyStoreIsEmpty() || this.isBroken()) {
                    X509Certificate[] x509CertificateArray = NO_CERTIFICATES;
                    return x509CertificateArray;
                }
                X509Certificate[] x509CertificateArray = this.myTrustManager.getAcceptedIssuers();
                return x509CertificateArray;
            }
            finally {
                this.myReadLock.unlock();
            }
        }

        public void addListener(@NotNull CertificateListener listener2) {
            if (listener2 == null) {
                MutableTrustManager.$$$reportNull$$$0(11);
            }
            this.myDispatcher.addListener((EventListener)listener2);
        }

        public void removeListener(@NotNull CertificateListener listener2) {
            if (listener2 == null) {
                MutableTrustManager.$$$reportNull$$$0(12);
            }
            this.myDispatcher.removeListener((EventListener)listener2);
        }

        private boolean keyStoreIsEmpty() {
            try {
                return this.myKeyStore.size() == 0;
            }
            catch (KeyStoreException e) {
                LOG.error((Throwable)e);
                return true;
            }
        }

        private X509TrustManager initFactoryAndGetManager() {
            try {
                if (this.myFactory != null && this.myKeyStore != null) {
                    this.myFactory.init(this.myKeyStore);
                    Object[] trustManagers = this.myFactory.getTrustManagers();
                    X509TrustManager result2 = ConfirmingTrustManager.findX509TrustManager((TrustManager[])trustManagers);
                    if (result2 == null) {
                        LOG.error("Cannot find X509 trust manager among " + Arrays.toString(trustManagers));
                    }
                    return result2;
                }
            }
            catch (KeyStoreException e) {
                LOG.error("Cannot initialize trust store", (Throwable)e);
            }
            return null;
        }

        private boolean isBroken() {
            return this.myKeyStore == null || this.myFactory == null || this.myTrustManager == null;
        }

        private void flushKeyStore() throws Exception {
            try (FileOutputStream stream = new FileOutputStream(this.myPath);){
                this.myKeyStore.store(stream, this.myPassword.toCharArray());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "password";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "certificate";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alias";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/net/ssl/ConfirmingTrustManager$MutableTrustManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createKeyStore";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCertificate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAlias";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeCertificate";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCertificate";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsCertificate";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addListener";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class CertificateConfirmationParameters {
        private final boolean myAskUser;
        @Nullable
        private final String myAskOrRejectReason;
        private final boolean myAddToKeyStore;
        private final @NlsContexts.DialogMessage @Nullable String myCertificateDetails;
        @Nullable
        private final Runnable myOnUserAcceptCallback;

        @NotNull
        public static CertificateConfirmationParameters askConfirmation(boolean addToKeyStore, @NlsContexts.DialogMessage @Nullable String certificateDetails, @Nullable Runnable onUserAcceptCallback) {
            return new CertificateConfirmationParameters(true, addToKeyStore, certificateDetails, onUserAcceptCallback, null);
        }

        @NotNull
        public static CertificateConfirmationParameters doNotAskConfirmation() {
            return new CertificateConfirmationParameters(false, false, null, null, null);
        }

        private CertificateConfirmationParameters(boolean askUser, boolean addToKeyStore, @NlsContexts.DialogMessage @Nullable String certificateDetails, @Nullable Runnable onUserAcceptCallback, @Nullable String askOrRejectReason) {
            this.myAskUser = askUser;
            this.myAddToKeyStore = addToKeyStore;
            this.myCertificateDetails = certificateDetails;
            this.myOnUserAcceptCallback = onUserAcceptCallback;
            this.myAskOrRejectReason = askOrRejectReason;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CertificateConfirmationParameters that = (CertificateConfirmationParameters)o;
            return this.myAskUser == that.myAskUser && this.myAddToKeyStore == that.myAddToKeyStore && Objects.equals(this.myCertificateDetails, that.myCertificateDetails) && Objects.equals(this.myOnUserAcceptCallback, that.myOnUserAcceptCallback);
        }

        public int hashCode() {
            return Objects.hash(this.myAskUser, this.myAddToKeyStore, this.myCertificateDetails, this.myOnUserAcceptCallback);
        }
    }
}

