/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.AnimatorKt;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AnimatedIcon
extends JComponent
implements Disposable {
    private final Icon[] icons;
    private Dimension preferredSize;
    private int currentIconIndex;
    protected final Icon passiveIcon;
    private final Icon emptyPassiveIcon;
    private boolean isPaintPassive = true;
    private boolean isRunning = true;
    protected final Animator animator;
    private final HiddenAnimator hiddenAnimator;
    private final String name;

    public AnimatedIcon(@NonNls String name, Icon[] icons, Icon passiveIcon, int cycleLength) {
        this(name, icons, passiveIcon, cycleLength, null);
    }

    public AnimatedIcon(@NonNls String name, Icon[] icons, Icon passiveIcon, int cycleLength, @Nullable CoroutineScope coroutineScope) {
        Icon[] iconArray;
        this.name = name;
        if (icons.length == 0) {
            Icon[] iconArray2 = new Icon[1];
            iconArray = iconArray2;
            iconArray2[0] = passiveIcon;
        } else {
            iconArray = icons;
        }
        this.icons = iconArray;
        this.passiveIcon = passiveIcon;
        this.preferredSize = this.calcPreferredSize();
        CoroutineScope animatorScope = coroutineScope != null ? coroutineScope : AnimatorKt.animatorCoroutineScope(name);
        this.animator = new Animator(name, icons.length, cycleLength, true, true, animatorScope){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                int len = AnimatedIcon.this.icons.length;
                AnimatedIcon.this.currentIconIndex = frame < 0 ? 0 : (frame >= len ? len - 1 : frame);
                AnimatedIcon.this.paintImmediately(0, 0, AnimatedIcon.this.getWidth(), AnimatedIcon.this.getHeight());
            }
        };
        this.hiddenAnimator = new HiddenAnimator(icons.length, cycleLength);
        this.emptyPassiveIcon = icons.length > 0 ? EmptyIcon.create((Icon)icons[0]) : EmptyIcon.ICON_0;
        this.setOpaque(false);
        UiNotifyConnector.installOn((Component)this, (Activatable)new Activatable(){

            public void showNotify() {
                if (AnimatedIcon.this.isRunning) {
                    AnimatedIcon.this.ensureAnimation(true);
                }
            }

            public void hideNotify() {
                AnimatedIcon.this.ensureAnimation(false);
            }
        });
    }

    protected Dimension calcPreferredSize() {
        Dimension dimension = new Dimension();
        for (Icon each : this.icons) {
            dimension.width = Math.max(each.getIconWidth(), dimension.width);
            dimension.height = Math.max(each.getIconHeight(), dimension.height);
        }
        return new Dimension(Math.max(this.passiveIcon.getIconWidth(), dimension.width), Math.max(this.passiveIcon.getIconHeight(), dimension.height));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getParent() != null) {
            this.preferredSize = this.calcPreferredSize();
        }
    }

    public void setPaintPassiveIcon(boolean paintPassive) {
        this.isPaintPassive = paintPassive;
    }

    @ApiStatus.Internal
    public void tickAnimation() {
        this.animator.forceTick();
    }

    private boolean ensureAnimation(boolean running) {
        boolean changes;
        boolean isShowing = this.isShowing();
        boolean animatorShouldBeRunning = running && isShowing;
        boolean hiddenAnimatorShouldBeRunning = running && !isShowing;
        boolean bl = changes = this.animator.isRunning() != animatorShouldBeRunning || this.hiddenAnimator.isRunning() != hiddenAnimatorShouldBeRunning;
        if (animatorShouldBeRunning) {
            this.animator.resume();
        } else {
            this.animator.suspend();
        }
        if (hiddenAnimatorShouldBeRunning) {
            this.hiddenAnimator.resume();
        } else {
            this.hiddenAnimator.suspend();
        }
        return changes;
    }

    public void resume() {
        this.isRunning = true;
        this.ensureAnimation(true);
    }

    public void suspend() {
        this.isRunning = false;
        if (this.ensureAnimation(false)) {
            this.repaint();
        }
    }

    public void dispose() {
        this.animator.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.preferredSize.width + insets.left + insets.right, this.preferredSize.height + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            Container parent = this.getParent();
            JComponent opaque = null;
            if (parent instanceof JComponent) {
                opaque = (JComponent)UIUtil.findNearestOpaque((Component)parent);
            }
            Color bg = opaque == null ? UIUtil.getPanelBackground() : opaque.getBackground();
            g.setColor(bg);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Icon icon = this.animator.isRunning() ? this.icons[this.currentIconIndex] : (this.hiddenAnimator.isRunning() ? this.icons[this.hiddenAnimator.getCurrentFrame()] : this.getPassiveIcon());
        Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
        bounds.x += (bounds.width - icon.getIconWidth()) / 2;
        bounds.y += (bounds.height - icon.getIconHeight()) / 2;
        this.paintIcon(g, icon, bounds.x, bounds.y);
    }

    protected void paintIcon(Graphics g, Icon icon, int x, int y) {
        icon.paintIcon(this, g, x, y);
    }

    protected Icon getPassiveIcon() {
        return this.isPaintPassive ? this.passiveIcon : this.emptyPassiveIcon;
    }

    public boolean isRunning() {
        return this.animator.isRunning() || this.hiddenAnimator.isRunning();
    }

    @Override
    public String toString() {
        return this.name + " isRunning=" + this.isRunning + " isOpaque=" + this.isOpaque() + " paintPassive=" + this.isPaintPassive;
    }

    private static class HiddenAnimator {
        private boolean isRunning = false;
        private boolean initialStep = true;
        private final int totalFrames;
        private final int cycleDuration;
        private long startTime;
        private long startDeltaTime;

        HiddenAnimator(int totalFrames, int cycleDuration) {
            this.totalFrames = totalFrames;
            this.cycleDuration = cycleDuration;
        }

        void resume() {
            this.isRunning = true;
        }

        void suspend() {
            this.startDeltaTime = System.currentTimeMillis() - this.startTime;
            this.initialStep = true;
            this.isRunning = false;
        }

        boolean isRunning() {
            return this.isRunning;
        }

        int getCurrentFrame() {
            double cycleTime;
            long currentFrame;
            long now = System.currentTimeMillis();
            if (this.initialStep) {
                this.initialStep = false;
                this.startTime = now - this.startDeltaTime;
            }
            if ((currentFrame = (long)((cycleTime = (double)(now - this.startTime)) * (double)this.totalFrames / (double)this.cycleDuration) % (long)this.totalFrames) < 0L) {
                currentFrame = 0L;
            }
            if (currentFrame >= (long)this.totalFrames) {
                currentFrame = this.totalFrames - 1;
            }
            return (int)currentFrame;
        }
    }
}

