/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ImmutableColumnInfo;
import com.intellij.util.ui.TableViewModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.jetbrains.annotations.NotNull;

public class ListTableModel<Item>
extends TableViewModel<Item>
implements EditableModel {
    private ColumnInfo[] myColumnInfos;
    protected List<Item> myItems;
    private int mySortByColumn;
    private boolean myIsSortable;
    private final SortOrder mySortOrder;

    public ListTableModel(ColumnInfo ... columnInfos) {
        if (columnInfos == null) {
            ListTableModel.$$$reportNull$$$0(0);
        }
        this(columnInfos, new ArrayList(), 0, SortOrder.ASCENDING);
    }

    public ListTableModel(ColumnInfo @NotNull [] columnNames, @NotNull List<Item> items, int selectedColumn) {
        if (items == null) {
            ListTableModel.$$$reportNull$$$0(1);
        }
        if (columnNames == null) {
            ListTableModel.$$$reportNull$$$0(2);
        }
        this(columnNames, items, selectedColumn, SortOrder.ASCENDING);
    }

    public ListTableModel(ColumnInfo @NotNull [] columnNames, @NotNull List<Item> items) {
        if (items == null) {
            ListTableModel.$$$reportNull$$$0(3);
        }
        if (columnNames == null) {
            ListTableModel.$$$reportNull$$$0(4);
        }
        this(columnNames, items, 0);
    }

    public ListTableModel(ColumnInfo @NotNull [] columnNames, @NotNull List<Item> items, int selectedColumn, @NotNull SortOrder order) {
        if (items == null) {
            ListTableModel.$$$reportNull$$$0(5);
        }
        if (order == null) {
            ListTableModel.$$$reportNull$$$0(6);
        }
        if (columnNames == null) {
            ListTableModel.$$$reportNull$$$0(7);
        }
        this.myColumnInfos = columnNames;
        this.myItems = items;
        this.mySortByColumn = selectedColumn;
        this.mySortOrder = order;
        this.setSortable(ContainerUtil.find((Object[])columnNames, ColumnInfo::isSortable) != null);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.myColumnInfos[columnIndex].isCellEditable(this.myItems.get(rowIndex));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.myColumnInfos[columnIndex].getColumnClass();
    }

    @Override
    public ColumnInfo[] getColumnInfos() {
        return this.myColumnInfos;
    }

    @Override
    public String getColumnName(int column) {
        return this.myColumnInfos[column].getName();
    }

    @Override
    public int getRowCount() {
        return this.myItems.size();
    }

    @Override
    public RowSorter.SortKey getDefaultSortKey() {
        if (this.mySortByColumn != -1) {
            return new RowSorter.SortKey(this.mySortByColumn, this.mySortOrder);
        }
        return null;
    }

    public Item getRowValue(int row) {
        return this.myItems.get(row);
    }

    @Override
    public int getColumnCount() {
        return this.myColumnInfos.length;
    }

    @Override
    public void setItems(@NotNull List<Item> items) {
        if (items == null) {
            ListTableModel.$$$reportNull$$$0(8);
        }
        this.myItems = items;
        this.fireTableDataChanged();
    }

    public void setItem(int rowIndex, @NotNull Item item) {
        if (item == null) {
            ListTableModel.$$$reportNull$$$0(9);
        }
        this.myItems.set(rowIndex, item);
        this.fireTableCellUpdated(rowIndex, -1);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.myColumnInfos[columnIndex].valueOf(this.getItem(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setValueAt(aValue, rowIndex, columnIndex, true);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex, boolean notifyListeners) {
        if (rowIndex < this.myItems.size()) {
            this.setValue(aValue, rowIndex, this.myColumnInfos[columnIndex]);
        }
        if (notifyListeners) {
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    private <Aspect> void setValue(Aspect aValue, int rowIndex, ColumnInfo<Item, Aspect> info) {
        Item item = this.getItem(rowIndex);
        if (info instanceof ImmutableColumnInfo) {
            this.setItem(rowIndex, ((ImmutableColumnInfo)info).withValue(item, aValue));
        } else {
            info.setValue(item, aValue);
        }
    }

    public boolean setColumnInfos(ColumnInfo[] columnInfos) {
        if (this.myColumnInfos != null && Arrays.equals(columnInfos, this.myColumnInfos)) {
            return false;
        }
        this.mySortByColumn = -1;
        this.myColumnInfos = columnInfos;
        this.fireTableStructureChanged();
        return true;
    }

    @Override
    @NotNull
    public List<Item> getItems() {
        List<Item> list = Collections.unmodifiableList(this.myItems);
        if (list == null) {
            ListTableModel.$$$reportNull$$$0(10);
        }
        return list;
    }

    protected Object getAspectOf(int aspectIndex, Object item) {
        return this.myColumnInfos[aspectIndex].valueOf(item);
    }

    @Override
    public void setSortable(boolean aBoolean) {
        this.myIsSortable = aBoolean;
    }

    @Override
    public boolean isSortable() {
        return this.myIsSortable;
    }

    public int indexOf(Item item) {
        return this.myItems.indexOf(item);
    }

    public void addRow() {
    }

    public void removeRow(int idx) {
        this.myItems.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
    }

    public void exchangeRows(int idx1, int idx2) {
        Collections.swap(this.myItems, idx1, idx2);
        if (idx1 < idx2) {
            this.fireTableRowsUpdated(idx1, idx2);
        } else {
            this.fireTableRowsUpdated(idx2, idx1);
        }
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return true;
    }

    public void addRow(Item item) {
        this.myItems.add(item);
        this.fireTableRowsInserted(this.myItems.size() - 1, this.myItems.size() - 1);
    }

    public void insertRow(int index, Item item) {
        this.myItems.add(index, item);
        this.fireTableRowsInserted(index, index);
    }

    public void addRows(@NotNull Collection<? extends Item> items) {
        if (items == null) {
            ListTableModel.$$$reportNull$$$0(11);
        }
        if (items.isEmpty()) {
            return;
        }
        this.myItems.addAll(items);
        this.fireTableRowsInserted(this.myItems.size() - items.size(), this.myItems.size() - 1);
    }

    public Item getItem(int rowIndex) {
        return this.myItems.get(rowIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfos";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/ListTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/ListTableModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setItems";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setItem";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addRows";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

