/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.FragmentStatisticsService;
import com.intellij.execution.ui.FragmentedSettings;
import com.intellij.execution.ui.NestedGroupFragment;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.CompositeSettingsBuilder;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.components.DropDownLink;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class FragmentedSettingsBuilder<Settings extends FragmentedSettings>
implements CompositeSettingsBuilder<Settings>,
Disposable {
    public static final int TOP_INSET = 6;
    public static final int LEFT_INSET = 20;
    public static final int MEDIUM_TOP_INSET = 8;
    public static final int LARGE_TOP_INSET = 20;
    public static final int TAG_VGAP = 6;
    public static final int TAG_HGAP = 2;
    private Disposable myDisposable;
    private final JPanel myPanel;
    private final GridBagConstraints myConstraints;
    private final Collection<? extends SettingsEditorFragment<Settings, ?>> myFragments;
    @Nullable
    private final NestedGroupFragment<Settings> myMain;
    protected int myGroupInset;
    private DropDownLink<String> myLinkLabel;
    private String myConfigId;

    public FragmentedSettingsBuilder(Collection<? extends SettingsEditorFragment<Settings, ?>> fragments2, @Nullable NestedGroupFragment<Settings> main, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            FragmentedSettingsBuilder.$$$reportNull$$$0(0);
        }
        this.myPanel = new JPanel(new GridBagLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                FragmentedSettingsBuilder.this.myDisposable = Disposer.newDisposable();
                FragmentedSettingsBuilder.this.registerShortcuts();
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                Disposer.dispose((Disposable)FragmentedSettingsBuilder.this.myDisposable);
            }
        };
        this.myConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.insetsTop((int)6), 0, 0);
        this.myFragments = fragments2;
        this.myMain = main;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public void dispose() {
        if (this.myDisposable != null && !Disposer.isDisposed((Disposable)this.myDisposable)) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    @NotNull
    public Collection<SettingsEditor<Settings>> getEditors() {
        return new ArrayList<SettingsEditor<Settings>>(this.myFragments);
    }

    @NotNull
    public JComponent createCompoundEditor() {
        ArrayList fragments2 = new ArrayList(this.myFragments);
        fragments2.sort(Comparator.comparingInt(SettingsEditorFragment::getPriority));
        SettingsEditorFragment beforeRun = (SettingsEditorFragment)((Object)ContainerUtil.find(fragments2, fragment -> fragment.isBeforeRun()));
        SettingsEditorFragment header = (SettingsEditorFragment)((Object)ContainerUtil.find(fragments2, fragment -> fragment.isHeader()));
        List commandLine = ContainerUtil.filter(fragments2, fragment -> fragment.isCommandLine());
        List subGroups = ContainerUtil.filter(fragments2, fragment -> !fragment.getChildren().isEmpty());
        List tags = ContainerUtil.filter(fragments2, it -> it.isTag());
        fragments2.remove((Object)beforeRun);
        fragments2.remove((Object)header);
        fragments2.removeAll(commandLine);
        fragments2.removeAll(subGroups);
        fragments2.removeAll(tags);
        if (this.myMain == null) {
            this.myPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
            this.addLine(new JSeparator(){

                @Override
                public Dimension getMinimumSize() {
                    Dimension minimumSize = super.getMinimumSize();
                    Dimension preferredSize = this.getPreferredSize();
                    minimumSize.height = Math.max(minimumSize.height, preferredSize.height);
                    return minimumSize;
                }
            });
        }
        this.addBeforeRun(beforeRun);
        this.addHeader(header);
        int n = this.myGroupInset = this.myMain == null ? 0 : 20;
        if (this.myMain != null && this.myMain.component() != null) {
            this.addLine((Component)this.myMain.component());
        }
        this.addCommandLinePanel(commandLine);
        this.addFragments(fragments2);
        this.addTagPanel(tags);
        this.addSubGroups(subGroups);
        this.myGroupInset = 0;
        if (this.myMain == null) {
            this.myConstraints.weighty = 1.0;
            this.myPanel.add((Component)new JPanel(), this.myConstraints);
        }
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            FragmentedSettingsBuilder.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    protected void addLine(Component component, int top, int left, int bottom) {
        this.myConstraints.insets = JBUI.insets((int)top, (int)(left + this.myGroupInset), (int)bottom, (int)0);
        this.myPanel.add(component, this.myConstraints.clone());
        ++this.myConstraints.gridy;
        this.myConstraints.insets = JBUI.insetsTop((int)top);
    }

    protected void addLine(Component component) {
        this.addLine(component, 6, 0, 0);
    }

    protected void addBeforeRun(@Nullable SettingsEditorFragment<Settings, ?> beforeRun) {
        if (beforeRun != null) {
            this.addLine(beforeRun.getComponent(), 6, 0, 12);
        }
    }

    protected void addHeader(@Nullable SettingsEditorFragment<Settings, ?> header) {
        JComponent separator;
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
        if (header != null) {
            panel2.add((Component)header.getComponent(), "West");
        }
        if ((separator = this.createHeaderSeparator()) != null) {
            panel2.add((Component)separator, "Center");
        }
        String message = OptionsBundle.message((String)(this.myMain == null ? "settings.editor.modify.options" : "settings.editor.modify"), (Object[])new Object[0]);
        this.myLinkLabel = new DropDownLink<String>(message, (Function1<DropDownLink<String>, JBPopup>)((Function1)link -> this.showOptions()));
        this.myLinkLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        JPanel linkPanel = new JPanel(new BorderLayout());
        linkPanel.add(this.myLinkLabel, "Center");
        CustomShortcutSet shortcutSet = KeymapUtil.getShortcutsForMnemonicCode(TextWithMnemonic.parse((String)message).getMnemonicCode());
        if (shortcutSet != null) {
            List list = ContainerUtil.sorted((Collection)ContainerUtil.map((Object[])shortcutSet.getShortcuts(), shortcut -> KeymapUtil.getShortcutText(shortcut)), Comparator.comparingInt(String::length));
            JLabel shortcutLabel = new JLabel((String)list.get(0));
            shortcutLabel.setEnabled(false);
            shortcutLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
            linkPanel.add((Component)shortcutLabel, "East");
        }
        panel2.add((Component)linkPanel, "East");
        this.addLine(panel2, this.myMain == null ? 6 : 20, 0, 0);
    }

    @Nullable
    protected JComponent createHeaderSeparator() {
        return this.myMain != null ? SeparatorFactory.createSeparator(this.myMain.getGroup(), null) : null;
    }

    protected void addFragments(@NotNull List<? extends SettingsEditorFragment<Settings, ?>> fragments2) {
        if (fragments2 == null) {
            FragmentedSettingsBuilder.$$$reportNull$$$0(2);
        }
        for (SettingsEditorFragment<Settings, ?> fragment : fragments2) {
            JComponent component = fragment.getComponent();
            this.addLine(component);
            if (fragment.getHintComponent() == null) continue;
            this.addLine(fragment.getHintComponent(), 6, FragmentedSettingsBuilder.getLeftInset(component), 0);
        }
    }

    protected void addSubGroups(@NotNull List<? extends SettingsEditorFragment<Settings, ?>> subGroups) {
        if (subGroups == null) {
            FragmentedSettingsBuilder.$$$reportNull$$$0(3);
        }
        for (SettingsEditorFragment<Settings, ?> group : subGroups) {
            this.addLine(group.getComponent(), 0, 0, 0);
        }
    }

    protected void addTagPanel(@NotNull List<? extends SettingsEditorFragment<Settings, ?>> tags) {
        if (tags == null) {
            FragmentedSettingsBuilder.$$$reportNull$$$0(4);
        }
        JPanel tagsPanel = new JPanel((LayoutManager)new WrapLayout(3, JBUI.scale((int)2), JBUI.scale((int)6))){

            @Override
            public Dimension getMinimumSize() {
                Dimension minimumSize = super.getMinimumSize();
                Dimension preferredSize = this.getPreferredSize();
                minimumSize.height = Math.max(minimumSize.height, preferredSize.height);
                return minimumSize;
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new JPanel.AccessibleJPanel(){

                        @Override
                        public AccessibleRole getAccessibleRole() {
                            return SystemInfoRt.isMac ? AccessibleRole.AWT_COMPONENT : AccessibleRole.PANEL;
                        }
                    };
                    this.accessibleContext.setAccessibleName(FragmentedSettingsBuilder.this.myMain != null ? IdeBundle.message("tag.panel.group.options.accessible.name", FragmentedSettingsBuilder.this.myMain.getGroup()) : IdeBundle.message("tag.panel.run.options.accessible.name", new Object[0]));
                }
                return this.accessibleContext;
            }
        };
        for (SettingsEditorFragment<Settings, ?> tag : tags) {
            tagsPanel.add(tag.getComponent());
        }
        if (tagsPanel.getComponentCount() > 0) {
            FragmentedSettingsBuilder.hideWhenChildrenIsInvisible(tagsPanel);
            this.addLine(tagsPanel, 8, -FragmentedSettingsBuilder.getLeftInset((JComponent)tagsPanel.getComponent(0)) - 2, 0);
        }
    }

    private static void hideWhenChildrenIsInvisible(JComponent component) {
        Object[] children = component.getComponents();
        component.setVisible(ContainerUtil.exists((Object[])children, it -> it.isVisible()));
        for (Object child : children) {
            UIUtil.runWhenVisibilityChanged((Component)child, () -> FragmentedSettingsBuilder.lambda$hideWhenChildrenIsInvisible$9(component, (Component[])children));
        }
    }

    private void registerShortcuts() {
        for (final AnAction action : this.buildGroup((Ref<JComponent>)new Ref()).getChildActionsOrStubs()) {
            ShortcutSet shortcutSet = action.getShortcutSet();
            if (!(action instanceof ToggleFragmentAction) || !shortcutSet.hasShortcuts()) continue;
            new DumbAwareAction(action.getTemplateText()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    SettingsEditorFragment<?, ?> fragment = ((ToggleFragmentAction)action).myFragment;
                    fragment.toggle(true, e);
                    IdeFocusManager.getGlobalInstance().requestFocus((Component)fragment.getEditorComponent(), false);
                    FragmentStatisticsService.getInstance().logNavigateOption(e.getProject(), fragment.getId(), FragmentedSettingsBuilder.this.myConfigId, e);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/ui/FragmentedSettingsBuilder$4", "actionPerformed"));
                }
            }.registerCustomShortcutSet(shortcutSet, (JComponent)this.myPanel.getRootPane(), this.myDisposable);
        }
    }

    private JBPopup showOptions() {
        DataContext dataContext = DataManager.getInstance().getDataContext(this.myLinkLabel);
        Ref lastSelected = new Ref();
        DefaultActionGroup group = this.buildGroup((Ref<JComponent>)lastSelected);
        Runnable callback = () -> ApplicationManager.getApplication().invokeLater(() -> {
            JComponent component = (JComponent)lastSelected.get();
            if (component != null && !(component instanceof JPanel) && !(component instanceof JLabel)) {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)component, false);
            }
        });
        String title = this.myMain != null ? IdeBundle.message("popup.title.add.group.options", this.myMain.getGroup()) : IdeBundle.message("popup.title.add.run.options", new Object[0]);
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(title, group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, callback, -1);
        popup2.setHandleAutoSelectionBeforeShow(true);
        popup2.addListSelectionListener(e -> {
            JList list;
            Object selectedItem;
            Component component = (Component)e.getSource();
            if (component instanceof JList && (selectedItem = (list = (JList)component).getSelectedValue()) instanceof AnActionHolder) {
                JBPopup jbPopup = PopupUtil.getPopupContainerFor(component);
                jbPopup.setAdText(FragmentedSettingsBuilder.getHint(((AnActionHolder)selectedItem).getAction()), 2);
            }
        });
        return popup2;
    }

    public void setConfigId(String configId) {
        this.myConfigId = configId;
    }

    @NlsContexts.PopupAdvertisement
    @NotNull
    private static String getHint(AnAction action) {
        return action != null && StringUtil.isNotEmpty((String)action.getTemplatePresentation().getDescription()) ? action.getTemplatePresentation().getDescription() : "";
    }

    @NotNull
    private DefaultActionGroup buildGroup(@Unmodifiable List<? extends SettingsEditorFragment<Settings, ?>> fragments2, Ref<? super JComponent> lastSelected) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        String group = null;
        for (SettingsEditorFragment fragment : ContainerUtil.sorted(this.restoreGroups(fragments2), Comparator.comparingInt(SettingsEditorFragment::getMenuPosition))) {
            ActionGroup customGroup;
            if (fragment.isRemovable() && !Objects.equals(group, fragment.getGroup())) {
                group = fragment.getGroup();
                actionGroup.add(new Separator(group));
            }
            if ((customGroup = fragment.getCustomActionGroup()) != null) {
                actionGroup.add((AnAction)customGroup);
                continue;
            }
            List children = fragment.getChildren();
            if (children.isEmpty()) {
                ToggleFragmentAction action = new ToggleFragmentAction(fragment, lastSelected);
                ShortcutSet shortcutSet = ActionUtil.getMnemonicAsShortcut(action);
                if (shortcutSet != null) {
                    action.registerCustomShortcutSet(shortcutSet, null);
                }
                actionGroup.add(action);
                continue;
            }
            DefaultActionGroup childGroup = this.buildGroup(children, lastSelected);
            childGroup.getTemplatePresentation().setText(fragment.getChildrenGroupName());
            actionGroup.add((AnAction)childGroup);
        }
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            FragmentedSettingsBuilder.$$$reportNull$$$0(5);
        }
        return defaultActionGroup;
    }

    private DefaultActionGroup buildGroup(Ref<? super JComponent> lastSelected) {
        return this.buildGroup(ContainerUtil.filter(this.myFragments, fragment -> fragment.getName() != null), lastSelected);
    }

    private List<SettingsEditorFragment<Settings, ?>> restoreGroups(List<? extends SettingsEditorFragment<Settings, ?>> fragments2) {
        ArrayList result2 = new ArrayList();
        for (SettingsEditorFragment<Settings, ?> fragment : fragments2) {
            String group = fragment.getGroup();
            int last = ContainerUtil.lastIndexOf(result2, f -> Objects.equals(f.getGroup(), group));
            result2.add(last >= 0 ? last + 1 : result2.size(), fragment);
        }
        return result2;
    }

    private void addCommandLinePanel(@NotNull List<? extends SettingsEditorFragment<Settings, ?>> commandLine) {
        if (commandLine == null) {
            FragmentedSettingsBuilder.$$$reportNull$$$0(6);
        }
        if (!commandLine.isEmpty()) {
            CommandLinePanel panel2 = new CommandLinePanel(commandLine, this.myConfigId, this);
            this.addLine(panel2, 0, -panel2.getLeftInset(), 6);
        }
    }

    static int getLeftInset(JComponent component) {
        if (component.getBorder() != null) {
            return component.getBorder().getBorderInsets((Component)component).left;
        }
        JComponent wrapped = (JComponent)ContainerUtil.find((Object[])component.getComponents(), co -> co.isVisible());
        return wrapped != null ? FragmentedSettingsBuilder.getLeftInset(wrapped) : 0;
    }

    private static /* synthetic */ void lambda$hideWhenChildrenIsInvisible$9(JComponent component, Component[] children) {
        component.setVisible(ContainerUtil.exists((Object[])children, it -> it.isVisible()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/FragmentedSettingsBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subGroups";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/FragmentedSettingsBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompoundEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addFragments";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSubGroups";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTagPanel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCommandLinePanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }

    private static final class ToggleFragmentAction
    extends ToggleAction
    implements DumbAware {
        private final SettingsEditorFragment<?, ?> myFragment;
        private final Ref<? super JComponent> myLastSelected;

        private ToggleFragmentAction(SettingsEditorFragment<?, ?> fragment, Ref<? super JComponent> lastSelected) {
            super(fragment.getName());
            this.myFragment = fragment;
            this.myLastSelected = lastSelected;
            this.getTemplatePresentation().setDescription(fragment.getActionHint());
            if (fragment.getActionDescription() != null) {
                this.getTemplatePresentation().putClientProperty(ActionUtil.SECONDARY_TEXT, (Object)fragment.getActionDescription());
            }
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleFragmentAction.$$$reportNull$$$0(0);
            }
            return this.myFragment.isSelected();
        }

        @Override
        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleFragmentAction.$$$reportNull$$$0(1);
            }
            this.myFragment.toggle(state, e);
            if (state) {
                this.myLastSelected.set((Object)this.myFragment.getEditorComponent());
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleFragmentAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            e.getPresentation().setVisible(this.myFragment.isRemovable());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ToggleFragmentAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/ui/FragmentedSettingsBuilder$ToggleFragmentAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/ui/FragmentedSettingsBuilder$ToggleFragmentAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

