/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSelectInContext
implements SelectInContext {
    private final Project myProject;
    private final VirtualFile myFile;
    private final FileEditorProvider myProvider;

    public FileSelectInContext(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            FileSelectInContext.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FileSelectInContext.$$$reportNull$$$0(1);
        }
        this(project, file, FileSelectInContext.getFileEditorProvider(project, file));
    }

    public FileSelectInContext(@NotNull PsiDirectory directory) {
        if (directory == null) {
            FileSelectInContext.$$$reportNull$$$0(2);
        }
        this(directory.getProject(), directory.getVirtualFile(), null);
    }

    public FileSelectInContext(@NotNull Project project, @NotNull VirtualFile file, @Nullable FileEditorProvider provider) {
        if (project == null) {
            FileSelectInContext.$$$reportNull$$$0(3);
        }
        if (file == null) {
            FileSelectInContext.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file);
        this.myProvider = provider;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FileSelectInContext.$$$reportNull$$$0(5);
        }
        return project;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            FileSelectInContext.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public Object getSelectorInFile() {
        return null;
    }

    @Override
    @Nullable
    public FileEditorProvider getFileEditorProvider() {
        return this.myProvider;
    }

    private static FileEditorProvider getFileEditorProvider(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditorManager manager;
        if (project == null) {
            FileSelectInContext.$$$reportNull$$$0(7);
        }
        if (file == null) {
            FileSelectInContext.$$$reportNull$$$0(8);
        }
        return (manager = FileEditorManager.getInstance((Project)project)) == null ? null : () -> (FileEditor)ArrayUtil.getFirstElement((Object[])manager.openFile(file, false));
    }

    public String toString() {
        return "FileSelectInContext{myProject=" + String.valueOf(this.myProject) + ", myFile=" + String.valueOf(this.myFile) + ", myProvider=" + String.valueOf(this.myProvider) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/FileSelectInContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/FileSelectInContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileEditorProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

