/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.TimerUtil;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import sun.awt.AppContext;

public final class SmoothAutoScroller {
    @ApiStatus.Experimental
    public static final Key<Boolean> ENABLED = Key.create((String)"SmoothAutoScroller enabled");

    @ApiStatus.Experimental
    @NotNull
    public static DropTargetListener getSharedListener() {
        DropTargetListener dropTargetListener = ScrollListener.SHARED;
        if (dropTargetListener == null) {
            SmoothAutoScroller.$$$reportNull$$$0(0);
        }
        return dropTargetListener;
    }

    @ApiStatus.Experimental
    public static void installDropTargetAsNecessary(@NotNull JComponent component) {
        if (component == null) {
            SmoothAutoScroller.$$$reportNull$$$0(1);
        }
        if (component instanceof Autoscroll) {
            return;
        }
        component.putClientProperty(ENABLED, true);
        component.setAutoscrolls(false);
        DropTarget target = component.getDropTarget();
        if (target == null && !GraphicsEnvironment.isHeadless()) {
            component.setDropTarget(new DropTarget(component, 0x40000003, DragListener.SHARED));
        }
    }

    @ApiStatus.Internal
    public static void recreateDragListener() {
        DragListener.SHARED.recreateListener();
    }

    private static JComponent getComponent(DropTargetDragEvent event) {
        JComponent component;
        if (event == null) {
            return null;
        }
        Component source = event.getDropTargetContext().getComponent();
        JComponent jComponent = component = source instanceof JComponent ? (JComponent)source : null;
        if (component == null) {
            return null;
        }
        if (component instanceof Autoscroll) {
            return null;
        }
        if (component.getAutoscrolls()) {
            return null;
        }
        if (!component.isShowing()) {
            return null;
        }
        return ClientProperty.isTrue((Component)component, ENABLED) ? component : null;
    }

    private static int getDelta(int count, int margin, int value2, int min, int max) {
        int offset;
        if (value2 < (min += (offset = Math.min(count * margin, (max - min) / 2)))) {
            double delta = (double)(min - value2) / (double)margin;
            return (double)count < delta ? 0 : -((int)Math.floor(delta * delta));
        }
        if (value2 > (max -= offset)) {
            double delta = (double)(value2 - max) / (double)margin;
            return (double)count < delta ? 0 : (int)Math.floor(delta * delta);
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/dnd/SmoothAutoScroller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/dnd/SmoothAutoScroller";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installDropTargetAsNecessary";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class ScrollListener
    implements DropTargetListener {
        private static final Logger LOG = Logger.getInstance(SmoothAutoScroller.class);
        private static final DropTargetListener SHARED = new ScrollListener();
        private DropTargetDragEvent event;
        private final Point screen = new Point();
        private final Timer timer = TimerUtil.createNamedTimer((String)"SmoothAutoScroller timer", (int)10, e -> {
            if (!this.validate(this.event)) {
                this.update(null);
            }
        });

        private ScrollListener() {
            LOG.debug("SmoothAutoScroller created");
        }

        private void update(DropTargetDragEvent event) {
            JComponent component = SmoothAutoScroller.getComponent(event);
            if (component != null) {
                Window window;
                Point location = new Point(event.getLocation());
                SwingUtilities.convertPointToScreen(location, component);
                if (Registry.is((String)"ide.dnd.to.front") && (window = ComponentUtil.getWindow((Component)component)) != null) {
                    window.toFront();
                }
                this.screen.setLocation(location);
                this.event = event;
                if (!this.timer.isRunning()) {
                    LOG.debug("SmoothAutoScroller started");
                    this.timer.start();
                }
            } else {
                this.event = null;
                if (this.timer.isRunning()) {
                    LOG.debug("SmoothAutoScroller stopped");
                    this.timer.stop();
                }
            }
        }

        private boolean validate(DropTargetDragEvent event) {
            DropTarget target;
            JComponent component = SmoothAutoScroller.getComponent(event);
            if (component == null) {
                return false;
            }
            Point location = new Point(this.screen);
            SwingUtilities.convertPointFromScreen(location, component);
            Rectangle bounds = component.getVisibleRect();
            if (!bounds.contains(location.x, location.y)) {
                return false;
            }
            int margin = (int)(5.0f * JBUIScale.sysScale((Component)component));
            int deltaX = SmoothAutoScroller.getDelta(3, margin, location.x, bounds.x, bounds.x + bounds.width);
            int deltaY = SmoothAutoScroller.getDelta(5, margin, location.y, bounds.y, bounds.y + bounds.height);
            if (deltaX != 0 || deltaY != 0) {
                LOG.debug("SmoothAutoScroller delta X:", new Object[]{deltaX, " Y:", deltaY});
                bounds.x += deltaX;
                bounds.y += deltaY;
                SwingUtilities.convertPointToScreen(location, component);
                component.scrollRectToVisible(bounds);
                SwingUtilities.convertPointFromScreen(location, component);
            }
            if ((target = component.getDropTarget()) != null && !location.equals(event.getLocation())) {
                LOG.debug("SmoothAutoScroller simulates dragOver");
                target.dragOver(new DropTargetDragEvent(event.getDropTargetContext(), location, event.getDropAction(), event.getSourceActions()));
            }
            return true;
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            this.update(event);
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
            this.update(event);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            this.update(event);
        }

        @Override
        public void dragExit(DropTargetEvent event) {
            this.update(null);
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            this.update(null);
        }
    }

    private static final class DragListener
    implements DropTargetListener {
        public static final int ACTION = 0x40000003;
        private static final DragListener SHARED = new DragListener();
        private DropTargetListener listener;

        private DragListener() {
            this.createListener();
        }

        void recreateListener() {
            if (this.listener != null) {
                AppContext.getAppContext().remove(this.listener.getClass());
            }
            this.createListener();
        }

        private void createListener() {
            try {
                this.listener = MethodHandles.privateLookupIn(TransferHandler.class, MethodHandles.lookup()).findStatic(TransferHandler.class, "getDropTargetListener", MethodType.methodType(DropTargetListener.class)).invokeExact();
            }
            catch (Throwable e) {
                throw new InternalError("Unexpected JDK: " + SystemInfo.JAVA_VERSION, e);
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            SmoothAutoScroller.getSharedListener().dragEnter(event);
            ReflectionUtil.setField(this.listener.getClass(), (Object)this.listener, Object.class, (String)"state", null);
            ReflectionUtil.setField(this.listener.getClass(), (Object)this.listener, Component.class, (String)"component", (Object)event.getDropTargetContext().getComponent());
            this.listener.dropActionChanged(event);
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
            SmoothAutoScroller.getSharedListener().dragOver(event);
            this.listener.dropActionChanged(event);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            SmoothAutoScroller.getSharedListener().dropActionChanged(event);
            this.listener.dropActionChanged(event);
        }

        @Override
        public void dragExit(DropTargetEvent event) {
            SmoothAutoScroller.getSharedListener().dragExit(event);
            this.listener.dragExit(event);
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            SmoothAutoScroller.getSharedListener().drop(event);
            this.listener.drop(event);
        }
    }
}

