/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionInGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultActionGroup
extends ActionGroup {
    private static final Logger LOG = Logger.getInstance(DefaultActionGroup.class);
    private final List<AnAction> mySortedChildren;
    private final List<AnAction> myPendingActions;
    private final HashMap<AnAction, Constraints> myConstraints;
    private int myModificationStamp;

    public DefaultActionGroup() {
        this.mySortedChildren = new ArrayList<AnAction>();
        this.myPendingActions = new ArrayList<AnAction>();
        this.myConstraints = new HashMap();
    }

    public DefaultActionGroup(AnAction ... actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(0);
        }
        this(Arrays.asList(actions));
    }

    public DefaultActionGroup(@NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(1);
        }
        this((Supplier<String>)Presentation.NULL_STRING, actions);
    }

    public DefaultActionGroup(@NotNull Supplier<@NlsActions.ActionText String> name, @NotNull List<? extends AnAction> actions) {
        if (name == null) {
            DefaultActionGroup.$$$reportNull$$$0(2);
        }
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(3);
        }
        this(name, false);
        this.addActions(actions);
    }

    public DefaultActionGroup(@Nullable @NlsActions.ActionText String name, @NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(4);
        }
        this(() -> name, actions);
    }

    public DefaultActionGroup(@Nullable @NlsActions.ActionText String shortName, boolean popup2) {
        this(() -> shortName, popup2);
    }

    public DefaultActionGroup(@NotNull Supplier<@NlsActions.ActionText String> shortName, boolean popup2) {
        if (shortName == null) {
            DefaultActionGroup.$$$reportNull$$$0(5);
        }
        super(shortName, popup2);
        this.mySortedChildren = new ArrayList<AnAction>();
        this.myPendingActions = new ArrayList<AnAction>();
        this.myConstraints = new HashMap();
    }

    public DefaultActionGroup(@Nullable @NlsActions.ActionText String text, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon) {
        super(text, description, icon);
        this.mySortedChildren = new ArrayList<AnAction>();
        this.myPendingActions = new ArrayList<AnAction>();
        this.myConstraints = new HashMap();
    }

    public DefaultActionGroup(@NotNull Supplier<@NlsActions.ActionText String> dynamicText, @NotNull Supplier<@NlsActions.ActionDescription String> dynamicDescription, @Nullable Icon icon) {
        if (dynamicText == null) {
            DefaultActionGroup.$$$reportNull$$$0(6);
        }
        if (dynamicDescription == null) {
            DefaultActionGroup.$$$reportNull$$$0(7);
        }
        super(dynamicText, dynamicDescription, icon);
        this.mySortedChildren = new ArrayList<AnAction>();
        this.myPendingActions = new ArrayList<AnAction>();
        this.myConstraints = new HashMap();
    }

    public static DefaultActionGroup createPopupGroup(@NotNull Supplier<@NlsActions.ActionText String> shortName) {
        if (shortName == null) {
            DefaultActionGroup.$$$reportNull$$$0(8);
        }
        return new DefaultActionGroup(shortName, true);
    }

    public static DefaultActionGroup createFlatGroup(@NotNull Supplier<@NlsActions.ActionText String> shortName) {
        if (shortName == null) {
            DefaultActionGroup.$$$reportNull$$$0(9);
        }
        return new DefaultActionGroup(shortName, false);
    }

    public static DefaultActionGroup createPopupGroupWithEmptyText() {
        return DefaultActionGroup.createPopupGroup(() -> "");
    }

    private void incrementModificationStamp() {
        ++this.myModificationStamp;
    }

    public int getModificationStamp() {
        return this.myModificationStamp;
    }

    private synchronized void addActions(@NotNull List<? extends AnAction> actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(10);
        }
        HashSet<AnAction> actionSet = new HashSet<AnAction>(actions.size());
        ArrayList<AnAction> uniqueActions = new ArrayList<AnAction>(actions.size());
        for (AnAction anAction2 : actions) {
            if (anAction2 == this) {
                LOG.error((Throwable)this.newThisGroupToItselfAddedException());
                continue;
            }
            if (anAction2 == null) {
                LOG.error((Throwable)this.nullActionAddedToTheGroupException());
                continue;
            }
            if (!(anAction2 instanceof Separator) && !actionSet.add(anAction2)) {
                LOG.error((Throwable)DefaultActionGroup.newDuplicateActionAddedException(anAction2));
                continue;
            }
            uniqueActions.add(anAction2);
        }
        this.mySortedChildren.addAll(uniqueActions);
        this.incrementModificationStamp();
    }

    private IllegalArgumentException newThisGroupToItselfAddedException() {
        return new IllegalArgumentException("Cannot add a group to itself: " + String.valueOf((Object)this) + " (" + this.getTemplateText() + ")");
    }

    private IllegalArgumentException nullActionAddedToTheGroupException() {
        return new IllegalArgumentException("Cannot add null action to the group " + String.valueOf((Object)this) + " (" + this.getTemplateText() + ")");
    }

    private static IllegalArgumentException newDuplicateActionAddedException(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(11);
        }
        return new IllegalArgumentException("Cannot add an action twice: " + String.valueOf(action) + " (" + (action instanceof ActionStub ? ((ActionStub)action).getClassName() : action.getClass().getName()) + ")");
    }

    public final void add(@NotNull AnAction action, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(12);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(13);
        }
        this.add(action, Constraints.LAST, actionManager);
    }

    public final void add(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(14);
        }
        this.addAction(action, Constraints.LAST);
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(15);
        }
        return this.addAction(action, Constraints.LAST);
    }

    public final void addSeparator() {
        this.add(Separator.create());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(16);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(17);
        }
        this.addAction(action, constraint, ActionManager.getInstance());
    }

    @NotNull
    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(18);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(19);
        }
        return this.addAction(action, constraint, ActionManager.getInstance());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(20);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(21);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(22);
        }
        this.addAction(action, constraint, actionManager);
    }

    @NotNull
    public final synchronized ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(23);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(24);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(25);
        }
        return this.addAction(action, constraint, arg_0 -> ((ActionManager)actionManager).getId(arg_0));
    }

    @ApiStatus.Internal
    @NotNull
    public final synchronized ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull @NotNull Function<@NotNull AnAction, @Nullable String> actionToId) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(26);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(27);
        }
        if (actionToId == null) {
            DefaultActionGroup.$$$reportNull$$$0(28);
        }
        if (action == this) {
            throw this.newThisGroupToItselfAddedException();
        }
        if (!(action instanceof Separator) && this.containsAction(action)) {
            LOG.error((Throwable)DefaultActionGroup.newDuplicateActionAddedException(action));
            this.remove(action, actionToId.apply(action));
        }
        constraint = (Constraints)constraint.clone();
        if (constraint.myAnchor == Anchor.FIRST) {
            this.mySortedChildren.add(0, action);
        } else if (constraint.myAnchor == Anchor.LAST) {
            this.mySortedChildren.add(action);
        } else {
            this.myPendingActions.add(action);
        }
        this.myConstraints.put(action, constraint);
        this.addAllToSortedList(actionToId);
        this.incrementModificationStamp();
        return new ActionInGroup(this, action);
    }

    public synchronized boolean containsAction(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(29);
        }
        return this.mySortedChildren.contains(action) || this.myPendingActions.contains(action);
    }

    private void addAllToSortedList(@NotNull @NotNull Function<@NotNull AnAction, @Nullable String> actionToId) {
        if (actionToId == null) {
            DefaultActionGroup.$$$reportNull$$$0(30);
        }
        block0: while (!this.myPendingActions.isEmpty()) {
            for (int i = 0; i < this.myPendingActions.size(); ++i) {
                AnAction pendingAction = this.myPendingActions.get(i);
                Constraints constraints = this.myConstraints.get(pendingAction);
                if (constraints == null || !this.addToSortedList(pendingAction, constraints, actionToId)) continue;
                this.myPendingActions.remove(i);
                continue block0;
            }
        }
    }

    private boolean addToSortedList(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull @NotNull Function<@NotNull AnAction, @Nullable String> actionToId) {
        String relativeToActionId;
        int index;
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(31);
        }
        if (constraint == null) {
            DefaultActionGroup.$$$reportNull$$$0(32);
        }
        if (actionToId == null) {
            DefaultActionGroup.$$$reportNull$$$0(33);
        }
        int n = index = (relativeToActionId = constraint.myRelativeToActionId) == null ? -1 : DefaultActionGroup.findIndex(relativeToActionId, this.mySortedChildren, actionToId);
        if (index == -1) {
            return false;
        }
        if (constraint.myAnchor == Anchor.BEFORE) {
            this.mySortedChildren.add(index, action);
        } else {
            this.mySortedChildren.add(index + 1, action);
        }
        return true;
    }

    private static int findIndex(@NotNull String actionId, @NotNull List<? extends AnAction> actions, @NotNull @NotNull Function<@NotNull AnAction, @Nullable String> actionToId) {
        if (actionId == null) {
            DefaultActionGroup.$$$reportNull$$$0(34);
        }
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(35);
        }
        if (actionToId == null) {
            DefaultActionGroup.$$$reportNull$$$0(36);
        }
        for (int i = 0; i < actions.size(); ++i) {
            String id;
            AnAction action = actions.get(i);
            if (!(action instanceof ActionStub ? ((ActionStub)action).getId().equals(actionId) : (id = actionToId.apply(action)) != null && id.equals(actionId))) continue;
            return i;
        }
        return -1;
    }

    public final void remove(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(37);
        }
        this.remove(action, ActionManager.getInstance());
    }

    public final void remove(@NotNull AnAction action, @NotNull ActionManager actionManager) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(38);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(39);
        }
        this.remove(action, actionManager.getId(action));
    }

    public final synchronized void remove(@NotNull AnAction action, @Nullable String id) {
        Predicate<AnAction> matchesAction;
        boolean removed;
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(40);
        }
        removed = (removed = this.mySortedChildren.removeIf(matchesAction = o -> {
            ActionStubBase stub;
            return o.equals(action) || o instanceof ActionStubBase && (stub = (ActionStubBase)o).getId().equals(id);
        })) || this.myPendingActions.removeIf(matchesAction);
        this.myConstraints.keySet().removeIf(matchesAction);
        if (removed) {
            this.incrementModificationStamp();
        }
    }

    public final synchronized void removeAll() {
        this.mySortedChildren.clear();
        this.myPendingActions.clear();
        this.myConstraints.clear();
        this.incrementModificationStamp();
    }

    public synchronized boolean replaceAction(@NotNull AnAction oldAction, @NotNull AnAction newAction) {
        int index;
        if (oldAction == null) {
            DefaultActionGroup.$$$reportNull$$$0(41);
        }
        if (newAction == null) {
            DefaultActionGroup.$$$reportNull$$$0(42);
        }
        if ((index = this.mySortedChildren.indexOf(oldAction)) >= 0) {
            this.mySortedChildren.set(index, newAction);
            this.replaceConstraint(oldAction, newAction);
            this.incrementModificationStamp();
            return true;
        }
        int indexOld = this.myPendingActions.indexOf(oldAction);
        if (indexOld >= 0) {
            this.myPendingActions.set(indexOld, newAction);
            this.replaceConstraint(oldAction, newAction);
            this.incrementModificationStamp();
            return true;
        }
        return false;
    }

    private void replaceConstraint(AnAction oldAction, AnAction newAction) {
        Constraints constraint = this.myConstraints.get(oldAction);
        if (constraint != null) {
            this.myConstraints.put(newAction, constraint);
            this.myConstraints.remove(oldAction);
        }
    }

    public synchronized void copyFromGroup(@NotNull DefaultActionGroup other) {
        if (other == null) {
            DefaultActionGroup.$$$reportNull$$$0(43);
        }
        this.copyFrom((AnAction)other);
        this.setPopup(other.isPopup());
        this.mySortedChildren.clear();
        this.mySortedChildren.addAll(other.mySortedChildren);
        this.myPendingActions.clear();
        this.myPendingActions.addAll(other.myPendingActions);
        this.myConstraints.clear();
        this.myConstraints.putAll(other.myConstraints);
        this.incrementModificationStamp();
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            DefaultActionGroup.reportGetChildrenForNullEvent();
        }
        return this.getChildren(e != null ? e.getActionManager() : ActionManager.getInstance());
    }

    private static void reportGetChildrenForNullEvent() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LOG.error("Do not call `getChildren(null)`. Do not expand action groups manually. Reuse `AnActionEvent.updateSession` by composing, wrapping, and postprocessing action groups. Otherwise, use `getChildActionsOrStubs()` or `getChildren(ActionManager)`");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final AnAction @NotNull [] getChildren(@NotNull ActionManager actionManager) {
        Map<ActionStubBase, AnAction> stubMap;
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(44);
        }
        DefaultActionGroup defaultActionGroup = this;
        // MONITORENTER : defaultActionGroup
        int modCount = this.myModificationStamp;
        AnAction[] actionOrStubs = this.getChildActionsOrStubs();
        // MONITOREXIT : defaultActionGroup
        while (true) {
            stubMap = null;
            boolean hasNulls = false;
            for (AnAction o : actionOrStubs) {
                hasNulls |= o == null;
                if (!(o instanceof ActionStubBase)) continue;
                ActionStubBase stub = (ActionStubBase)o;
                try {
                    AnAction action = actionManager.getAction(stub.getId());
                    if (action == null) continue;
                    if (stubMap == null) {
                        stubMap = new HashMap<ActionStubBase, AnAction>();
                    }
                    stubMap.put(stub, action);
                }
                catch (ProcessCanceledException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    LOG.error(ex);
                }
            }
            if (stubMap == null && !hasNulls) {
                if (actionOrStubs != null) return actionOrStubs;
                DefaultActionGroup.$$$reportNull$$$0(45);
                return actionOrStubs;
            }
            DefaultActionGroup defaultActionGroup2 = this;
            // MONITORENTER : defaultActionGroup2
            if (modCount == this.myModificationStamp) break;
            modCount = this.myModificationStamp;
            actionOrStubs = this.getChildActionsOrStubs();
            // MONITOREXIT : defaultActionGroup2
        }
        this.replaceStubsAndNulls(stubMap != null ? stubMap : Collections.emptyMap());
        AnAction[] anActionArray = this.getChildActionsOrStubs();
        // MONITOREXIT : defaultActionGroup2
        if (anActionArray != null) return anActionArray;
        DefaultActionGroup.$$$reportNull$$$0(46);
        return anActionArray;
    }

    private synchronized void replaceStubsAndNulls(@NotNull Map<ActionStubBase, AnAction> stubMap) {
        AnAction replacement;
        AnAction action;
        if (stubMap == null) {
            DefaultActionGroup.$$$reportNull$$$0(47);
        }
        ListIterator<AnAction> it = this.mySortedChildren.listIterator();
        while (it.hasNext()) {
            action = it.next();
            if (action == null) {
                LOG.error("Empty sorted child: " + String.valueOf((Object)this) + ", " + String.valueOf(((Object)((Object)this)).getClass()) + "; index=" + it.previousIndex());
                it.remove();
                continue;
            }
            if (!(action instanceof ActionStubBase)) continue;
            replacement = stubMap.get((ActionStubBase)action);
            if (replacement != null) {
                it.set(replacement);
                this.replaceConstraint(action, replacement);
                this.replace(action, replacement);
                continue;
            }
            this.myConstraints.remove(action);
            it.remove();
        }
        it = this.myPendingActions.listIterator();
        while (it.hasNext()) {
            action = it.next();
            if (action == null) {
                LOG.error("Empty pair child: " + String.valueOf((Object)this) + ", " + String.valueOf(((Object)((Object)this)).getClass()) + "; index=" + it.previousIndex());
                it.remove();
                continue;
            }
            if (!(action instanceof ActionStubBase)) continue;
            replacement = stubMap.get((ActionStubBase)action);
            if (replacement != null) {
                it.set(replacement);
                this.replaceConstraint(action, replacement);
                this.replace(action, replacement);
                continue;
            }
            this.myConstraints.remove(action);
            it.remove();
        }
    }

    public final synchronized int getChildrenCount() {
        return this.mySortedChildren.size() + this.myPendingActions.size();
    }

    public final synchronized AnAction @NotNull [] getChildActionsOrStubs() {
        int i;
        int sortedSize = this.mySortedChildren.size();
        AnAction[] children = new AnAction[sortedSize + this.myPendingActions.size()];
        for (i = 0; i < sortedSize; ++i) {
            children[i] = this.mySortedChildren.get(i);
        }
        for (i = 0; i < this.myPendingActions.size(); ++i) {
            children[i + sortedSize] = this.myPendingActions.get(i);
        }
        if (children == null) {
            DefaultActionGroup.$$$reportNull$$$0(48);
        }
        return children;
    }

    @Deprecated
    public final void addAll(@NotNull ActionGroup group) {
        AnAction[] anActionArray;
        if (group == null) {
            DefaultActionGroup.$$$reportNull$$$0(49);
        }
        if (group instanceof DefaultActionGroup) {
            DefaultActionGroup o = (DefaultActionGroup)group;
            anActionArray = o.getChildActionsOrStubs();
        } else {
            anActionArray = group.getChildren(null);
        }
        this.addAll(anActionArray);
    }

    public final void addAll(@NotNull Collection<? extends AnAction> actionList) {
        if (actionList == null) {
            DefaultActionGroup.$$$reportNull$$$0(50);
        }
        this.addAll(actionList, ActionManager.getInstance());
    }

    public final void addAll(@NotNull Collection<? extends AnAction> actionList, @NotNull ActionManager actionManager) {
        if (actionList == null) {
            DefaultActionGroup.$$$reportNull$$$0(51);
        }
        if (actionManager == null) {
            DefaultActionGroup.$$$reportNull$$$0(52);
        }
        if (actionList.isEmpty()) {
            return;
        }
        for (AnAction anAction2 : actionList) {
            this.addAction(anAction2, Constraints.LAST, actionManager);
        }
    }

    public final void addAll(AnAction ... actions) {
        if (actions == null) {
            DefaultActionGroup.$$$reportNull$$$0(53);
        }
        if (actions.length == 0) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        for (AnAction action : actions) {
            this.addAction(action, Constraints.LAST, actionManager);
        }
    }

    public void addSeparator(@NlsContexts.Separator @Nullable String separatorText) {
        this.add(Separator.create(separatorText));
    }

    @Nullable
    public synchronized Constraints getConstraints(@NotNull AnAction action) {
        if (action == null) {
            DefaultActionGroup.$$$reportNull$$$0(54);
        }
        return this.myConstraints.get(action);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 45, 46, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 31: 
            case 37: 
            case 38: 
            case 40: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 13: 
            case 22: 
            case 25: 
            case 39: 
            case 44: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 28: 
            case 30: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionToId";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldAction";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAction";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 45: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/DefaultActionGroup";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubMap";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/DefaultActionGroup";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildActionsOrStubs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPopupGroup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFlatGroup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newDuplicateActionAddedException";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "containsAction";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addAllToSortedList";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addToSortedList";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findIndex";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "replaceAction";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "copyFromGroup";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 45: 
            case 46: 
            case 48: {
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "replaceStubsAndNulls";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getConstraints";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 45, 46, 48 -> new IllegalStateException(string);
        };
    }
}

