/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.TextRange;
import java.awt.datatransfer.Transferable;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorCopyPasteHelper {
    public static final String TRIM_TEXT_ON_PASTE_KEY = "trimTextOnPaste";

    public static EditorCopyPasteHelper getInstance() {
        return (EditorCopyPasteHelper)ApplicationManager.getApplication().getService(EditorCopyPasteHelper.class);
    }

    public void copySelectionToClipboard(@NotNull Editor editor) {
        Transferable transferable;
        if (editor == null) {
            EditorCopyPasteHelper.$$$reportNull$$$0(0);
        }
        if ((transferable = this.getSelectionTransferable(editor, CopyPasteOptions.DEFAULT)) != null) {
            CopyPasteManager.getInstance().setContents(transferable);
        }
    }

    @Nullable
    public abstract Transferable getSelectionTransferable(@NotNull Editor var1, @NotNull CopyPasteOptions var2);

    public abstract TextRange @Nullable [] pasteFromClipboard(@NotNull Editor var1) throws TooLargeContentException;

    public abstract TextRange @Nullable [] pasteTransferable(@NotNull Editor var1, @NotNull Transferable var2) throws TooLargeContentException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/EditorCopyPasteHelper", "copySelectionToClipboard"));
    }

    public record CopyPasteOptions(boolean isCopiedFromEmptySelection) implements Serializable
    {
        @NotNull
        public static final CopyPasteOptions DEFAULT = new CopyPasteOptions(false);
    }

    public static class TooLargeContentException
    extends RuntimeException {
        private final int contentLength;

        public TooLargeContentException(int contentLength) {
            this.contentLength = contentLength;
        }

        public int getContentLength() {
            return this.contentLength;
        }
    }
}

