/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTypedHandlerBean;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actionSystem.TypedActionHandlerEx;
import com.intellij.openapi.editor.rd.LocalEditorSupportUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.SlowOperations;
import java.lang.reflect.Constructor;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypedAction {
    private static final ExtensionPointName<EditorTypedHandlerBean> EP_NAME = new ExtensionPointName("com.intellij.editorTypedHandler");
    private static final ExtensionPointName<EditorTypedHandlerBean> RAW_EP_NAME = new ExtensionPointName("com.intellij.rawEditorTypedHandler");
    private TypedActionHandler myRawHandler;
    @NotNull
    private TypedActionHandler myHandler = new Handler();
    private boolean myHandlersLoaded;

    public static TypedAction getInstance() {
        return (TypedAction)ApplicationManager.getApplication().getService(TypedAction.class);
    }

    private void ensureHandlersLoaded() {
        if (this.myHandlersLoaded) {
            return;
        }
        this.myHandlersLoaded = true;
        EP_NAME.processWithPluginDescriptor((bean, pluginDescriptor) -> {
            TypedActionHandler handler = TypedAction.getOrCreateHandler(bean, this.myHandler, pluginDescriptor);
            if (handler != null) {
                this.myHandler = handler;
            }
            return Unit.INSTANCE;
        });
    }

    @Nullable
    private static TypedActionHandler getOrCreateHandler(EditorTypedHandlerBean bean, TypedActionHandler originalHandler, PluginDescriptor pluginDescriptor) {
        TypedActionHandler handler = bean.handler;
        if (handler != null) {
            return handler;
        }
        try {
            Constructor constructor;
            Class aClass = ApplicationManager.getApplication().loadClass(bean.implementationClass, pluginDescriptor);
            try {
                constructor = aClass.getDeclaredConstructor(TypedActionHandler.class);
            }
            catch (NoSuchMethodException ignore) {
                constructor = null;
            }
            if (constructor == null) {
                constructor = aClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                bean.handler = (TypedActionHandler)constructor.newInstance(new Object[0]);
            } else {
                constructor.setAccessible(true);
                bean.handler = (TypedActionHandler)constructor.newInstance(originalHandler);
            }
            return bean.handler;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (PluginException e) {
            Logger.getInstance(TypedAction.class).error((Throwable)e);
            return null;
        }
        catch (Exception e) {
            Logger.getInstance(TypedAction.class).error((Throwable)new PluginException((Throwable)e, pluginDescriptor.getPluginId()));
            return null;
        }
    }

    private void loadRawHandlers() {
        RAW_EP_NAME.processWithPluginDescriptor((bean, pluginDescriptor) -> {
            TypedActionHandler handler = TypedAction.getOrCreateHandler(bean, this.myRawHandler, pluginDescriptor);
            if (handler != null) {
                this.myRawHandler = handler;
            }
            return Unit.INSTANCE;
        });
    }

    @NotNull
    public TypedActionHandler getHandler() {
        this.ensureHandlersLoaded();
        TypedActionHandler typedActionHandler = this.myHandler;
        if (typedActionHandler == null) {
            TypedAction.$$$reportNull$$$0(0);
        }
        return typedActionHandler;
    }

    @Deprecated
    @NotNull
    public TypedActionHandler setupHandler(@NotNull TypedActionHandler handler) {
        if (handler == null) {
            TypedAction.$$$reportNull$$$0(1);
        }
        this.ensureHandlersLoaded();
        TypedActionHandler tmp = this.myHandler;
        this.myHandler = handler;
        TypedActionHandler typedActionHandler = tmp;
        if (typedActionHandler == null) {
            TypedAction.$$$reportNull$$$0(2);
        }
        return typedActionHandler;
    }

    @NotNull
    public TypedActionHandler getRawHandler() {
        TypedActionHandler typedActionHandler = this.myRawHandler;
        if (typedActionHandler == null) {
            TypedAction.$$$reportNull$$$0(3);
        }
        return typedActionHandler;
    }

    public TypedActionHandler setupRawHandler(@NotNull TypedActionHandler handler) {
        if (handler == null) {
            TypedAction.$$$reportNull$$$0(4);
        }
        TypedActionHandler tmp = this.myRawHandler;
        this.myRawHandler = handler;
        if (tmp == null) {
            this.loadRawHandlers();
        }
        return tmp;
    }

    public void beforeActionPerformed(@NotNull Editor editor, char c, @NotNull DataContext context, @NotNull ActionPlan plan) {
        if (editor == null) {
            TypedAction.$$$reportNull$$$0(5);
        }
        if (context == null) {
            TypedAction.$$$reportNull$$$0(6);
        }
        if (plan == null) {
            TypedAction.$$$reportNull$$$0(7);
        }
        LocalEditorSupportUtil.assertLocalEditorSupport((Editor)editor);
        if (this.myRawHandler instanceof TypedActionHandlerEx) {
            ((TypedActionHandlerEx)this.myRawHandler).beforeExecute(editor, c, context, plan);
        }
    }

    public final void actionPerformed(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        if (editor == null) {
            TypedAction.$$$reportNull$$$0(8);
        }
        if (dataContext == null) {
            TypedAction.$$$reportNull$$$0(9);
        }
        LocalEditorSupportUtil.assertLocalEditorSupport((Editor)editor);
        try (AccessToken ignored = SlowOperations.startSection((String)"action.perform");){
            this.myRawHandler.execute(editor, charTyped, dataContext);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actionSystem/TypedAction";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plan";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actionSystem/TypedAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setupHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupHandler";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupRawHandler";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }

    private static final class Handler
    implements TypedActionHandler {
        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (!EditorModificationUtil.checkModificationAllowed(editor)) {
                return;
            }
            Document doc = editor.getDocument();
            doc.startGuardedBlockChecking();
            try {
                String str = String.valueOf(charTyped);
                CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message("typing.in.editor.command.name", new Object[0]));
                EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true);
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
            }
            finally {
                doc.stopGuardedBlockChecking();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actionSystem/TypedAction$Handler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

