/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class MasterDetailsComponent
implements Configurable,
DetailsComponent.Facade,
MasterDetails {
    protected static final Logger LOG = Logger.getInstance(MasterDetailsComponent.class);
    protected static final Icon COPY_ICON = PlatformIcons.COPY_ICON;
    protected NamedConfigurable myCurrentConfigurable;
    private final JBSplitter mySplitter;
    @NonNls
    public static final String TREE_OBJECT = "treeObject";
    @NonNls
    public static final String TREE_NAME = "treeName";
    protected History myHistory = new History(new Place.Navigator(){

        @Override
        public void setHistory(History history) {
            MasterDetailsComponent.this.myHistory = history;
        }
    });
    private JComponent myMaster;
    protected final MasterDetailsState myState;
    protected final Runnable TREE_UPDATER = new Runnable(){

        @Override
        public void run() {
            TreePath selectionPath = MasterDetailsComponent.this.myTree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            MyNode node = (MyNode)selectionPath.getLastPathComponent();
            if (node == null) {
                return;
            }
            MasterDetailsComponent.this.myState.setLastEditedConfigurable(MasterDetailsComponent.getNodePathString(node));
            NamedConfigurable configurable = node.getConfigurable();
            if (configurable != null) {
                MasterDetailsComponent.this.myDetails.setText(configurable.getBannerSlogan());
            }
            node.reloadNode((DefaultTreeModel)MasterDetailsComponent.this.myTree.getModel());
            MasterDetailsComponent.this.fireItemsChangedExternally();
        }
    };
    protected MyNode myRoot = new MyRootNode();
    protected Tree myTree = new Tree();
    private final DetailsComponent myDetails = new DetailsComponent(false, false);
    protected JPanel myWholePanel;
    public JPanel myNorthPanel = new JPanel(new BorderLayout());
    private final List<ItemsChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<NamedConfigurable> myInitializedConfigurables = new HashSet<NamedConfigurable>();
    private boolean myHasDeletedItems;
    protected AutoScrollToSourceHandler myAutoScrollHandler;
    protected boolean myToReInitWholePanel = true;

    public void setHistory(History history) {
        this.myHistory = history;
    }

    protected MasterDetailsComponent() {
        this(new MasterDetailsState());
    }

    protected MasterDetailsComponent(@Nullable MasterDetailsState state) {
        this.myState = state == null ? new MasterDetailsState() : state;
        this.mySplitter = new OnePixelSplitter(false, 0.2f);
        this.mySplitter.setSplitterProportionKey("ProjectStructure.SecondLevelElements");
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.installAutoScroll();
    }

    protected void reInitWholePanelIfNeeded() {
        if (!this.myToReInitWholePanel) {
            return;
        }
        this.myWholePanel = new NonOpaquePanel(new BorderLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                MasterDetailsComponent.this.addNotify();
                TreeModel m = MasterDetailsComponent.this.myTree.getModel();
                if (m instanceof DefaultTreeModel) {
                    DefaultTreeModel model = (DefaultTreeModel)m;
                    for (int eachRow = 0; eachRow < MasterDetailsComponent.this.myTree.getRowCount(); ++eachRow) {
                        TreePath eachPath = MasterDetailsComponent.this.myTree.getPathForRow(eachRow);
                        Object component = eachPath.getLastPathComponent();
                        if (!(component instanceof TreeNode)) continue;
                        model.nodeChanged((TreeNode)component);
                    }
                }
            }
        };
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.myWholePanel.add((Component)((Object)this.mySplitter), "Center");
        JPanel left = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension original = super.getMinimumSize();
                return new Dimension(Math.max(original.width, 100), original.height);
            }
        };
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myTree).setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder((Border)JBUI.Borders.empty()).setScrollPaneBorder((Border)JBUI.Borders.empty());
        List<AnAction> actions = this.createToolbarActions();
        if (actions != null) {
            for (AnAction action : actions) {
                decorator.addExtraAction(action);
            }
        }
        this.myMaster = decorator.createPanel();
        this.myNorthPanel.setVisible(false);
        left.add((Component)this.myMaster, "Center");
        this.mySplitter.setFirstComponent(left);
        NonOpaquePanel right = new NonOpaquePanel(new BorderLayout());
        right.add((Component)this.myDetails.getComponent(), "Center");
        this.mySplitter.setSecondComponent(right);
        GuiUtils.replaceJSplitPaneWithIDEASplitter(this.myWholePanel);
        this.myToReInitWholePanel = false;
    }

    private void installAutoScroll() {
        this.myAutoScrollHandler = new AutoScrollToSourceHandler(){

            @Override
            protected boolean isAutoScrollMode() {
                return MasterDetailsComponent.this.isAutoScrollEnabled();
            }

            @Override
            protected void setAutoScrollMode(boolean state) {
            }

            @Override
            @RequiresEdt
            protected void scrollToSource(@NotNull Component tree) {
                if (tree == null) {
                    5.$$$reportNull$$$0(0);
                }
                ThreadingAssertions.assertEventDispatchThread();
                MasterDetailsComponent.this.updateSelectionFromTree();
            }

            @Override
            protected boolean needToCheckFocus() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/ui/MasterDetailsComponent$5", "scrollToSource"));
            }
        };
        this.myAutoScrollHandler.install(this.myTree);
    }

    protected void addNotify() {
        this.updateSelectionFromTree();
    }

    private void updateSelectionFromTree() {
        TreePath path;
        TreePath[] treePaths = this.myTree.getSelectionPaths();
        if (treePaths != null) {
            ArrayList<NamedConfigurable> selectedConfigurables = new ArrayList<NamedConfigurable>();
            for (TreePath path2 : treePaths) {
                Object lastPathComponent = path2.getLastPathComponent();
                if (!(lastPathComponent instanceof MyNode)) continue;
                selectedConfigurables.add(((MyNode)lastPathComponent).getConfigurable());
            }
            if (selectedConfigurables.size() > 1 && this.updateMultiSelection(selectedConfigurables)) {
                return;
            }
        }
        if ((path = this.myTree.getSelectionPath()) != null) {
            Object lastPathComp = path.getLastPathComponent();
            if (!(lastPathComp instanceof MyNode)) {
                return;
            }
            MyNode node = (MyNode)lastPathComp;
            this.setSelectedNode(node);
        } else {
            this.setSelectedNode(null);
        }
    }

    protected boolean updateMultiSelection(List<? extends NamedConfigurable> selectedConfigurables) {
        return false;
    }

    @Override
    public DetailsComponent getDetailsComponent() {
        return this.myDetails;
    }

    public Splitter getSplitter() {
        return this.mySplitter;
    }

    protected boolean isAutoScrollEnabled() {
        return this.myHistory == null || !this.myHistory.isNavigatingNow();
    }

    @Nullable
    protected @Unmodifiable List<AnAction> createToolbarActions() {
        List<AnAction> actions = this.createActions(false);
        if (actions == null) {
            return null;
        }
        return ContainerUtil.map(actions, o -> {
            AnAction anAction2;
            if (o instanceof ActionGroupWithPreselection) {
                ActionGroupWithPreselection oo = (ActionGroupWithPreselection)o;
                anAction2 = new MyActionGroupWrapper(oo);
            } else {
                anAction2 = o;
            }
            return anAction2;
        });
    }

    public void addItemsChangeListener(ItemsChangeListener l) {
        this.myListeners.add(l);
    }

    protected Dimension getPanelPreferredSize() {
        return JBUI.size((int)800, (int)600);
    }

    @NotNull
    public JComponent createComponent() {
        this.myTree.updateUI();
        this.reInitWholePanelIfNeeded();
        this.updateSelectionFromTree();
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                return MasterDetailsComponent.this.getPanelPreferredSize();
            }
        };
        panel2.add((Component)this.myWholePanel, "Center");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            MasterDetailsComponent.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public boolean isModified() {
        if (this.myHasDeletedItems) {
            return true;
        }
        return TreeUtil.treeNodeTraverser(this.myRoot).traverse().filterMap(node -> node instanceof MyNode ? ((MyNode)node).getConfigurable() : null).filter(configurable -> this.isInitialized((NamedConfigurable)configurable) && configurable.isModified()).isNotEmpty();
    }

    protected boolean isInitialized(NamedConfigurable configurable) {
        return this.myInitializedConfigurables.contains(configurable);
    }

    public void apply() throws ConfigurationException {
        this.processRemovedItems();
        for (MyNode node : TreeUtil.treeNodeTraverser(this.myRoot).filter(MyNode.class)) {
            NamedConfigurable configurable = node.getConfigurable();
            if (!this.isInitialized(configurable) || !configurable.isModified()) continue;
            configurable.apply();
        }
        this.myHasDeletedItems = false;
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    public void reset() {
        this.loadComponentState();
        this.myHasDeletedItems = false;
        ((DefaultTreeModel)this.myTree.getModel()).reload();
        this.myState.getProportions().restoreSplitterProportions(this.myWholePanel);
        this.restoreLastSelection();
    }

    protected final void restoreLastSelection() {
        Enumeration<TreeNode> enumeration = this.myRoot.breadthFirstEnumeration();
        boolean selected2 = false;
        while (enumeration.hasMoreElements()) {
            MyNode node = (MyNode)enumeration.nextElement();
            if (node instanceof MyRootNode) continue;
            String path = MasterDetailsComponent.getNodePathString(node);
            if (selected2 || !Comparing.strEqual((String)path, (String)this.myState.getLastEditedConfigurable())) continue;
            TreeUtil.selectInTree(node, false, this.myTree);
            selected2 = true;
        }
        if (!selected2) {
            TreeUtil.promiseSelectFirst(this.myTree);
        }
        if (this.myWholePanel != null && this.myWholePanel.isShowing()) {
            this.updateSelectionFromTree();
        }
    }

    protected void loadComponentState() {
        MasterDetailsState state;
        String key = this.getComponentStateKey();
        MasterDetailsStateService stateService = this.getStateService();
        if (key != null && stateService != null && (state = stateService.getComponentState(key, this.myState.getClass())) != null) {
            this.loadState(state);
        }
    }

    @NonNls
    private static String getNodePathString(MyNode node) {
        String displayName;
        Object userObject;
        @NonNls StringBuilder path = new StringBuilder();
        MyNode current = node;
        while (current != null && (userObject = current.getUserObject()) instanceof NamedConfigurable && !StringUtil.isEmptyOrSpaces((String)(displayName = current.getDisplayName()))) {
            if (!path.isEmpty()) {
                path.append('|');
            }
            path.append(displayName);
            TreeNode parent = current.getParent();
            if (!(parent instanceof MyNode)) break;
            current = (MyNode)parent;
        }
        return path.toString();
    }

    @Nullable
    @NonNls
    protected String getComponentStateKey() {
        return null;
    }

    @Nullable
    protected MasterDetailsStateService getStateService() {
        return null;
    }

    protected MasterDetailsState getState() {
        return this.myState;
    }

    protected void loadState(MasterDetailsState object) {
        XmlSerializerUtil.copyBean((Object)object, (Object)this.myState);
    }

    public void disposeUIResources() {
        this.myState.getProportions().saveSplitterProportions(this.myWholePanel);
        this.myAutoScrollHandler.cancelAllRequests();
        this.myDetails.disposeUIResources();
        this.myInitializedConfigurables.clear();
        this.clearChildren();
        String key = this.getComponentStateKey();
        MasterDetailsStateService stateService = this.getStateService();
        if (key != null && stateService != null) {
            stateService.setComponentState(key, this.getState());
        }
        this.myCurrentConfigurable = null;
    }

    protected void clearChildren() {
        for (MyNode node : TreeUtil.treeNodeTraverser(this.myRoot).filter(MyNode.class)) {
            node.getConfigurable().disposeUIResources();
            if (node instanceof MyRootNode) continue;
            node.setUserObject(null);
        }
        this.myRoot.removeAllChildren();
    }

    @Nullable
    protected List<AnAction> createActions(boolean fromPopup) {
        return null;
    }

    protected void initTree() {
        ((DefaultTreeModel)this.myTree.getModel()).setRoot(this.myRoot);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        TreeUtil.installActions(this.myTree);
        this.myTree.setCellRenderer(new MyColoredTreeCellRenderer());
        List<AnAction> actions = this.createActions(true);
        if (actions != null) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (AnAction action : actions) {
                group.add(action);
            }
            actions = this.getAdditionalActions();
            if (actions != null) {
                group.addSeparator();
                for (AnAction action : actions) {
                    group.add(action);
                }
            }
            PopupHandler.installPopupMenu((JComponent)this.myTree, group, "MasterDetailsTreePopup");
        }
    }

    @Nullable
    protected ArrayList<AnAction> getAdditionalActions() {
        return null;
    }

    private void fireItemsChangeListener(Object editableObject) {
        for (ItemsChangeListener listener2 : this.myListeners) {
            listener2.itemChanged(editableObject);
        }
    }

    private void fireItemsChangedExternally() {
        for (ItemsChangeListener listener2 : this.myListeners) {
            listener2.itemsExternallyChanged();
        }
    }

    private void createUIComponents() {
        this.myTree = new Tree(){

            @Override
            public JToolTip createToolTip() {
                JToolTip toolTip = new JToolTip(){
                    {
                        this.setUI(new MultiLineTooltipUI());
                    }
                };
                toolTip.setComponent(this);
                return toolTip;
            }
        };
    }

    protected void addNode(MyNode nodeToAdd, MyNode parent) {
        int i = TreeUtil.indexedBinarySearch(parent, nodeToAdd, this.getNodeComparator());
        int insertionPoint = i >= 0 ? i : -i - 1;
        ((DefaultTreeModel)this.myTree.getModel()).insertNodeInto(nodeToAdd, parent, insertionPoint);
    }

    protected void sortDescendants(MyNode root) {
        TreeUtil.sortRecursively(root, this.getNodeComparator());
        ((DefaultTreeModel)this.myTree.getModel()).reload(root);
    }

    protected Comparator<MyNode> getNodeComparator() {
        return (o1, o2) -> StringUtil.naturalCompare((String)o1.getDisplayName(), (String)o2.getDisplayName());
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect) {
        return this.selectNodeInTree(nodeToSelect, true, false);
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect, boolean requestFocus) {
        return this.selectNodeInTree(nodeToSelect, true, requestFocus);
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect, boolean center, boolean requestFocus) {
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTree, true));
        }
        if (nodeToSelect != null) {
            return TreeUtil.selectInTree(nodeToSelect, requestFocus, this.myTree, center);
        }
        return TreeUtil.selectFirstNode(this.myTree);
    }

    @Nullable
    public Object getSelectedObject() {
        Object object;
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null && (object = selectionPath.getLastPathComponent()) instanceof MyNode) {
            MyNode node = (MyNode)object;
            NamedConfigurable configurable = node.getConfigurable();
            if (configurable == null) {
                LOG.error("already disposed");
            }
            return configurable == null ? null : configurable.getEditableObject();
        }
        return null;
    }

    public final MyNode getSelectedNode() {
        TreePath path = this.myTree.getSelectionPath();
        return path != null ? (MyNode)path.getLastPathComponent() : null;
    }

    @Nullable
    public NamedConfigurable getSelectedConfigurable() {
        MyNode selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            NamedConfigurable configurable = selectedNode.getConfigurable();
            LOG.assertTrue(configurable != null, (Object)"already disposed");
            return configurable;
        }
        return null;
    }

    public void selectNodeInTree(@NlsSafe String displayName) {
        MyNode nodeByName = MasterDetailsComponent.findNodeByName(this.myRoot, displayName);
        this.selectNodeInTree(nodeByName, true);
    }

    public void selectNodeInTree(Object object) {
        this.selectNodeInTree(MasterDetailsComponent.findNodeByObject(this.myRoot, object), true);
    }

    @Nullable
    protected static MyNode findNodeByName(TreeNode root, String profileName) {
        if (profileName == null) {
            return null;
        }
        return MasterDetailsComponent.findNodeByCondition(root, (Condition<? super NamedConfigurable>)((Condition)configurable -> Comparing.strEqual((String)profileName, (String)configurable.getDisplayName())));
    }

    @Nullable
    public static MyNode findNodeByObject(TreeNode root, Object editableObject) {
        if (editableObject == null) {
            return null;
        }
        return MasterDetailsComponent.findNodeByCondition(root, (Condition<? super NamedConfigurable>)((Condition)configurable -> Comparing.equal((Object)editableObject, configurable.getEditableObject())));
    }

    protected static MyNode findNodeByCondition(TreeNode root, Condition<? super NamedConfigurable> condition) {
        return (MyNode)TreeUtil.treeNodeTraverser(root).filter(MyNode.class).filter(node -> condition.value((Object)node.getConfigurable())).first();
    }

    protected void setSelectedNode(@Nullable MyNode node) {
        if (node != null) {
            this.myState.setLastEditedConfigurable(MasterDetailsComponent.getNodePathString(node));
        }
        this.updateSelection(node != null ? node.getConfigurable() : null);
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        this.myDetails.setText(configurable != null ? configurable.getBannerSlogan() : null);
        this.myCurrentConfigurable = configurable;
        if (configurable != null) {
            JComponent comp = configurable.createComponent();
            if (comp == null) {
                this.setEmpty();
                LOG.error("createComponent() returned null. configurable=" + String.valueOf(configurable));
            } else {
                this.myDetails.setContent(comp);
                this.ensureInitialized(configurable);
                this.myHistory.pushPlaceForElement(TREE_OBJECT, configurable.getEditableObject());
            }
        } else {
            this.setEmpty();
        }
    }

    public void ensureInitialized(NamedConfigurable configurable) {
        if (!this.isInitialized(configurable)) {
            configurable.reset();
            this.initializeConfigurable(configurable);
        }
    }

    private void setEmpty() {
        this.myDetails.setContent(null);
        this.myDetails.setEmptyContentText(this.getEmptySelectionString());
    }

    public String getHelpTopic() {
        if (this.myCurrentConfigurable != null) {
            return this.myCurrentConfigurable.getHelpTopic();
        }
        return null;
    }

    @NlsContexts.StatusText
    @Nullable
    protected String getEmptySelectionString() {
        return null;
    }

    protected void initializeConfigurable(NamedConfigurable configurable) {
        this.myInitializedConfigurables.add(configurable);
    }

    protected final void checkForEmptyAndDuplicatedNames(String prefix, String title, Class<? extends NamedConfigurable<?>> configurableClass) throws ConfigurationException {
        this.checkForEmptyAndDuplicatedNames(this.myRoot, prefix, title, configurableClass, true);
    }

    private void checkForEmptyAndDuplicatedNames(MyNode rootNode, String prefix, String title, Class<? extends NamedConfigurable<?>> configurableClass, boolean recursively) throws ConfigurationException {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            MyNode node = (MyNode)rootNode.getChildAt(i);
            NamedConfigurable scopeConfigurable = node.getConfigurable();
            if (configurableClass.isInstance(scopeConfigurable)) {
                String name = scopeConfigurable.getDisplayName();
                if (name.trim().isEmpty()) {
                    this.selectNodeInTree(node);
                    throw new ConfigurationException(UIBundle.message("master.detail.err.empty.name", new Object[0]));
                }
                if (names.contains(name)) {
                    NamedConfigurable selectedConfigurable = this.getSelectedConfigurable();
                    if (selectedConfigurable == null || !Comparing.strEqual((String)selectedConfigurable.getDisplayName(), (String)name)) {
                        this.selectNodeInTree(node);
                    }
                    throw new ConfigurationException(UIBundle.message("master.detail.err.duplicate", prefix, name), title);
                }
                names.add(name);
            }
            if (!recursively) continue;
            this.checkForEmptyAndDuplicatedNames(node, prefix, title, configurableClass, true);
        }
    }

    public Tree getTree() {
        return this.myTree;
    }

    protected void removePaths(TreePath ... paths) {
        ArrayList<MyNode> nodes = new ArrayList<MyNode>();
        for (TreePath path : paths) {
            nodes.add((MyNode)path.getLastPathComponent());
        }
        this.removeNodes(nodes);
    }

    protected void removeNodes(List<? extends MyNode> nodes) {
        DefaultMutableTreeNode parentNode = null;
        int idx = -1;
        for (MyNode myNode : nodes) {
            NamedConfigurable namedConfigurable = myNode.getConfigurable();
            Object editableObject = namedConfigurable.getEditableObject();
            parentNode = (MyNode)myNode.getParent();
            if (parentNode == null) continue;
            idx = parentNode.getIndex(myNode);
            ((DefaultTreeModel)this.myTree.getModel()).removeNodeFromParent(myNode);
            this.myHasDeletedItems |= this.wasObjectStored(editableObject);
            this.fireItemsChangeListener(editableObject);
            this.onItemDeleted(editableObject);
            namedConfigurable.disposeUIResources();
        }
        if (!nodes.isEmpty()) {
            if (parentNode != null && idx != -1) {
                DefaultMutableTreeNode toSelect = null;
                if (idx < parentNode.getChildCount()) {
                    toSelect = (DefaultMutableTreeNode)parentNode.getChildAt(idx);
                } else if (idx > 0 && parentNode.getChildCount() > 0) {
                    toSelect = idx - 1 < parentNode.getChildCount() ? (DefaultMutableTreeNode)parentNode.getChildAt(idx - 1) : (DefaultMutableTreeNode)parentNode.getFirstChild();
                } else if (parentNode.isRoot() && this.myTree.isRootVisible()) {
                    toSelect = parentNode;
                } else if (parentNode.getChildCount() > 0) {
                    toSelect = (DefaultMutableTreeNode)parentNode.getFirstChild();
                }
                if (toSelect != null) {
                    TreeUtil.selectInTree(toSelect, true, this.myTree);
                }
            } else {
                TreeUtil.promiseSelectFirst(this.myTree);
            }
        }
    }

    protected void onItemDeleted(Object item) {
    }

    protected static Predicate<Object[]> forAll(@NotNull Predicate<Object> condition) {
        if (condition == null) {
            MasterDetailsComponent.$$$reportNull$$$0(1);
        }
        return objects -> {
            for (Object object : objects) {
                if (condition.test(object)) continue;
                return false;
            }
            return true;
        };
    }

    @Override
    public JComponent getToolbar() {
        this.myToReInitWholePanel = true;
        return this.myNorthPanel;
    }

    @Override
    public JComponent getMaster() {
        this.myToReInitWholePanel = true;
        return this.myMaster;
    }

    @Override
    public DetailsComponent getDetails() {
        this.myToReInitWholePanel = true;
        return this.myDetails;
    }

    @Override
    public void initUi() {
        this.createComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/MasterDetailsComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/MasterDetailsComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forAll";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    protected static class MyRootNode
    extends MyNode {
        public MyRootNode() {
            super(new NamedConfigurable(false, null){

                @Override
                public void setDisplayName(String name) {
                }

                public Object getEditableObject() {
                    return null;
                }

                @Override
                public String getBannerSlogan() {
                    return null;
                }

                public String getDisplayName() {
                    return "";
                }

                @Override
                public JComponent createOptionsPanel() {
                    return null;
                }

                public boolean isModified() {
                    return false;
                }

                public void apply() {
                }
            }, false);
        }
    }

    public static class MyNode
    extends DefaultMutableTreeNode {
        private boolean myDisplayInBold;

        public MyNode(@NotNull NamedConfigurable userObject) {
            if (userObject == null) {
                MyNode.$$$reportNull$$$0(0);
            }
            super(userObject);
        }

        public MyNode(@NotNull NamedConfigurable userObject, boolean displayInBold) {
            if (userObject == null) {
                MyNode.$$$reportNull$$$0(1);
            }
            super(userObject);
            this.myDisplayInBold = displayInBold;
        }

        @NotNull
        @NlsSafe
        public String getDisplayName() {
            NamedConfigurable configurable = (NamedConfigurable)this.getUserObject();
            if (configurable != null) {
                String string = configurable.getDisplayName();
                if (string == null) {
                    MyNode.$$$reportNull$$$0(2);
                }
                return string;
            }
            LOG.debug("Tree was already disposed");
            return "DISPOSED";
        }

        @NlsContexts.PopupTitle
        @Nullable
        public String getLocationString() {
            return null;
        }

        public NamedConfigurable getConfigurable() {
            return (NamedConfigurable)this.getUserObject();
        }

        public boolean isDisplayInBold() {
            return this.myDisplayInBold;
        }

        public void setDisplayInBold(boolean displayInBold) {
            this.myDisplayInBold = displayInBold;
        }

        @Nullable
        public Icon getIcon(boolean expanded) {
            NamedConfigurable configurable = this.getConfigurable();
            if (configurable != null) {
                return configurable.getIcon(expanded);
            }
            return null;
        }

        protected void reloadNode(DefaultTreeModel treeModel) {
            treeModel.reload(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userObject";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/MasterDetailsComponent$MyNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/MasterDetailsComponent$MyNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class MyColoredTreeCellRenderer
    extends ColoredTreeCellRenderer {
        @Override
        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyColoredTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (value2 instanceof MyNode) {
                MyNode node = (MyNode)value2;
                this.renderIcon(node, expanded);
                this.renderName(node);
            }
        }

        protected void renderIcon(@NotNull MyNode node, boolean expanded) {
            if (node == null) {
                MyColoredTreeCellRenderer.$$$reportNull$$$0(1);
            }
            this.setIcon(node.getIcon(expanded));
        }

        protected void renderName(@NotNull MyNode node) {
            if (node == null) {
                MyColoredTreeCellRenderer.$$$reportNull$$$0(2);
            }
            Font font = UIUtil.getTreeFont();
            if (node.isDisplayInBold()) {
                this.setFont(font.deriveFont(1));
            } else {
                this.setFont(font.deriveFont(0));
            }
            SimpleTextAttributes attributes = node.isDisplayInBold() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            this.append(node.getDisplayName(), SimpleTextAttributes.merge((SimpleTextAttributes)this.getAdditionalAttributes(node), (SimpleTextAttributes)attributes));
            String locationString = node.getLocationString();
            if (locationString != null) {
                this.append(" ");
                this.append(locationString, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }

        @NotNull
        protected SimpleTextAttributes getAdditionalAttributes(@NotNull MyNode node) {
            if (node == null) {
                MyColoredTreeCellRenderer.$$$reportNull$$$0(3);
            }
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                MyColoredTreeCellRenderer.$$$reportNull$$$0(4);
            }
            return simpleTextAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/MasterDetailsComponent$MyColoredTreeCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/MasterDetailsComponent$MyColoredTreeCellRenderer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdditionalAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "renderIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "renderName";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getAdditionalAttributes";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    protected static interface ItemsChangeListener {
        public void itemChanged(@Nullable Object var1);

        default public void itemsExternallyChanged() {
        }
    }

    public static interface ActionGroupWithPreselection {
        public ActionGroup getActionGroup();

        default public int getDefaultIndex() {
            return 0;
        }
    }

    protected class MyActionGroupWrapper
    extends AnAction
    implements DumbAware {
        private final ActionGroup myActionGroup;
        private ActionGroupWithPreselection myPreselection;

        public MyActionGroupWrapper(ActionGroupWithPreselection actionGroup) {
            this(actionGroup.getActionGroup());
            this.myPreselection = actionGroup;
        }

        public MyActionGroupWrapper(ActionGroup actionGroup) {
            super(actionGroup.getTemplatePresentation().getText(), actionGroup.getTemplatePresentation().getDescription(), actionGroup.getTemplatePresentation().getIcon());
            this.myActionGroup = actionGroup;
            this.registerCustomShortcutSet(actionGroup.getShortcutSet(), MasterDetailsComponent.this.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyActionGroupWrapper.$$$reportNull$$$0(0);
            }
            JBPopupFactory popupFactory = JBPopupFactory.getInstance();
            DataContext dataContext = e.getDataContext();
            ListPopupStep step = popupFactory.createActionsStep(this.myActionGroup, dataContext, null, false, false, this.myActionGroup.getTemplatePresentation().getText(), MasterDetailsComponent.this.myTree, true, this.myPreselection != null ? this.myPreselection.getDefaultIndex() : 0, true);
            ListPopup listPopup = popupFactory.createListPopup(step);
            listPopup.setHandleAutoSelectionBeforeShow(true);
            listPopup.show(JBPopupFactory.getInstance().guessBestPopupLocation(this, e));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/MasterDetailsComponent$MyActionGroupWrapper", "actionPerformed"));
        }
    }

    protected class MyDeleteAction
    extends AnAction
    implements DumbAware {
        @Nullable
        private final Predicate<Object[]> myCondition;

        public MyDeleteAction() {
            this(null);
        }

        public MyDeleteAction(Predicate<Object[]> availableCondition) {
            super(CommonBundle.messagePointer((String)"button.delete", (Object[])new Object[0]), CommonBundle.messagePointer((String)"button.delete", (Object[])new Object[0]), PlatformIcons.DELETE_ICON);
            this.registerCustomShortcutSet(CommonActionsPanel.getCommonShortcut(CommonActionsPanel.Buttons.REMOVE), MasterDetailsComponent.this.myTree);
            this.myCondition = availableCondition;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDeleteAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            TreePath[] selectionPath = MasterDetailsComponent.this.myTree.getSelectionPaths();
            if (selectionPath == null) {
                return;
            }
            if (this.myCondition != null) {
                Object[] result2 = new Object[selectionPath.length];
                for (int i = 0; i < selectionPath.length; ++i) {
                    result2[i] = selectionPath[i].getLastPathComponent();
                }
                if (!this.myCondition.test(result2)) {
                    return;
                }
            }
            presentation.setEnabled(true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyDeleteAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDeleteAction.$$$reportNull$$$0(2);
            }
            MasterDetailsComponent.this.removePaths(MasterDetailsComponent.this.myTree.getSelectionPaths());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/MasterDetailsComponent$MyDeleteAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/MasterDetailsComponent$MyDeleteAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

