/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SelectFromListDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(SelectFromListDialog.class);
    private final ToStringAspect myToStringAspect;
    private final DefaultListModel<Object> myModel = new DefaultListModel();
    private final JList<Object> myList = new JBList<Object>((ListModel<Object>)this.myModel);
    private final JPanel myMainPanel = new JPanel(new BorderLayout());

    public SelectFromListDialog(Project project, Object[] objects, ToStringAspect toStringAspect, @NlsContexts.DialogTitle String title, @JdkConstants.ListSelectionMode int selectionMode) {
        super(project, true);
        this.myToStringAspect = toStringAspect;
        this.myList.setSelectionMode(selectionMode);
        this.setTitle(title);
        for (Object object : objects) {
            this.myModel.addElement(object);
        }
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectFromListDialog.this.setOKActionEnabled(SelectFromListDialog.this.myList.getSelectedValues().length > 0);
            }
        });
        this.myList.setSelectedIndex(0);
        this.myList.setCellRenderer(SimpleListCellRenderer.create("", this.myToStringAspect::getToStirng));
        this.init();
    }

    @Override
    protected JComponent createCenterPanel() {
        this.myMainPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myList), "Center");
        return this.myMainPanel;
    }

    public void addToDialog(JComponent userComponent, @NonNls @NotNull String borderLayoutConstraints) {
        if (borderLayoutConstraints == null) {
            SelectFromListDialog.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(!borderLayoutConstraints.equals("Center"), (Object)"Can't add any component to center");
        this.myMainPanel.add((Component)userComponent, borderLayoutConstraints);
    }

    public void setSelection(String defaultLocation) {
        int index = this.myModel.indexOf(defaultLocation);
        if (index >= 0) {
            this.myList.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public Object[] getSelection() {
        if (!this.isOK()) {
            return null;
        }
        return this.myList.getSelectedValues();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "borderLayoutConstraints", "com/intellij/openapi/ui/SelectFromListDialog", "addToDialog"));
    }

    public static interface ToStringAspect {
        public String getToStirng(Object var1);
    }
}

