/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneScrolledState;
import com.intellij.ui.ScrollPaneTracker;
import com.intellij.ui.ScrollableContentBorder;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class SimpleToolWindowPanel
extends JBPanelWithEmptyText
implements QuickActionProvider,
UiCompatibleDataProvider {
    public static final Key<Boolean> SCROLLED_STATE = Key.create((String)"ScrolledState");
    private static final int GAP = 1;
    private JComponent myToolbar;
    private JComponent myContent;
    private final boolean myBorderless;
    protected boolean myVertical;
    private boolean myProvideQuickActions = true;
    @Nullable
    private ScrollPaneTracker myScrollPaneTracker;

    public SimpleToolWindowPanel(boolean vertical) {
        this(vertical, false);
    }

    public SimpleToolWindowPanel(boolean vertical, boolean borderless) {
        this.myBorderless = borderless;
        this.myVertical = vertical;
        this.updateLayout();
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof Container) {
                    ((Container)child).addContainerListener(this);
                }
                if (SimpleToolWindowPanel.this.myBorderless) {
                    UIUtil.removeScrollBorder((Component)((Object)SimpleToolWindowPanel.this));
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof Container) {
                    ((Container)child).removeContainerListener(this);
                }
            }
        });
        if (ExperimentalUI.isNewUI()) {
            this.myScrollPaneTracker = new ScrollPaneTracker((Component)((Object)this), (Function1<? super JScrollPane, Boolean>)((Function1)this::isInContent), (Function1<? super ScrollPaneTracker, Unit>)((Function1)tracker -> {
                this.updateScrolledState();
                return Unit.INSTANCE;
            }));
        }
    }

    private boolean isInContent(@NotNull Component component) {
        if (component == null) {
            SimpleToolWindowPanel.$$$reportNull$$$0(0);
        }
        for (Component parent = component; parent != null; parent = parent.getParent()) {
            if (parent == this.myToolbar) {
                return false;
            }
            if (parent != this.myContent) continue;
            return true;
        }
        return false;
    }

    public boolean isVertical() {
        return this.myVertical;
    }

    public void setVertical(boolean vertical) {
        if (this.myVertical == vertical) {
            return;
        }
        this.removeAll();
        this.myVertical = vertical;
        this.updateLayout();
        this.setContent(this.myContent);
        this.setToolbar(this.myToolbar);
    }

    public boolean isToolbarVisible() {
        return this.myToolbar != null && this.myToolbar.isVisible();
    }

    @Nullable
    public JComponent getToolbar() {
        return this.myToolbar;
    }

    private void updateLayout() {
        this.setLayout(new BorderLayout(this.myVertical ? 0 : 1, this.myVertical ? 1 : 0));
    }

    public void setToolbar(@Nullable JComponent c) {
        JComponent toolbar;
        if (c == null && (toolbar = this.myToolbar) != null) {
            this.remove(toolbar);
        }
        this.myToolbar = c;
        if (this.myToolbar instanceof ActionToolbar) {
            ((ActionToolbar)this.myToolbar).setOrientation(this.myVertical ? 0 : 1);
        }
        if (c != null) {
            if (this.myVertical) {
                this.add(c, "North");
            } else {
                this.add(c, "West");
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            SimpleToolWindowPanel.$$$reportNull$$$0(1);
        }
        if (this.myProvideQuickActions) {
            sink.set(QuickActionProvider.KEY, (Object)this);
        }
    }

    public SimpleToolWindowPanel setProvideQuickActions(boolean provide) {
        this.myProvideQuickActions = provide;
        return this;
    }

    public @Unmodifiable @NotNull List<AnAction> getActions(boolean originalProvider) {
        return SimpleToolWindowPanel.collectActions(this.myToolbar);
    }

    public JComponent getComponent() {
        return this;
    }

    @Nullable
    public JComponent getContent() {
        return this.myContent;
    }

    public void setContent(@NotNull JComponent c) {
        if (c == null) {
            SimpleToolWindowPanel.$$$reportNull$$$0(2);
        }
        if (this.myContent != null) {
            ClientProperty.remove((JComponent)this.myContent, SCROLLED_STATE);
            this.remove(this.myContent);
        }
        this.myContent = c;
        this.add(c, "Center");
        if (this.myBorderless) {
            UIUtil.removeScrollBorder((Component)c);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myToolbar != null && this.myToolbar.getParent() == this && this.myContent != null && this.myContent.getParent() == this) {
            g.setColor(JBColor.border());
            if (ExperimentalUI.isNewUI() && !this.isScrolled()) {
                return;
            }
            if (this.myVertical) {
                int y = (int)this.myToolbar.getBounds().getMaxY();
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)y, (double)this.getWidth(), (double)y);
            } else {
                int x = (int)this.myToolbar.getBounds().getMaxX();
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)0.0, (double)x, (double)this.getHeight());
            }
        }
    }

    public static @Unmodifiable @NotNull List<AnAction> collectActions(@Nullable JComponent component) {
        List list = UIUtil.uiTraverser((Component)component).traverse().filter(ActionToolbar.class).map(ActionToolbar::getActionGroup).filter(AnAction.class).toList();
        if (list == null) {
            SimpleToolWindowPanel.$$$reportNull$$$0(3);
        }
        return list;
    }

    private void updateScrolledState() {
        if (this.myContent == null || this.myScrollPaneTracker == null) {
            return;
        }
        boolean oldState = this.isScrolled();
        boolean newState = false;
        for (ScrollPaneScrolledState scrollPaneState : this.myScrollPaneTracker.getScrollPaneStates()) {
            boolean scrolled;
            JScrollPane scrollPane2 = scrollPaneState.getScrollPane();
            boolean bl = this.myVertical ? !scrollPaneState.getState().isVerticalAtStart() : (scrolled = !scrollPaneState.getState().isHorizontalAtStart());
            if (!this.isTouchingToolbar(scrollPane2) || !scrolled) continue;
            newState = true;
            break;
        }
        if (newState != oldState) {
            ClientProperty.put((JComponent)this.myContent, SCROLLED_STATE, (Object)newState);
            this.repaint();
        }
        Key<Boolean> key = this.myVertical ? ScrollableContentBorder.TOOLBAR_WITH_BORDER_ABOVE : ScrollableContentBorder.TOOLBAR_WITH_BORDER_LEFT;
        for (ScrollPaneScrolledState scrollPaneState : this.myScrollPaneTracker.getScrollPaneStates()) {
            JComponent targetComponent = ScrollableContentBorder.getTargetComponent(scrollPaneState.getScrollPane());
            if (targetComponent == null) continue;
            boolean hadToolbarWithBorder = ClientProperty.isTrue((Component)targetComponent, key);
            boolean hasToolbarWithBorder = this.isTouchingToolbar(targetComponent) && (!ExperimentalUI.isNewUI() || newState);
            if (hasToolbarWithBorder == hadToolbarWithBorder) continue;
            ClientProperty.put((JComponent)targetComponent, key, (Object)hasToolbarWithBorder);
            targetComponent.repaint();
        }
    }

    private boolean isScrolled() {
        return ClientProperty.isTrue((Component)this.myContent, SCROLLED_STATE);
    }

    private boolean isTouchingToolbar(JComponent component) {
        JComponent toolbar = this.getToolbar();
        if (toolbar == null || !toolbar.isVisible() || !component.isShowing()) {
            return false;
        }
        Rectangle toolbarBounds = SwingUtilities.convertRectangle(toolbar.getParent(), toolbar.getBounds(), (Component)((Object)this));
        int expectedCoordinate = (this.myVertical ? toolbarBounds.y + toolbarBounds.height : toolbarBounds.x + toolbarBounds.width) + 1;
        Point paneLocation = SwingUtilities.convertPoint(component.getParent(), component.getLocation(), (Component)((Object)this));
        int actualCoordinate = this.myVertical ? paneLocation.y : paneLocation.x;
        return expectedCoordinate == actualCoordinate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/SimpleToolWindowPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/SimpleToolWindowPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

